/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.cm.server.functionSteps;

import com.cognos.cm.request.customFunctions.CustomFunctionPlugin;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMIndentedPrintStream;
import com.ibm.cognos.pdc.cm.server.functionSteps.AbstractDiagnosticsFunctionStep;
import com.ibm.cognos.pdc.core.ICounter;
import com.ibm.cognos.pdc.core.PDCClock;
import com.ibm.cognos.pdc.core.diagnostics.AgeStatistics;
import com.ibm.cognos.pdc.core.diagnostics.DiagnosticGrid;
import com.ibm.cognos.pdc.core.diagnostics.DiagnosticMap;
import com.ibm.cognos.pdc.core.diagnostics.SizeStatistics;
import java.io.OutputStream;
import java.util.List;
import org.xml.sax.SAXException;

public class ViewDiagnosticsFunctionStep
extends AbstractDiagnosticsFunctionStep {
    private AgeStatisticsOptions ageStatisticsOptions;
    private boolean includeSizeStatistics;
    private AgeStatistics.CreationTimeHandler creationTimeHandler = new AgeStatistics.CreationTimeHandler();
    private AgeStatistics.ModificationTimeHandler modificationTimeHandler = new AgeStatistics.ModificationTimeHandler();
    private AgeStatistics.LastAccessTimeHandler lastAccessTimeHandler = new AgeStatistics.LastAccessTimeHandler();

    public ViewDiagnosticsFunctionStep(String _name, String _id, CustomFunctionPlugin _plugin, XMLElement stepSpecification) throws CMException {
        super(_name, _id, _plugin, stepSpecification);
    }

    @Override
    protected void initialize() {
        this.ageStatisticsOptions = AgeStatisticsOptions.None;
    }

    @Override
    protected void parseOptions(XMLElement optionsElement) throws CMException {
        super.parseOptions(optionsElement);
        this.ageStatisticsOptions = this.getAgeStatisticsOption(optionsElement);
        if (optionsElement.getOptionalChildWithName("sizeStatistics") != null) {
            this.includeSizeStatistics = true;
        }
    }

    private AgeStatisticsOptions getAgeStatisticsOption(XMLElement element) {
        AgeStatisticsOptions options = AgeStatisticsOptions.None;
        XMLElement ageStatistics = element.getOptionalChildWithName("ageStatistics");
        if (ageStatistics != null) {
            options = AgeStatisticsOptions.DoNotIncludeAverage;
            String includeAverageAtt = ageStatistics.getAttribute("includeAverages");
            if (includeAverageAtt != null && Boolean.parseBoolean(includeAverageAtt)) {
                options = AgeStatisticsOptions.All;
            }
        }
        return options;
    }

    @Override
    public void runFunctionStep(OutputStream os) throws SAXException, CMException {
        CMIndentedPrintStream out = new CMIndentedPrintStream(os);
        out.println("<result>");
        out.indent();
        if (!this.globalCounters.isEmpty()) {
            this.outputGlobalCounters(out);
        }
        if (!this.grids.isEmpty()) {
            this.outputGrids(out);
        }
        out.unindent();
        out.println("</result>");
    }

    private void outputGrids(CMIndentedPrintStream out) {
        out.println("<grids>");
        out.indent();
        for (DiagnosticGrid grid : this.grids) {
            this.outputGrid(out, grid);
        }
        out.unindent();
        out.println("</grids>");
    }

    private void outputGrid(CMIndentedPrintStream out, DiagnosticGrid grid) {
        out.println("<grid id=\"" + grid.getId() + "\">");
        out.indent();
        List maps = grid.getMaps();
        if (!maps.isEmpty()) {
            out.println("<maps>");
            out.indent();
            for (DiagnosticMap map : maps) {
                this.outputMap(out, map);
            }
            out.unindent();
            out.println("</maps>");
        }
        out.unindent();
        out.println("</grid>");
    }

    private void outputMap(CMIndentedPrintStream out, DiagnosticMap map) {
        out.println("<map id=\"" + map.getId() + "\">");
        out.indent();
        if (this.allMapCounters) {
            this.outputAllMapCounters(out, map);
        } else if (!this.mapCounters.isEmpty()) {
            this.outputMapCounters(out, map);
        }
        if (this.ageStatisticsOptions != AgeStatisticsOptions.None) {
            this.outputAgeStatistics(out, map);
        }
        if (this.includeSizeStatistics) {
            this.outputSizeStatistics(out, map);
        }
        out.unindent();
        out.println("</map>");
    }

    private void outputAllMapCounters(CMIndentedPrintStream out, DiagnosticMap map) {
        out.println("<counters>");
        out.indent();
        List counters = map.getCounters();
        for (ICounter mapCounter : counters) {
            this.outputCounter(out, mapCounter);
        }
        out.unindent();
        out.println("</counters>");
    }

    private void outputSizeStatistics(CMIndentedPrintStream out, DiagnosticMap map) {
        SizeStatistics sizeStats = map.getSizeStatistics();
        if (sizeStats == null) {
            return;
        }
        out.println("<sizeStatistics>");
        out.indent();
        out.println("<totalMapSize>" + sizeStats.getTotalSize() + "</totalMapSize>");
        out.println("<totalKeySize>" + sizeStats.getTotalKeySize() + "</totalKeySize>");
        out.println("<totalValueSize>" + sizeStats.getTotalValueSize() + "</totalValueSize>");
        out.println("<averageKeySize>" + sizeStats.getAverageKeySize() + "</averageKeySize>");
        out.println("<averageValueSize>" + sizeStats.getAverageValueSize() + "</averageValueSize>");
        out.println("<largestValueSize>" + sizeStats.getLargestValueSize() + "</largestValueSize>");
        out.println("<smallestValueSize>" + sizeStats.getSmallestValueSize() + "</smallestValueSize>");
        out.unindent();
        out.println("</sizeStatistics>");
    }

    private void outputMapCounters(CMIndentedPrintStream out, DiagnosticMap map) {
        out.println("<counters>");
        out.indent();
        for (String counterName : this.mapCounters) {
            ICounter mapCounter = map.getCounter(counterName);
            if (mapCounter == null) continue;
            this.outputCounter(out, mapCounter);
        }
        out.unindent();
        out.println("</counters>");
    }

    private void outputAgeStatistics(CMIndentedPrintStream out, DiagnosticMap map) {
        AgeStatistics stats = map.getAgeStatistics();
        if (stats == null) {
            return;
        }
        out.println("<ageStatistics>");
        out.indent();
        long currentTime = PDCClock.getCurrentTimeMillis();
        this.outputCreationTime(out, stats, currentTime);
        this.outputModificationTime(out, stats, currentTime);
        this.outputLastAccessTime(out, stats, currentTime);
        out.unindent();
        out.println("</ageStatistics>");
    }

    private void outputLastAccessTime(CMIndentedPrintStream out, AgeStatistics stats, long currentTime) {
        out.println("<lastAccessTime>");
        out.indent();
        this.outputTime(out, "oldest", currentTime, stats.getOldestByLastAccessTime(), (AgeStatistics.AgeStatsFieldHandler)this.lastAccessTimeHandler);
        this.outputTime(out, "youngest", currentTime, stats.getYoungestByLastAccessTime(), (AgeStatistics.AgeStatsFieldHandler)this.lastAccessTimeHandler);
        if (this.ageStatisticsOptions == AgeStatisticsOptions.All) {
            Double average = stats.getAverageLastAccessTime();
            out.print("<average>");
            out.print(average == null ? "" : Double.valueOf((double)currentTime - average));
            out.println("</average>");
        }
        out.unindent();
        out.println("</lastAccessTime>");
    }

    private void outputModificationTime(CMIndentedPrintStream out, AgeStatistics stats, long currentTime) {
        out.println("<modificationTime>");
        out.indent();
        this.outputTime(out, "oldest", currentTime, stats.getOldestByModificationTime(), (AgeStatistics.AgeStatsFieldHandler)this.modificationTimeHandler);
        this.outputTime(out, "youngest", currentTime, stats.getYoungestByModificationTime(), (AgeStatistics.AgeStatsFieldHandler)this.modificationTimeHandler);
        if (this.ageStatisticsOptions == AgeStatisticsOptions.All) {
            Double average = stats.getAverageModificationTime();
            out.print("<average>");
            out.print(average == null ? "" : Double.valueOf((double)currentTime - average));
            out.println("</average>");
        }
        out.unindent();
        out.println("</modificationTime>");
    }

    private void outputCreationTime(CMIndentedPrintStream out, AgeStatistics stats, long currentTime) {
        out.println("<creationTime>");
        out.indent();
        this.outputTime(out, "oldest", currentTime, stats.getOldestByCreationTime(), (AgeStatistics.AgeStatsFieldHandler)this.creationTimeHandler);
        this.outputTime(out, "youngest", currentTime, stats.getYoungestByCreationTime(), (AgeStatistics.AgeStatsFieldHandler)this.creationTimeHandler);
        if (this.ageStatisticsOptions == AgeStatisticsOptions.All) {
            Double average = stats.getAverageCreationTime();
            out.print("<average>");
            out.print(average == null ? "" : Double.valueOf((double)currentTime - average));
            out.println("</average>");
        }
        out.unindent();
        out.println("</creationTime>");
    }

    private void outputTime(CMIndentedPrintStream out, String caption, long currentTime, AgeStatistics.AgeStats stats, AgeStatistics.AgeStatsFieldHandler handler) {
        out.print("<" + caption + ">");
        if (stats != null) {
            out.print(currentTime - handler.getValue(stats));
        }
        out.println("</" + caption + ">");
    }

    private void outputGlobalCounters(CMIndentedPrintStream out) {
        out.println("<global>");
        out.indent();
        out.println("<counters>");
        out.indent();
        for (ICounter counter : this.globalCounters) {
            if (counter == null) continue;
            this.outputCounter(out, counter);
        }
        out.unindent();
        out.println("</counters>");
        out.unindent();
        out.println("</global>");
    }

    private void outputCounter(CMIndentedPrintStream out, ICounter counter) {
        out.println("<counter id=\"" + counter.getName() + "\">");
        out.indent();
        out.print("<value>");
        out.print(Long.toString(counter.getValue()));
        out.println("</value>");
        out.unindent();
        out.println("</counter>");
    }

    static enum AgeStatisticsOptions {
        None,
        DoNotIncludeAverage,
        All;

    }
}

