/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.common.logging;

import com.cognos.portal.common.logging.ServiceLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogRecorder
implements ServiceLogger,
Cloneable {
    ServiceLogger target;
    StringBuffer buffer;
    int captureLevel;

    public LogRecorder(ServiceLogger target, int level) {
        this.target = target;
        this.buffer = new StringBuffer();
        this.captureLevel = level;
    }

    public String getContent() {
        return this.buffer.toString();
    }

    @Override
    public ServiceLogger cloneForClass(Class className) {
        return this.cloneForClass(className, null);
    }

    @Override
    public ServiceLogger cloneForClass(Class className, String category) {
        LogRecorder clone = new LogRecorder(this.target.cloneForClass(className, category), this.captureLevel);
        clone.buffer = this.buffer;
        return clone;
    }

    @Override
    public void debug(String message) {
        if (this.target.isDebugEnabled()) {
            this.target.debug(message);
        }
        this.log("DEBUG: " + message, 3);
    }

    @Override
    public void enter(String method) {
        if (this.target.isDebugEnabled()) {
            this.target.enter(method);
        }
        this.log("ENTER: " + method, 3);
    }

    @Override
    public void enter(String method, Object[] objects) {
        if (this.target.isDebugEnabled()) {
            this.target.enter(method, objects);
        }
        this.log("ENTER: " + method + "(" + objects.toString() + ")", 3);
    }

    @Override
    public void error(String message) {
        if (this.target.isErrorEnabled()) {
            this.target.error(message);
        }
        this.log("ERROR: " + message, 0);
    }

    @Override
    public void error(String message, Throwable cause) {
        if (this.target.isErrorEnabled()) {
            this.target.error(message, cause);
        }
        StringWriter tmp = new StringWriter();
        PrintWriter pwrt = new PrintWriter(tmp);
        if (cause != null) {
            cause.printStackTrace(pwrt);
        }
        this.log("ERROR: " + message + "\nStacktrace: " + tmp.toString(), 0);
    }

    @Override
    public void exit(String method) {
        if (this.target.isDebugEnabled()) {
            this.target.exit(method);
        }
        this.log("EXIT: " + method, 3);
    }

    @Override
    public void exit(String method, Object[] objects) {
        if (this.target.isDebugEnabled()) {
            this.target.exit(method, objects);
        }
        this.log("EXIT: " + method + " returning " + objects.toString(), 3);
    }

    @Override
    public void info(String message) {
        if (this.target.isInfoEnabled()) {
            this.target.info(message);
        }
        this.log("INFO: " + message, 2);
    }

    @Override
    public boolean isAuditLevelEnabled(int level) {
        return this.target.isAuditLevelEnabled(level);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.captureLevel >= 3;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.captureLevel >= 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.captureLevel >= 2;
    }

    @Override
    public boolean isPerfLevelEnabled(int level) {
        return this.target.isPerfLevelEnabled(level);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.captureLevel >= 1;
    }

    @Override
    public void logAudit(int level, int operation, String message) {
        this.target.logAudit(level, operation, message);
    }

    @Override
    public Object startTimer(int level, String method, String description, Object obj) {
        return this.target.startTimer(level, method, description, obj);
    }

    @Override
    public void stopTimer(Object timer) {
        this.target.stopTimer(timer);
    }

    @Override
    public void warn(String message) {
        if (this.target.isWarnEnabled()) {
            this.target.warn(message);
        }
        this.log("WARN: " + message, 1);
    }

    protected void log(String tracemsg, int level) {
        if (this.captureLevel >= level) {
            this.buffer.append(tracemsg);
            this.buffer.append("\n");
        }
    }
}

