/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.common.logging;

import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogResourceCounterSet;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.utils.ThreadLocalPropertyManager;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ServiceLoggerImpl
implements ServiceLogger,
Cloneable {
    private LogTypedLogger m_traceLogger = null;
    private LogTypedLogger m_auditLogger = null;
    protected LogTypedLogger m_perfLogger = null;
    protected String m_className;
    protected static final String COMPONENT = "portal";
    private static final String TRACE_HEADER = "<trace>";
    private static final String TRACE_FOOTER = "</trace>";
    public static final String REQUEST_ID = "requestId";
    public static final String SESSION_ID = "sessionId";

    private ServiceLoggerImpl() {
    }

    public static void setRequestId(String requestId) {
        ThreadLocalPropertyManager.set(REQUEST_ID, requestId);
    }

    public static void setSessionId(String sessionId) {
        ThreadLocalPropertyManager.set(SESSION_ID, sessionId);
    }

    public static String getRequestId() {
        return (String)ThreadLocalPropertyManager.get(REQUEST_ID);
    }

    public static String getSessionId() {
        return (String)ThreadLocalPropertyManager.get(SESSION_ID);
    }

    public ServiceLoggerImpl(Class className) {
        this(className, null);
    }

    public ServiceLoggerImpl(Class className, String category) {
        String loggerName = category == null ? COMPONENT : "portal." + category;
        this.m_traceLogger = LogTypedLogger.getInstance((String)("Trace." + loggerName), LogTraceIndication.class);
        this.m_auditLogger = LogTypedLogger.getInstance((String)("Audit." + loggerName), LogAuditIndication.class);
        this.m_perfLogger = LogTypedLogger.getInstance((String)("Perf." + loggerName), LogPerfIndication.class);
        this.m_className = className.getName();
    }

    @Override
    public void error(String message) {
        this.log("ERROR: " + message, 50000);
    }

    @Override
    public void error(String message, Throwable cause) {
        StringWriter tmp = new StringWriter();
        PrintWriter pwrt = new PrintWriter(tmp);
        if (cause != null) {
            cause.printStackTrace(pwrt);
        }
        this.log("ERROR: " + message + "\nStacktrace: " + tmp.toString(), 50000);
    }

    @Override
    public void warn(String message) {
        this.log("WARN: " + message, 40000);
    }

    @Override
    public void info(String message) {
        this.log("INFO: " + message, 30000);
    }

    @Override
    public void debug(String message) {
        this.log("DEBUG: " + message, 20000);
    }

    @Override
    public void enter(String method) {
        this.log("ENTER: " + method, 20000);
    }

    @Override
    public void enter(String method, Object[] objects) {
        this.log("ENTER: " + method + "(" + objects.toString() + ")", 20000);
    }

    @Override
    public void exit(String method) {
        this.log("EXIT: " + method, 20000);
    }

    @Override
    public void exit(String method, Object[] objects) {
        this.log("EXIT: " + method + " returning " + objects.toString(), 20000);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(50000);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(40000);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(30000);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_traceLogger != null && this.m_traceLogger.isEnabled(20000);
    }

    @Override
    public ServiceLogger cloneForClass(Class className) {
        try {
            ServiceLoggerImpl newCopy = (ServiceLoggerImpl)this.clone();
            newCopy.m_className = className != null ? className.getName() : null;
            return newCopy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public ServiceLogger cloneForClass(Class className, String category) {
        return new ServiceLoggerImpl(className, category);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void log(String tracemsg, int level) {
        if (this.m_traceLogger == null) {
            return;
        }
        LogTraceIndication indication = new LogTraceIndication(COMPONENT, 0);
        indication.setObject(this.m_className != null ? this.m_className : COMPONENT);
        indication.setAction((byte)11);
        indication.setLevel(level);
        indication.setMessage(TRACE_HEADER + tracemsg + TRACE_FOOTER);
        indication.setRequestID((String)ThreadLocalPropertyManager.get(REQUEST_ID));
        indication.setSessionID((String)ThreadLocalPropertyManager.get(SESSION_ID));
        this.m_traceLogger.log((Object)indication);
    }

    @Override
    public boolean isAuditLevelEnabled(int level) {
        return this.m_auditLogger != null && this.m_auditLogger.isEnabled(this.getIPFLevel(level));
    }

    @Override
    public void logAudit(int level, int operation, String message) {
        if (this.m_auditLogger == null) {
            return;
        }
        LogAuditIndication indication = new LogAuditIndication(COMPONENT, 0);
        indication.setLevel(this.getIPFLevel(level));
        indication.setOperation(this.getIPFOperation(operation));
        indication.setLogData(message);
        indication.setRequestID((String)ThreadLocalPropertyManager.get(REQUEST_ID));
        indication.setSessionID((String)ThreadLocalPropertyManager.get(SESSION_ID));
        this.m_auditLogger.log((Object)indication);
    }

    @Override
    public boolean isPerfLevelEnabled(int level) {
        return this.m_perfLogger != null && this.m_perfLogger.isEnabled(this.getIPFLevel(level));
    }

    @Override
    public Object startTimer(int level, String method, String description, Object obj) {
        if (this.m_perfLogger == null) {
            return null;
        }
        LogResourceCounterSet counter = new LogResourceCounterSet("Execution", null);
        LogPerfIndication indication = new LogPerfIndication(COMPONENT, 0, counter);
        indication.setLevel(this.getIPFLevel(level));
        indication.setClassId(this.m_className != null ? this.m_className : COMPONENT);
        indication.setMethodId(method);
        indication.setLogData(description);
        indication.setStatus("START");
        indication.setTime(System.currentTimeMillis());
        indication.setRequestID((String)ThreadLocalPropertyManager.get(REQUEST_ID));
        indication.setSessionID((String)ThreadLocalPropertyManager.get(SESSION_ID));
        this.m_perfLogger.log((Object)indication);
        counter.enableResourceCounter();
        return indication;
    }

    @Override
    public void stopTimer(Object timer) {
        if (this.m_perfLogger != null && timer != null && timer instanceof LogPerfIndication) {
            LogPerfIndication indication = (LogPerfIndication)timer;
            indication.getRCS().disableResourceCounter();
            indication.setStatus("FINISH");
            indication.setTime(System.currentTimeMillis());
            this.m_perfLogger.log((Object)indication);
        }
    }

    protected int getIPFLevel(int level) {
        switch (level) {
            case 0: {
                return 50000;
            }
            case 1: {
                return 40000;
            }
            case 2: {
                return 30000;
            }
            case 3: {
                return 20000;
            }
            case 4: {
                return 10000;
            }
        }
        return 10000;
    }

    private String getIPFOperation(int operation) {
        switch (operation) {
            case 2: {
                return "Request";
            }
            case 3: {
                return "Response";
            }
            case 0: {
                return "StartService";
            }
            case 1: {
                return "StopService";
            }
        }
        return "Request";
    }
}

