/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.eventstore;

import com.cognos.portal.eventstore.BasicNamespace;
import com.cognos.portal.eventstore.NameImpl;
import java.util.HashMap;

public class EventStore {
    public static final short START_DOCUMENT = 0;
    public static final short END_DOCUMENT = 1;
    public static final short START_TAG = 2;
    public static final short END_TAG = 3;
    public static final short TEXT = 4;
    public static final short CDSECT = 5;
    public static final short ENTITY_REF = 6;
    public static final short IGNORABLE_WHITESPACE = 7;
    public static final short PROCESSING_INSTRUCTION = 8;
    public static final short COMMENT = 9;
    public static final short DOCDECL = 10;
    public static final short START_NAMESPACE = 11;
    public static final int INITIAL_EVENT_COUNT = 2000;
    public static final int INITIAL_NAMESPACE_COUNT = 20;
    public static final int INITIAL_QNAME_COUNT = 100;
    public static final int INITIAL_CHAR_COUNT = 10000;
    public static final int INITIAL_STRING_COUNT = 2000;
    private int m_eventCount;
    private short[] m_events = new short[2000];
    private int m_nsCount;
    private BasicNamespace[] m_nss = new BasicNamespace[20];
    private int m_qnameCount;
    private NameImpl[] m_qnames = new NameImpl[100];
    private HashMap m_qnameMap;
    private int m_charCount;
    private char[] m_chars = new char[10000];
    private int m_stringCount;
    private String[] m_strings = new String[2000];

    public EventStore() {
        this.m_qnameMap = new HashMap();
    }

    public void reset() {
        int i;
        for (i = 0; i < this.m_nsCount; ++i) {
            this.m_nss[i] = null;
        }
        for (i = 0; i < this.m_qnameCount; ++i) {
            this.m_qnames[i] = null;
        }
        for (i = 0; i < this.m_stringCount; ++i) {
            this.m_strings[i] = null;
        }
        this.m_eventCount = 0;
        this.m_nsCount = 0;
        this.m_qnameCount = 0;
        this.m_charCount = 0;
        this.m_stringCount = 0;
        this.m_qnameMap.clear();
    }

    public String stats() {
        StringBuffer sb = new StringBuffer();
        sb.append("m_events=").append(this.m_eventCount).append(", allocated: ").append(this.m_events.length).append("\n");
        sb.append("m_nss=").append(this.m_nsCount).append(", allocated: ").append(this.m_nss.length).append("\n");
        sb.append("m_qnames=").append(this.m_qnameCount).append(", allocated: ").append(this.m_qnames.length).append("\n");
        sb.append("m_chars=").append(this.m_charCount).append(", allocated: ").append(this.m_chars.length).append("\n");
        sb.append("m_strings=").append(this.m_stringCount).append(", allocated: ").append(this.m_strings.length).append("\n");
        sb.append("m_qnameMap=").append(this.m_qnameMap.size()).append("\n");
        return sb.toString();
    }

    public void appendEvent(short value) {
        if (this.m_events.length <= this.m_eventCount) {
            short[] copy = new short[this.m_events.length * 2];
            System.arraycopy(this.m_events, 0, copy, 0, this.m_events.length);
            this.m_events = copy;
        }
        this.m_events[this.m_eventCount++] = value;
    }

    public void appendChars(char[] buff, int offset, int length) {
        int end = this.m_charCount + length;
        if (this.m_chars.length <= end) {
            char[] copy = new char[end * 2];
            System.arraycopy(this.m_chars, 0, copy, 0, this.m_chars.length);
            this.m_chars = copy;
        }
        System.arraycopy(buff, offset, this.m_chars, this.m_charCount, length);
        this.m_charCount = end;
    }

    public int appendString(String text) {
        if (this.m_strings.length <= this.m_stringCount) {
            String[] copy = new String[this.m_strings.length * 2];
            System.arraycopy(this.m_strings, 0, copy, 0, this.m_strings.length);
            this.m_strings = copy;
        }
        this.m_strings[this.m_stringCount] = text;
        return this.m_stringCount++;
    }

    public NameImpl addQName(BasicNamespace ns, String name) {
        String qname = ns.getPrefix().length() == 0 ? name : ns.getPrefix() + ':' + name;
        NameImpl inst = new NameImpl(ns, name, qname, this.m_qnameCount);
        if (this.m_qnames.length <= this.m_qnameCount) {
            NameImpl[] copy = new NameImpl[this.m_qnames.length * 2];
            System.arraycopy(this.m_qnames, 0, copy, 0, this.m_qnames.length);
            this.m_qnames = copy;
        }
        this.m_qnames[this.m_qnameCount++] = inst;
        return inst;
    }

    public int appendNs(BasicNamespace ns) {
        if (this.m_nss.length <= this.m_nsCount) {
            BasicNamespace[] copy = new BasicNamespace[this.m_nss.length * 2];
            System.arraycopy(this.m_nss, 0, copy, 0, this.m_nss.length);
            this.m_nss = copy;
        }
        this.m_nss[this.m_nsCount] = ns;
        return this.m_nsCount++;
    }

    public NameImpl getNameImpl(BasicNamespace ns, String name) {
        HashMap submap;
        Object value = this.m_qnameMap.get(name);
        if (value == null) {
            NameImpl inst = this.addQName(ns, name);
            this.m_qnameMap.put(name, inst);
            return inst;
        }
        if (value instanceof NameImpl) {
            NameImpl inst = (NameImpl)value;
            if (inst.getNamespace().equals(ns)) {
                return inst;
            }
            HashMap<BasicNamespace, NameImpl> submap2 = new HashMap<BasicNamespace, NameImpl>();
            submap2.put(inst.getNamespace(), inst);
            this.m_qnameMap.put(name, submap2);
            value = submap2;
        }
        if ((value = (submap = (HashMap)value).get(ns)) == null) {
            NameImpl inst = this.addQName(ns, name);
            submap.put(ns, inst);
            return inst;
        }
        return (NameImpl)value;
    }

    public void appendElementStart(BasicNamespace ns, String name, int acnt) {
        NameImpl nimpl = this.getNameImpl(ns, name);
        this.appendEvent((short)2);
        this.appendEvent((short)nimpl.getHandle());
        this.appendEvent((short)acnt);
    }

    public void appendAttribute(BasicNamespace ns, String name, String value) {
        NameImpl nimpl = this.getNameImpl(ns, name);
        this.appendEvent((short)nimpl.getHandle());
        this.appendString(value);
    }

    public StoreReader createReader() {
        return new StoreReader();
    }

    public class StoreReader {
        private int m_eventIndex;
        private int m_stringIndex;
        private int m_charIndex;

        public boolean hasNext() {
            return this.m_eventIndex < EventStore.this.m_eventCount;
        }

        public int readEvent() {
            return EventStore.this.m_events[this.m_eventIndex++];
        }

        public NameImpl readQName() {
            return EventStore.this.m_qnames[EventStore.this.m_events[this.m_eventIndex++]];
        }

        public String readString() {
            return EventStore.this.m_strings[this.m_stringIndex++];
        }

        public char[] getChars() {
            return EventStore.this.m_chars;
        }

        public int getCharOffset() {
            return this.m_charIndex;
        }

        public int readChars() {
            short length = EventStore.this.m_events[this.m_eventIndex++];
            this.m_charIndex += length;
            return length;
        }

        public BasicNamespace getNamespace(int index) {
            return EventStore.this.m_nss[index];
        }

        public void reset() {
            this.m_eventIndex = 0;
            this.m_stringIndex = 0;
            this.m_charIndex = 0;
        }
    }
}

