/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.eventstore;

import java.lang.reflect.Array;

public abstract class GrowableBase {
    public static final int DEFAULT_SIZE = 8;
    protected int m_countLimit;
    protected int m_maximumGrowth;

    public GrowableBase(int size, int growth, Class type) {
        Object array = Array.newInstance(type, size);
        this.m_countLimit = size;
        this.m_maximumGrowth = growth;
        this.setArray(array);
    }

    public GrowableBase(int size, Class type) {
        this(size, Integer.MAX_VALUE, type);
    }

    public GrowableBase(GrowableBase base) {
        this(base.m_countLimit, base.m_maximumGrowth, base.getArray().getClass().getComponentType());
    }

    protected abstract Object getArray();

    protected abstract void setArray(Object var1);

    protected void resizeCopy(Object base, Object grown) {
        System.arraycopy(base, 0, grown, 0, Array.getLength(base));
    }

    protected void discardValues(int from, int to) {
        Object values = this.getArray();
        if (!values.getClass().getComponentType().isPrimitive()) {
            Object[] objects = (Object[])values;
            for (int i = from; i < to; ++i) {
                objects[i] = null;
            }
        }
    }

    protected void growArray(int required) {
        Object base = this.getArray();
        int size = Math.max(required, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        Class<?> type = base.getClass().getComponentType();
        Object grown = Array.newInstance(type, size);
        this.resizeCopy(base, grown);
        this.m_countLimit = size;
        this.setArray(grown);
    }

    public final void ensureCapacity(int min) {
        if (min > this.m_countLimit) {
            this.growArray(min);
        }
    }

    protected Object buildArray(Class type, int offset, int length) {
        Object copy = Array.newInstance(type, length);
        System.arraycopy(this.getArray(), offset, copy, 0, length);
        return copy;
    }
}

