/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.eventstore;

import com.cognos.portal.eventstore.StackBase;

public class IntStack
extends StackBase {
    protected int[] m_baseArray;

    public IntStack(int size, int growth) {
        super(size, growth, Integer.TYPE);
    }

    public IntStack(int size) {
        super(size, Integer.TYPE);
    }

    public IntStack() {
        this(8);
    }

    public IntStack(IntStack base) {
        super(base);
    }

    @Override
    protected Object getArray() {
        return this.m_baseArray;
    }

    @Override
    protected void setArray(Object array) {
        this.m_baseArray = (int[])array;
    }

    public void push(int value) {
        int index = this.getAddIndex();
        this.m_baseArray[index] = value;
    }

    public int pop() {
        if (this.m_countPresent > 0) {
            return this.m_baseArray[--this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop empty stack");
    }

    public int pop(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        if (this.m_countPresent >= count) {
            this.m_countPresent -= count;
            return this.m_baseArray[this.m_countPresent];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop past end of stack");
    }

    public int peek(int depth) {
        if (this.m_countPresent > depth) {
            return this.m_baseArray[this.m_countPresent - depth - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to peek past end of stack");
    }

    public int peek() {
        return this.peek(0);
    }

    public int[] toArray() {
        return (int[])this.buildArray(Integer.TYPE);
    }

    public Object clone() {
        return new IntStack(this);
    }
}

