/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.eventstore;

import com.cognos.portal.eventstore.BasicNamespace;
import com.cognos.portal.eventstore.EventStore;
import com.cognos.portal.eventstore.IntStack;
import com.cognos.portal.eventstore.NameImpl;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SAXReader
implements XMLReader {
    private static final int DEFAULT_ATTRIBUTE_COUNT = 10;
    private EventStore.StoreReader m_reader;
    private AttributesHolder m_attributes;
    private ContentHandler m_contentHandler;
    private DTDHandler m_dtdHandler;
    private EntityResolver m_entityResolver;
    private ErrorHandler m_errorHandler;
    private LexicalHandler m_lexicalHandler;
    private boolean m_isUsePrefixes;
    private int m_nsDeclCount;
    private Stack m_elementStack;
    private IntStack m_countStack;
    private Stack m_namespaceStack;
    private HashMap m_namespaceAttributeMap;

    public SAXReader(EventStore es) {
        this.m_reader = es.createReader();
        this.m_attributes = new AttributesHolder();
        this.m_elementStack = new Stack();
        this.m_countStack = new IntStack();
        this.m_namespaceStack = new Stack();
    }

    private void reportElementStart() throws SAXException {
        NameImpl ename = this.m_reader.readQName();
        int acnt = this.m_reader.readEvent();
        for (int i = 0; i < acnt; ++i) {
            NameImpl aname = this.m_reader.readQName();
            String avalue = this.m_reader.readString();
            this.m_attributes.addAttribute(aname, avalue);
        }
        if (this.m_isUsePrefixes) {
            int index = this.m_namespaceStack.size();
            for (int i = 0; i < this.m_nsDeclCount; ++i) {
                BasicNamespace ns;
                NameImpl aname;
                if ((aname = (NameImpl)this.m_namespaceAttributeMap.get(ns = (BasicNamespace)this.m_namespaceStack.get(--index))) == null) {
                    String asattr = "xmlns";
                    if (ns.getPrefix().length() > 0) {
                        asattr = asattr + ":" + ns.getPrefix();
                    }
                    aname = new NameImpl(this.m_reader.getNamespace(0), asattr, asattr, -1);
                    this.m_namespaceAttributeMap.put(ns, aname);
                }
                this.m_attributes.addAttribute(aname, ns.getUri());
            }
        }
        if (this.m_contentHandler != null) {
            this.m_contentHandler.startElement(ename.getNamespace().getUri(), ename.getName(), ename.getQName(), this.m_attributes);
        }
        this.m_elementStack.push(ename);
        this.m_countStack.push(this.m_nsDeclCount);
        this.m_nsDeclCount = 0;
        this.m_attributes.clear();
    }

    private void reportNamespaceStart() throws SAXException {
        BasicNamespace ns = this.m_reader.getNamespace(this.m_reader.readEvent());
        if (this.m_contentHandler != null) {
            this.m_contentHandler.startPrefixMapping(ns.getPrefix(), ns.getUri());
        }
        this.m_namespaceStack.push(ns);
        ++this.m_nsDeclCount;
    }

    private void reportElementEnd() throws SAXException {
        NameImpl ename = (NameImpl)this.m_elementStack.pop();
        if (this.m_contentHandler != null) {
            this.m_contentHandler.endElement(ename.getNamespace().getUri(), ename.getName(), ename.getQName());
        }
        int nscnt = this.m_countStack.pop();
        for (int i = 0; i < nscnt; ++i) {
            BasicNamespace ns = (BasicNamespace)this.m_namespaceStack.pop();
            if (this.m_contentHandler == null) continue;
            this.m_contentHandler.endPrefixMapping(ns.getPrefix());
        }
    }

    protected void reportText() throws SAXException {
        int offset = this.m_reader.getCharOffset();
        int length = this.m_reader.readChars();
        if (this.m_contentHandler != null) {
            this.m_contentHandler.characters(this.m_reader.getChars(), offset, length);
        }
    }

    protected void reportCDATA() throws SAXException {
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startCDATA();
        }
        int offset = this.m_reader.getCharOffset();
        int length = this.m_reader.readChars();
        if (this.m_contentHandler != null) {
            this.m_contentHandler.characters(this.m_reader.getChars(), offset, length);
        }
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    protected void reportProcessingInstruction() throws SAXException {
        String target = this.m_reader.readString();
        String data = this.m_reader.readString();
        if (this.m_contentHandler != null) {
            this.m_contentHandler.processingInstruction(target, data);
        }
    }

    protected void reportComment() throws SAXException {
        int offset = this.m_reader.getCharOffset();
        int length = this.m_reader.readChars();
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(this.m_reader.getChars(), offset, length);
        }
    }

    public void read() throws SAXException {
        this.documentReset();
        block11: while (this.m_reader.hasNext()) {
            switch (this.m_reader.readEvent()) {
                case 5: {
                    this.reportCDATA();
                    continue block11;
                }
                case 9: {
                    this.reportComment();
                    continue block11;
                }
                case 1: {
                    if (this.m_contentHandler == null) break block11;
                    this.m_contentHandler.endDocument();
                    break block11;
                }
                case 3: {
                    this.reportElementEnd();
                    continue block11;
                }
                case 8: {
                    this.reportProcessingInstruction();
                    continue block11;
                }
                case 0: {
                    if (this.m_contentHandler == null) continue block11;
                    this.m_contentHandler.startDocument();
                    continue block11;
                }
                case 11: {
                    this.reportNamespaceStart();
                    continue block11;
                }
                case 2: {
                    this.reportElementStart();
                    continue block11;
                }
                case 4: {
                    this.reportText();
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Unknown event type ");
                }
            }
        }
    }

    private void documentReset() {
        this.m_attributes.clear();
        this.m_elementStack.clear();
        this.m_countStack.clear();
        this.m_namespaceStack.clear();
        this.m_nsDeclCount = 0;
        if (this.m_namespaceAttributeMap != null) {
            this.m_namespaceAttributeMap.clear();
        }
    }

    public final void reset() {
        this.m_reader.reset();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.m_dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.m_entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.m_isUsePrefixes;
        }
        throw new SAXNotRecognizedException("Unknown feature: " + name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.m_lexicalHandler;
        }
        throw new SAXNotRecognizedException("Unknown property: " + name);
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        this.read();
    }

    @Override
    public void parse(String systemId) throws SAXException {
        if (systemId != null) {
            throw new SAXException("Direct parse not supported by stream handler");
        }
        this.read();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.m_contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.m_dtdHandler = handler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.m_entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.m_errorHandler = handler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name) && !value) {
            throw new SAXNotSupportedException("Event store requires namespaces enabled");
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.m_isUsePrefixes = value;
            if (value && this.m_namespaceAttributeMap == null) {
                this.m_namespaceAttributeMap = new HashMap();
            }
        } else {
            throw new SAXNotRecognizedException("Unknown feature: " + name);
        }
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!"http://xml.org/sax/properties/lexical-handler".equals(name)) {
            throw new SAXNotRecognizedException("Unknown property: " + name);
        }
        this.m_lexicalHandler = (LexicalHandler)value;
    }

    private class AttributesHolder
    implements Attributes {
        private int m_attributeCount;
        private NameImpl[] m_names = new NameImpl[10];
        private String[] m_values = new String[10];

        private AttributesHolder() {
        }

        @Override
        public int getLength() {
            return this.m_attributeCount;
        }

        @Override
        public String getLocalName(int index) {
            return this.m_names[index].getName();
        }

        @Override
        public String getQName(int index) {
            return this.m_names[index].getQName();
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getURI(int index) {
            return this.m_names[index].getNamespace().getUri();
        }

        @Override
        public String getValue(int index) {
            return this.m_values[index];
        }

        @Override
        public int getIndex(String qname) {
            int split = qname.indexOf(58);
            String prefix = "";
            String lname = qname;
            if (split >= 0) {
                prefix = qname.substring(0, split);
                lname = qname.substring(split + 1);
            }
            for (int i = 0; i < this.m_attributeCount; ++i) {
                NameImpl name = this.m_names[i];
                if (!lname.equals(name.getName()) || !prefix.equals(name.getNamespace().getPrefix())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String qname) {
            int index = this.getIndex(qname);
            if (index >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getValue(String qname) {
            int index = this.getIndex(qname);
            if (index >= 0) {
                return this.m_values[index];
            }
            return null;
        }

        @Override
        public int getIndex(String uri, String lname) {
            for (int i = 0; i < this.m_attributeCount; ++i) {
                NameImpl name = this.m_names[i];
                if (!lname.equals(name.getName()) || !uri.equals(name.getNamespace().getUri())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String lname) {
            int index = this.getIndex(uri, lname);
            if (index >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getValue(String uri, String lname) {
            int index = this.getIndex(uri, lname);
            if (index >= 0) {
                return this.m_values[index];
            }
            return null;
        }

        public void clear() {
            this.m_attributeCount = 0;
        }

        public void addAttribute(NameImpl name, String value) {
            this.m_names[this.m_attributeCount] = name;
            this.m_values[this.m_attributeCount++] = value;
        }
    }
}

