/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.eventstore;

import com.cognos.portal.eventstore.BasicNamespace;
import com.cognos.portal.eventstore.EventStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXWriter
extends DefaultHandler
implements LexicalHandler {
    private static final String NO_NAMESPACE = "";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private SAXNamespace m_noNamespace;
    private SAXNamespace m_xmlNamespace;
    private HashMap m_uriMap;
    private ArrayList m_uriPrefixes;
    private HashMap m_prefixMap;
    private Stack m_namespaceStack;
    private Stack m_maskedStack;
    private boolean m_isNextCData;
    private EventStore m_eventStore;

    public SAXWriter(EventStore es) {
        SAXInitialNamespace inn = new SAXInitialNamespace(NO_NAMESPACE, NO_NAMESPACE);
        inn.setIndex(0);
        this.m_noNamespace = inn.get(NO_NAMESPACE);
        inn = new SAXInitialNamespace("xml", XML_NAMESPACE);
        inn.setIndex(1);
        this.m_xmlNamespace = inn.get("xml");
        this.m_uriMap = new HashMap();
        this.m_uriMap.put(NO_NAMESPACE, this.m_noNamespace);
        this.m_uriPrefixes = new ArrayList();
        this.m_uriPrefixes.add(this.m_noNamespace);
        this.m_prefixMap = new HashMap();
        this.m_prefixMap.put(NO_NAMESPACE, this.m_noNamespace);
        this.m_prefixMap.put("xml", this.m_xmlNamespace);
        this.m_namespaceStack = new Stack();
        this.m_maskedStack = new Stack();
        this.m_eventStore = es;
    }

    public void reset() {
        this.m_uriMap.clear();
        this.m_uriMap.put(NO_NAMESPACE, this.m_noNamespace.getOwner());
        this.m_uriPrefixes.clear();
        this.m_prefixMap.clear();
        this.m_prefixMap.put(NO_NAMESPACE, this.m_noNamespace);
        this.m_noNamespace.setActive(true);
        this.m_prefixMap.put("xml", this.m_xmlNamespace);
        this.m_xmlNamespace.setActive(true);
        this.m_namespaceStack.clear();
        this.m_maskedStack.clear();
        this.m_eventStore.reset();
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_eventStore.appendEvent((short)0);
        this.m_eventStore.appendNs(this.m_noNamespace);
        this.m_eventStore.appendNs(this.m_xmlNamespace);
    }

    @Override
    public void endDocument() {
        this.m_eventStore.appendEvent((short)1);
    }

    @Override
    public void startElement(String uri, String name, String raw, Attributes atts) throws SAXException {
        SAXNamespace ns;
        if (uri == null || uri.equals(NO_NAMESPACE)) {
            ns = this.m_noNamespace;
        } else if (raw != null && raw.length() > 0) {
            int split = raw.indexOf(58);
            if (split < 0) {
                split = 0;
            }
            ns = (SAXNamespace)this.m_prefixMap.get(raw.substring(0, split));
        } else {
            SAXInitialNamespace ins = (SAXInitialNamespace)this.m_uriMap.get(uri);
            ns = ins.getElementNamespace();
        }
        this.m_eventStore.appendElementStart(ns, name, atts.getLength());
        for (int i = 0; i < atts.getLength(); ++i) {
            String auri = atts.getURI(i);
            String aname = atts.getLocalName(i);
            String aqname = atts.getQName(i);
            if (auri == null || auri.equals(NO_NAMESPACE)) {
                ns = this.m_noNamespace;
            } else if (aqname != null && aqname.length() > 0) {
                int split = aqname.indexOf(58);
                ns = (SAXNamespace)this.m_prefixMap.get(aqname.substring(0, split));
            } else {
                SAXInitialNamespace ins = (SAXInitialNamespace)this.m_uriMap.get(uri);
                ns = ins.getAttributeNamespace();
            }
            this.m_eventStore.appendAttribute(ns, aname, atts.getValue(i));
        }
    }

    @Override
    public void endElement(String uri, String name, String raw) {
        this.m_eventStore.appendEvent((short)3);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.m_eventStore.appendEvent(this.m_isNextCData ? (short)5 : 4);
        this.m_eventStore.appendEvent((short)length);
        this.m_eventStore.appendChars(ch, start, length);
    }

    @Override
    public void startCDATA() {
        this.m_isNextCData = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_isNextCData = false;
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.m_eventStore.appendEvent((short)8);
        this.m_eventStore.appendString(target);
        this.m_eventStore.appendString(data);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.m_eventStore.appendEvent((short)9);
        this.m_eventStore.appendEvent((short)length);
        this.m_eventStore.appendChars(ch, start, length);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        SAXNamespace ns;
        SAXInitialNamespace ins = (SAXInitialNamespace)this.m_uriMap.get(uri);
        if (ins == null) {
            ins = new SAXInitialNamespace(prefix, uri);
            this.m_uriMap.put(uri, ins);
        }
        if ((ns = ins.get(prefix)).getIndex() < 0) {
            ns.setIndex(this.m_eventStore.appendNs(ns));
        }
        ns.setActive(true);
        ns.startMapping();
        this.m_namespaceStack.push(ns);
        SAXNamespace masked = (SAXNamespace)this.m_prefixMap.get(prefix);
        this.m_maskedStack.push(masked);
        if (masked != null) {
            masked.setActive(false);
        }
        this.m_prefixMap.put(prefix, ns);
        this.m_eventStore.appendEvent((short)11);
        this.m_eventStore.appendEvent((short)ns.getIndex());
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        SAXNamespace ns = (SAXNamespace)this.m_namespaceStack.pop();
        ns.setActive(false);
        ns.endMapping();
        ns = (SAXNamespace)this.m_maskedStack.pop();
        this.m_prefixMap.put(prefix, ns);
        if (ns != null) {
            ns.setActive(true);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    private static class SAXInitialNamespace
    extends SAXNamespace {
        private HashMap m_prefixMap;
        private Stack m_definitionStack = new Stack();
        private SAXNamespace m_activeNoPrefix;
        private SAXNamespace m_activePrefix;

        public SAXInitialNamespace(String prefix, String uri) {
            super(prefix, uri, null);
        }

        public SAXNamespace get(String prefix) {
            if (this.getPrefix().equals(prefix)) {
                return this;
            }
            SAXNamespace ns = null;
            if (this.m_prefixMap != null) {
                ns = (SAXNamespace)this.m_prefixMap.get(prefix);
            }
            if (ns == null) {
                ns = new SAXNamespace(prefix, this.getUri(), this);
                if (this.m_prefixMap == null) {
                    this.m_prefixMap = new HashMap();
                }
                this.m_prefixMap.put(prefix, ns);
            }
            return ns;
        }

        public void pushDefine(SAXNamespace ns) {
            this.m_definitionStack.push(ns);
            if (ns.getPrefix().length() == 0) {
                this.m_activeNoPrefix = ns;
            } else {
                this.m_activePrefix = ns;
            }
        }

        public void popDefine(SAXNamespace ns) {
            this.m_definitionStack.pop();
        }

        public SAXNamespace getElementNamespace() {
            if (this.m_activeNoPrefix != null && this.m_activeNoPrefix.isActive()) {
                return this.m_activeNoPrefix;
            }
            if (this.m_activePrefix != null && this.m_activePrefix.isActive()) {
                return this.m_activePrefix;
            }
            for (int i = this.m_definitionStack.size() - 1; i >= 0; --i) {
                SAXNamespace ns = (SAXNamespace)this.m_definitionStack.get(i);
                if (!ns.isActive()) continue;
                if (ns.getPrefix().length() == 0) {
                    this.m_activeNoPrefix = ns;
                } else {
                    this.m_activePrefix = ns;
                }
                return ns;
            }
            return null;
        }

        public SAXNamespace getAttributeNamespace() {
            if (this.m_activePrefix != null && this.m_activePrefix.isActive()) {
                return this.m_activePrefix;
            }
            for (int i = this.m_definitionStack.size() - 1; i >= 0; --i) {
                SAXNamespace ns = (SAXNamespace)this.m_definitionStack.get(i);
                if (!ns.isActive() || ns.getPrefix().length() <= 0) continue;
                this.m_activePrefix = ns;
                return ns;
            }
            return null;
        }
    }

    private static class SAXNamespace
    extends BasicNamespace {
        private final SAXInitialNamespace m_owner;
        private boolean m_isActive;
        private int m_index;

        public SAXNamespace(String prefix, String uri, SAXInitialNamespace owner) {
            super(prefix, uri);
            this.m_owner = owner == null ? (SAXInitialNamespace)this : owner;
            this.m_isActive = true;
            this.m_index = -1;
        }

        public void startMapping() {
            this.m_owner.pushDefine(this);
        }

        public void endMapping() {
            this.m_owner.popDefine(this);
        }

        public boolean isActive() {
            return this.m_isActive;
        }

        public void setActive(boolean active) {
            this.m_isActive = active;
        }

        public SAXInitialNamespace getOwner() {
            return this.m_owner;
        }

        public void setIndex(int index) {
            this.m_index = index;
        }

        public int getIndex() {
            return this.m_index;
        }
    }
}

