/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.ResourceLoader;
import com.cognos.portal.fragment.routing.RoutingTable;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.validation.HttpParameterValidator;
import com.cognos.portal.fragment.validation.ValidationManager;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.capability.CapabilityHelpers;
import com.cognos.portal.utils.capability.RequiredCapabilities;
import com.cognos.portal.utils.capability.UserCapabilities;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.PipelineFactory;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import org.xml.sax.SAXException;

public abstract class Environment {
    public static final String ENCODING_TEXT_HTML_UTF_8 = "text/html;charset=UTF-8";
    public static final String ENCODING_TEXT_XML_UTF_8 = "text/xml;charset=UTF-8";
    public static final String ENCODING_TEXT_CSS_UTF_8 = "text/css;charset=UTF-8";
    public static final String ENCODING_APPLICATION_JAVASCRIPT = "application/x-javascript";
    protected OutputStream out;
    protected String contentType;
    private ServiceLogger logger;
    private static final String TARGET_PROTOCOL_PIPELINE = "pipeline://";
    private static final String TARGET_PROTOCOL_PRODUCER = "producer://";
    protected IContext context;
    private int status = 200;
    private String etag;
    protected Map subFragmentParameters;
    protected Map validators;
    protected UserCapabilities userCapabilities;
    protected ValidationManager validationManager;
    private String browser;
    private static List excludedParameters = Arrays.asList("frag-id", "frag-producer", "frag-resource", "frag-custom", "frag-customProperties");

    protected Environment(IContext context, ServiceLogger logger) {
        this.context = context;
        this.logger = logger != null ? logger.cloneForClass(Environment.class) : null;
        this.validators = new HashMap();
        this.userCapabilities = null;
        this.validationManager = (ValidationManager)context.getProperty("validationManager");
    }

    public ServiceLogger getLogger() {
        return this.logger;
    }

    public String getRoutingInfo(String target) {
        RoutingTable routingTable = (RoutingTable)this.context.getProperty("routingTable");
        if (routingTable != null) {
            return routingTable.resolve(target);
        }
        return target;
    }

    public void writeRoutingTable() throws DashboardException {
        try {
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(this.getOutputStream());
            RoutingTable routingTable = (RoutingTable)this.context.getProperty("routingTable");
            if (routingTable != null) {
                this.setResponseContentType(ENCODING_TEXT_XML_UTF_8);
                xsw.writeStartDocument();
                routingTable.writeXML(xsw);
                xsw.writeEndDocument();
                xsw.flush();
                xsw.close();
            }
        }
        catch (XMLStreamException e) {
            throw new DashboardException("pf.fragment.server.executionfailed");
        }
    }

    public Object getProperty(String name) {
        return this.context.getProperty(name);
    }

    public void setResponseStatus(int status) {
        this.status = status;
    }

    public int getResponseStatus() {
        return this.status;
    }

    public String getResponseContentType() {
        return this.contentType;
    }

    public void setResponseContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public String getResponseEtag() {
        return this.etag;
    }

    public void setResponseEtag(String etag) {
        this.etag = etag;
    }

    public abstract String getControllerAgent();

    public abstract String getTarget();

    public abstract String getSoapAction();

    public abstract String getRequestMethod();

    public abstract String getParameter(String var1);

    public abstract String[] getParameterValues(String var1);

    public abstract Enumeration getParameterNames();

    public abstract String getWebContent();

    public abstract String getGatewayURI();

    public abstract String getApplicationGatewayURI();

    public abstract String getUserID();

    public abstract String getUserName();

    public abstract String getRequestEtag();

    public abstract String getSkin();

    public abstract String getProductLocale();

    public abstract String getContentLocale();

    public abstract String getUserPreference(String var1);

    public abstract void createCookieList(List var1);

    public abstract String getBusHeader();

    public abstract String getPassportID();

    public abstract String getPassportCookie();

    public abstract String getUserSessionIdCookie();

    public abstract void proxyResource(String var1) throws DashboardException;

    public abstract void verify(String var1, boolean var2) throws DashboardException;

    public abstract void verify(String var1, Parameters var2, boolean var3) throws DashboardException;

    public abstract void addSetCookie(String var1, String var2);

    public abstract Map<String, String> getSetCookieList();

    public abstract String getSessionParameter(String var1);

    public void setBrowser(String useragent) {
        this.browser = CapabilityHelpers.detectBrowser(useragent);
    }

    public abstract void setBrowser();

    public String getBrowser() {
        if (this.browser == null) {
            this.setBrowser();
        }
        return this.browser;
    }

    public void setValidationDocument(String target, Validator validator) {
        this.validators.put(target, validator);
    }

    public Validator getValidationDocument(String target, Parameters parameters) throws DashboardException {
        if (target != null) {
            if (this.validators.containsKey(target)) {
                return (Validator)this.validators.get(target);
            }
            if (parameters != null) {
                return this.createValidationDocument(target, parameters);
            }
        }
        return null;
    }

    public abstract String sign(String var1, String var2, String var3) throws DashboardException;

    public abstract void sign(String var1, Parameters var2) throws DashboardException;

    public abstract String unsign(String var1, String var2, String var3) throws DashboardException;

    public boolean hasCapabilities(String capability) {
        RequiredCapabilities rc = new RequiredCapabilities(capability, true);
        return rc.hasCapabilities(this.getUserCapabilities(), this.getBrowser());
    }

    public String getDefaultTarget(DashboardContext context) {
        try {
            InputStream in = this.getResourceAsStream(1, "/application.xml");
            return this.getParsedDefaultTarget(in);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void writeCSS(DashboardContext context) {
        block14: {
            String overrides;
            URLConnection overridesConnection;
            this.setResponseContentType(ENCODING_TEXT_CSS_UTF_8);
            String cssPath = this.getTarget().substring("/css/".length());
            if ("".equals(cssPath)) {
                return;
            }
            URLConnection cssConnection = this.getURLConnection("/styles/" + cssPath + ".xml");
            if (cssConnection == null) {
                return;
            }
            String etag = Environment.genETag(cssConnection);
            String skin = this.getParameter("skin");
            if (skin != null) {
                URLConnection skinConnection;
                if ("".equals(skin)) {
                    String cookieSkin = this.getSkin();
                    skin = cookieSkin != null ? cookieSkin : context.getDefaultSkinCSS();
                }
                if ((skinConnection = this.getURLConnection(skin = "/styles/skins/" + skin + ".xml")) == null) {
                    skin = null;
                }
                etag = etag + ":" + Environment.genETag(skinConnection);
            }
            if ((overridesConnection = this.getURLConnection(overrides = "/styles/skins/" + this.getSkin() + "/" + cssPath + ".xml")) == null) {
                overrides = null;
            }
            if ((etag = etag + ":" + Environment.genETag(overridesConnection)).equals(this.getRequestEtag())) {
                this.setResponseStatus(304);
                return;
            }
            this.setResponseEtag(etag);
            try {
                Stylesheet stylesheet = context.setupStylesheet(4, this);
                if (skin != null) {
                    stylesheet.setParameter("skinfile", (Object)skin);
                }
                stylesheet.setParameter("comments", (Object)this.getBoolParameter("comments"));
                stylesheet.setParameter("compact", (Object)this.getBoolParameter("compact"));
                stylesheet.setParameter("debug", (Object)this.getBoolParameter("debug"));
                stylesheet.setParameter("webcontent", (Object)this.getWebContent());
                stylesheet.setParameter("cgi", (Object)this.getApplicationGatewayURI());
                stylesheet.setParameter("skin", (Object)this.getSkin());
                stylesheet.setParameter("overrides_path", (Object)overrides);
                XmlSource source = new XmlSource("", cssConnection.getInputStream(), true);
                XsltResult result = new XsltResult("", this.getOutputStream(), true);
                stylesheet.transform(source, result);
            }
            catch (SAXException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("encountered a SAX exception when trying to parse the stylesheet", e);
                }
            }
            catch (LocalizableException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("encountered an error when trying to parse the stylesheet", e);
                }
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("encountered an IO error when trying to parse the stylesheet", e);
            }
        }
    }

    public void writeMessage(DashboardContext context) {
        block15: {
            this.setResponseContentType(ENCODING_APPLICATION_JAVASCRIPT);
            String messagePath = this.getTarget().substring("/messages/".length());
            if ("".equals(messagePath)) {
                return;
            }
            String useContentLocale = this.getBoolParameter("useContentLocale");
            boolean useCL = Boolean.valueOf(useContentLocale);
            String locale = useCL ? this.getContentLocale() : this.getProductLocale();
            String validMessageFile = messagePath + (useCL ? "RL_" : "_") + locale + ".xml";
            String etag = "";
            URLConnection msgConnection = null;
            try {
                int resourceLoaderType = this.getParameter("mode") != null && this.getParameter("mode").equals("webroot") ? 3 : 0;
                URL url = this.getResource(resourceLoaderType, validMessageFile);
                if (url == null && (url = this.getResource(resourceLoaderType, validMessageFile = messagePath + (useCL ? "RL_" : "_") + "en.xml")) == null) {
                    validMessageFile = messagePath + ".xml";
                    url = this.getResource(resourceLoaderType, validMessageFile);
                }
                if (url == null) {
                    return;
                }
                msgConnection = url.openConnection();
                msgConnection.connect();
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Error loading resource for path=" + validMessageFile, e);
                }
                return;
            }
            etag = Environment.genETag(msgConnection);
            String section = this.getParameter("section");
            if (section != null) {
                section = HttpParameterValidator.validateParameter(section);
                etag = etag + ":" + section;
            }
            if (etag.equals(this.getRequestEtag())) {
                this.setResponseStatus(304);
                return;
            }
            this.setResponseEtag(etag);
            try {
                Stylesheet stylesheet = context.setupStylesheet(5, this);
                if (section != null) {
                    stylesheet.setParameter("section", (Object)section);
                }
                XmlSource source = null;
                source = new XmlSource("", msgConnection.getInputStream(), true);
                XsltResult result = new XsltResult("", this.getOutputStream(), true);
                stylesheet.transform(source, result);
            }
            catch (SAXException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("encountered a SAX exception when trying to parse the stylesheet", e);
                }
            }
            catch (LocalizableException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("encountered an error when trying to parse the stylesheet", e);
                }
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("encountered an IO error when trying to parse the stylesheet", e);
            }
        }
    }

    public Parameters createParameters() {
        Parameters parameters = new Parameters();
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!this.acceptParameterName(name)) continue;
            this.copyParameter(name, parameters);
        }
        return parameters;
    }

    public void discardParameters(String target) {
    }

    public Parameters getParametersForSubFragment(String subFragmentId) {
        if (this.subFragmentParameters == null) {
            this.loadsubFragmentParameters();
        }
        return (Parameters)this.subFragmentParameters.get(subFragmentId);
    }

    public void copyParametersForTarget(String target, Parameters params) throws DashboardException {
        Validator validator = this.getValidationDocument(target, params);
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if ("frag-agent".equals(name) || "frag-portalAgent".equals(name) || "frag-debug".equals(name)) {
                this.copyParameter(name, params);
                continue;
            }
            if (name.startsWith("frag-") || !this.acceptParameterName(name) || this.getValidationManager().isValidationEnabled() && (validator == null || !validator.isParameter(name))) continue;
            this.copyParameter(name, params);
        }
    }

    public InputStream getTargetStream(String target, Parameters parameters) throws DashboardException {
        if (target.startsWith("http://") || target.startsWith("https://")) {
            try {
                URL url = new URL(target);
                return this.getRemoteTargetStream(url, parameters);
            }
            catch (MalformedURLException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.debug("getTargetStream with invalid URL");
                }
                throw new DashboardException("pf.fragment.server.notargetdocument", e);
            }
        }
        if (target.startsWith(TARGET_PROTOCOL_PIPELINE) || target.startsWith(TARGET_PROTOCOL_PRODUCER)) {
            try {
                int query = target.indexOf(63);
                if (query != -1) {
                    if (parameters == null) {
                        parameters = Parameters.parse(target.substring(query + 1));
                    } else {
                        parameters.add(Parameters.parse(target.substring(query + 1)));
                    }
                    target = target.substring(0, query);
                }
                Pipeline p = PipelineFactory.getInstance().createPipeline(target, this);
                String pipelineTarget = parameters.getValue("target");
                if (pipelineTarget != null) {
                    parameters.remove("target");
                    p.setParam("target", pipelineTarget);
                }
                p.setParam("params", parameters);
                IPipelineOutput output = p.execute();
                if (output != null) {
                    return output.toInputStream();
                }
                return null;
            }
            catch (PipelineException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Pipeline execution error: " + e.getMessage());
                }
                throw new DashboardException("pf.fragment.server.executionfailed", e);
            }
        }
        return this.getLocalTargetStream(target, parameters);
    }

    public HashSet getUserCapabilities() {
        return this.userCapabilities != null ? this.userCapabilities.getUserCapabilities() : null;
    }

    public ValidationManager getValidationManager() {
        return this.validationManager;
    }

    protected void loadsubFragmentParameters() {
        this.subFragmentParameters = new HashMap();
        String[] values = this.getParameterValues("frag-sub");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Parameters parameters = Parameters.parse(values[i]);
                String subFragmentId = parameters.getValue("frag-id");
                parameters.remove("frag-custom");
                parameters.remove("frag-customProperties");
                this.subFragmentParameters.put(subFragmentId, parameters);
            }
        }
    }

    protected boolean acceptParameterName(String name) {
        return !excludedParameters.contains(name);
    }

    protected String getParsedDefaultTarget(InputStream in) {
        try {
            XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader(in);
            if (StaxUtils.moveToElement("default", reader)) {
                return reader.getAttributeValue("", "href");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return null;
    }

    protected InputStream getLocalTargetStream(String target, Parameters parameters) throws DashboardException {
        try {
            return this.getResourceAsStream(1, target);
        }
        catch (Exception e) {
            throw new DashboardException("pf.fragment.server.notargetdocument", e);
        }
    }

    protected abstract String getRealPath(String var1);

    protected abstract Validator createValidationDocument(String var1, Parameters var2) throws DashboardException;

    protected abstract InputStream getRemoteTargetStream(URL var1, Parameters var2) throws DashboardException;

    public abstract String secureLogError(String var1);

    private String getBoolParameter(String name) {
        String value = this.getParameter(name);
        if (value == null || !"true".equals(value)) {
            value = "false";
        }
        return value;
    }

    public InputStream getResourceAsStream(int loadMethod, String path) {
        ResourceLoader resourceLoader = (ResourceLoader)this.context.getProperty("resourceLoader");
        if (resourceLoader != null) {
            return resourceLoader.getResourceAsStream(loadMethod, path);
        }
        return null;
    }

    public URL getResource(int loadMethod, String path) throws DashboardException {
        ResourceLoader resourceLoader = (ResourceLoader)this.context.getProperty("resourceLoader");
        if (resourceLoader != null) {
            return resourceLoader.getResource(loadMethod, path);
        }
        return null;
    }

    private static String genETag(URLConnection connection) {
        if (connection == null) {
            return "";
        }
        return Long.toHexString(connection.getLastModified()) + ":" + Integer.toHexString(connection.getContentLength());
    }

    private URLConnection getURLConnection(String resource) {
        URLConnection connection = null;
        try {
            URL url = this.getResource(0, resource);
            if (url == null) {
                return null;
            }
            connection = url.openConnection();
            connection.connect();
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error loading resource for path=" + resource, e);
            }
            return null;
        }
        return connection;
    }

    protected void copyParameter(String name, Parameters parameters) {
        parameters.add(name, this.getParameterValues(name));
    }
}

