/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment;

import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.portal.fragment.ResourceLoader;
import com.cognos.portal.fragment.server.DashboardException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceLoaderImpl
implements ResourceLoader {
    private PogoEngine engine;
    private String webinfRoot;
    private String applicationName;

    public ResourceLoaderImpl(PogoEngine engine, String webinfRoot, String applicationName) {
        this.engine = engine;
        this.webinfRoot = webinfRoot;
        this.applicationName = applicationName;
    }

    private String getResourcePath(int loadMethod, String path) {
        String resourcePath = null;
        switch (loadMethod) {
            case 2: {
                resourcePath = path;
                break;
            }
            case 0: {
                resourcePath = this.webinfRoot + (path.startsWith("/") ? "" : "/") + path;
                break;
            }
            case 1: {
                resourcePath = this.webinfRoot;
                if (this.applicationName != null) {
                    resourcePath = resourcePath + "/applications/" + this.applicationName;
                }
                resourcePath = resourcePath + (path.startsWith("/") ? "" : "/") + path;
                break;
            }
            case 3: {
                resourcePath = "/WEB-INF" + (path.startsWith("/") ? "" : "/") + path;
            }
        }
        return resourcePath;
    }

    @Override
    public InputStream getResourceAsStream(int loadMethod, String path) {
        InputStream is = null;
        if (path != null) {
            switch (loadMethod) {
                case 2: {
                    is = this.getClass().getClassLoader().getResourceAsStream(this.getResourcePath(loadMethod, path));
                    break;
                }
                default: {
                    is = this.engine.getContext().getResourceAsStream(this.getResourcePath(loadMethod, path));
                }
            }
        }
        return is;
    }

    @Override
    public URL getResource(int loadMethod, String path) throws DashboardException {
        if (path != null) {
            try {
                return this.engine.getContext().getResource(this.getResourcePath(loadMethod, path));
            }
            catch (MalformedURLException e) {
                throw new DashboardException("Failed to get resource, path=" + path, e);
            }
        }
        return null;
    }
}

