/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment;

import com.cognos.portal.IResourceContext;
import com.cognos.portal.IUserContext;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.pipelines.service.ResourceResolver;
import com.cognos.portal.pipelines.service.StreamLocalizer;
import com.cognos.portal.utils.Cache;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import jd.xml.util.UriResolver;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.XsltSecurityManager;
import jd.xml.xslt.parser.StylesheetData;
import jd.xml.xslt.parser.StylesheetParser;
import jd.xml.xslt.parser.XsltParseException;
import org.xml.sax.SAXException;

public class XSLTFactory {
    private Cache stylesheets = new Cache(0L, 0L, 100);
    private ServiceLogger logger = new ServiceLoggerImpl(XSLTFactory.class);
    private static XSLTFactory instance = new XSLTFactory();

    private XSLTFactory() {
    }

    public static XSLTFactory getInstance() {
        return instance;
    }

    public static void reinitialize() {
        instance = new XSLTFactory();
    }

    public Stylesheet getStylesheet(String path, List logicsheets, String messageFile, String locale, Environment env) throws LocalizableException {
        return this.getStylesheet(path, logicsheets, messageFile, locale, env, false);
    }

    private InputStream getInputStream(String path, Environment env, boolean useSystemPath) throws LocalizableException, IOException {
        InputStream stream = null;
        if (env != null && !useSystemPath) {
            try {
                stream = env.getTargetStream(path, new Parameters());
            }
            catch (DashboardException e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("Could not find stylesheet: " + path, e);
                }
                throw new LocalizableException("pf.common.xslt.notfound", new String[]{path});
            }
        } else {
            stream = useSystemPath ? env.getResourceAsStream(0, path) : XSLTFactory.class.getClassLoader().getResourceAsStream(path);
        }
        return stream;
    }

    public Stylesheet getStylesheet(String path, List logicsheets, String messageFile, String locale, final Environment env, final boolean useSystemPath) throws LocalizableException {
        ResourceResolver uriResolver;
        String key = this.getCacheKey(path, logicsheets, locale);
        CacheEntry cacheEntry = (CacheEntry)this.stylesheets.get(key);
        StylesheetData stylesheetData = cacheEntry != null ? (StylesheetData)cacheEntry.stylesheet : null;
        ResourceResolver resourceResolver = uriResolver = cacheEntry != null ? (ResourceResolver)cacheEntry.uriResolver : null;
        if (stylesheetData == null) {
            try {
                InputStream stream = this.getInputStream(path, env, useSystemPath);
                if (stream == null) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("Could not find stylesheet: " + path);
                    }
                    throw new LocalizableException("pf.common.xslt.notfound", new String[]{path});
                }
                StylesheetParser parser = new StylesheetParser(XsltSecurityManager.getGlobalInstance());
                IResourceContext arc = new IResourceContext(){

                    @Override
                    public URL getResource(String path) throws MalformedURLException {
                        return XSLTFactory.class.getClassLoader().getResource(path);
                    }

                    @Override
                    public InputStream getResourceAsStream(String path) {
                        try {
                            if (!useSystemPath) {
                                return env.getTargetStream(path, null);
                            }
                            return env.getResourceAsStream(0, path);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }

                    @Override
                    public String resolve(String uri) {
                        return null;
                    }

                    @Override
                    public Object getProperty(String name) {
                        return null;
                    }
                };
                IUserContext auc = new IUserContext(){

                    @Override
                    public String getUserName() {
                        return null;
                    }

                    @Override
                    public String getProductLocale() {
                        return env.getProductLocale();
                    }

                    @Override
                    public String getContentLocale() {
                        return env.getContentLocale();
                    }

                    @Override
                    public String getPassport() {
                        return null;
                    }

                    @Override
                    public String getSkin() {
                        return null;
                    }
                };
                StreamLocalizer asl = new StreamLocalizer(arc, auc, messageFile);
                uriResolver = new ResourceResolver(arc, asl);
                parser.setUriResolver((UriResolver)uriResolver);
                if (logicsheets != null && logicsheets.size() > 0) {
                    for (int i = 0; i < logicsheets.size(); ++i) {
                        InputStream logicsheet = this.getInputStream((String)logicsheets.get(i), env, useSystemPath);
                        if (stream == null) continue;
                        StylesheetData ssd = parser.parseStylesheet(new XmlSource((String)logicsheets.get(i), logicsheet, true));
                        Stylesheet stylesheet = new Stylesheet();
                        stylesheet.setup(ssd);
                        XmlSource source = new XmlSource("", stream, false);
                        SharedByteArrayOutputStream output = new SharedByteArrayOutputStream(4096);
                        XsltResult result = new XsltResult("", (OutputStream)output, false);
                        stylesheet.transform(source, result);
                        output.close();
                        stream = output.toStream();
                    }
                }
                XmlSource source = asl.resolveStream(path, stream);
                stylesheetData = parser.parseStylesheet(source);
                this.stylesheets.put(key, new CacheEntry(stylesheetData, uriResolver));
            }
            catch (IOException e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("encountered an IO exception when trying to load stylesheet: " + path, e);
                }
                throw new LocalizableException("pf.common.xslt.loaderror", new String[]{path}, e);
            }
            catch (SAXException e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("encountered a SAX exception when trying to load stylesheet: " + path, e);
                }
                throw new LocalizableException("pf.common.xslt.loaderror", new String[]{path}, e);
            }
            catch (XsltParseException e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("encountered an xslt parse exception when trying to load stylesheet: " + path, e);
                }
                throw new LocalizableException("pf.common.xslt.loaderror", new String[]{path}, e);
            }
            catch (Exception e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("An unkown exception occurred while loading stylesheet: " + path, e);
                }
                throw new LocalizableException("pf.common.xslt.loaderror", new String[]{path}, e);
            }
        }
        Stylesheet stylesheet = new Stylesheet();
        stylesheet.setup(stylesheetData);
        stylesheet.setUriResolver((UriResolver)uriResolver);
        return stylesheet;
    }

    public Stylesheet getStylesheet(String path, Environment env) throws LocalizableException {
        return this.getStylesheet(path, null, null, null, env);
    }

    private String getCacheKey(String path, List logicsheets, String locale) {
        String key;
        String string = key = locale != null ? locale + "-" + path : path;
        if (logicsheets != null) {
            for (int i = 0; i < logicsheets.size(); ++i) {
                key = key + "-" + logicsheets.get(i);
            }
        }
        return key;
    }

    private class CacheEntry {
        private Object stylesheet;
        private Object uriResolver;

        public CacheEntry(Object stylesheet, Object uriResolver) {
            this.stylesheet = stylesheet;
            this.uriResolver = uriResolver;
        }
    }
}

