/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.autoregistration;

import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.WSRPParamUtils;
import com.cognos.portal.utils.localization.DispatcherMessageFileHelper;
import com.cognos.portal.utils.localization.ResourceValue;
import com.cognos.portal.xml.stream.StaxUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class Fragment {
    private boolean useGenericEditor;
    private final PogoEngineContext context;
    private String handle;
    private String href;
    private String messageFile = null;
    private String titleResourceID = null;
    private String descriptionResourceID = null;
    private String title = null;
    private List modes;
    private String requiredCapabilities = null;
    private List windowStates;
    private Parameters parameters = null;
    private String mimeType = "text/html";
    private ServiceLogger logger;
    private List titleResourceValueList;
    private List descriptionResourceValueList;
    private String description = null;
    private StringBuffer errorBuffer;
    private static final String WSRP_NAMESPACE_URI = "urn:oasis:names:tc:wsrp:v1:types";
    private static final String CPS_EXT_NAMESPACE_PREFIX = "cpsext";
    private static final String CPS_EXT_NAMESPACE_URI = "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/";

    public Fragment(PogoEngineContext context, Element fragment, String messageFile, boolean includeEndPoint, ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(Fragment.class) : null;
        this.context = context;
        this.messageFile = messageFile;
        this.useGenericEditor = false;
        this.modes = new ArrayList();
        this.windowStates = new ArrayList();
        this.addMode("view");
        this.parse(fragment, includeEndPoint);
    }

    public boolean isError() {
        return this.errorBuffer != null;
    }

    public String getError() {
        return this.errorBuffer != null ? this.errorBuffer.toString() : null;
    }

    private void addError(String errorMessage) {
        if (this.errorBuffer == null) {
            this.errorBuffer = new StringBuffer();
        }
        this.errorBuffer.append(errorMessage);
        this.errorBuffer.append("\n");
    }

    private void parse(Element fragment, boolean includeEndPoint) {
        Node custom;
        String error;
        Element implementation;
        Element fragmentDescriptionElement;
        Element fragmentTitleElement = (Element)fragment.selectSingleNode("*[local-name()='title']");
        if (fragmentTitleElement != null) {
            this.title = fragmentTitleElement.getText();
            this.titleResourceID = fragmentTitleElement.attributeValue("resourceName");
            this.titleResourceValueList = DispatcherMessageFileHelper.getResourceValueListContentLocale(this.titleResourceID, this.messageFile, this.context, this.logger);
        }
        if ((fragmentDescriptionElement = (Element)fragment.selectSingleNode("*[local-name()='description']")) != null) {
            this.description = fragmentDescriptionElement.getText();
            this.descriptionResourceID = fragmentDescriptionElement.attributeValue("resourceName");
            this.descriptionResourceValueList = DispatcherMessageFileHelper.getResourceValueListContentLocale(this.descriptionResourceID, this.messageFile, this.context, this.logger);
        }
        if ((implementation = (Element)fragment.selectSingleNode("*[local-name()='implementation']")) != null) {
            String implementationPath = implementation.getText();
            if (implementation != null) {
                InputStream inStream = this.context.getResourceAsStream("/WEB-INF/fragments/producers" + implementationPath + "/implementation.xml");
                if (inStream == null) {
                    String error2 = "Couldn't open the implementation file: /WEB-INF/fragments/producers" + implementationPath + "/implementation.xml";
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(error2);
                    }
                    this.addError(error2);
                    return;
                }
                this.parseImplementation(inStream);
                Element extraInfo = (Element)fragment.selectSingleNode("*[local-name()='extraInfo']");
                this.href = includeEndPoint ? "/fragmentproducer" + implementationPath : implementationPath;
                if (extraInfo != null) {
                    this.href = this.href + extraInfo.getTextTrim();
                }
                this.handle = fragment.valueOf("*[local-name()='handle']");
            }
        } else {
            this.parseFragmentElement(fragment);
        }
        if (this.href == null || this.href.length() == 0) {
            error = "Missing href for fragment: " + this.title;
            if (this.logger.isErrorEnabled()) {
                this.logger.error(error);
            }
            this.addError(error);
            return;
        }
        if (this.handle == null || this.handle.length() == 0) {
            error = "Missing handle for fragment: " + this.title;
            if (this.logger.isErrorEnabled()) {
                this.logger.error(error);
            }
            this.addError(error);
            return;
        }
        if (!this.hasMode("edit")) {
            this.addMode("edit");
            this.useGenericEditor = true;
        }
        if ((custom = fragment.selectSingleNode("*[local-name()='custom']")) != null) {
            this.parameters = new Parameters();
            List params = custom.selectNodes("*[local-name()='param']");
            if (params != null && params.size() > 0) {
                for (Element param : params) {
                    String value;
                    String name = param.attributeValue("name");
                    if (name == null) continue;
                    List elements = param.elements();
                    if (elements != null && elements.size() > 0) {
                        StringBuffer xmlValue = new StringBuffer();
                        for (Element element : elements) {
                            xmlValue.append(element.asXML());
                        }
                        name = name + ".xml";
                        value = EncodingUtils.base64encode(xmlValue.toString().getBytes(), true);
                    } else {
                        value = param.getText();
                    }
                    this.parameters.add(name, value);
                }
            }
        }
    }

    public List getTitleResourceValueList() {
        return this.titleResourceValueList;
    }

    private void parseFragmentElement(Element fragment) {
        Element requiredCapabilities;
        List windowStates;
        this.handle = fragment.valueOf("*[local-name()='handle']");
        if (this.handle == null || this.handle.length() == 0) {
            return;
        }
        Element hrefElem = (Element)fragment.selectSingleNode("*[local-name()='href']");
        this.href = hrefElem != null ? hrefElem.getTextTrim() : (this.handle.charAt(0) != '/' ? "/" + this.handle : this.handle);
        List modes = fragment.selectNodes("*[local-name()='modes']");
        if (modes != null && modes.size() > 0) {
            for (Element mode : modes) {
                this.addMode(mode.getText());
            }
        }
        if ((windowStates = fragment.selectNodes("*[local-name()='windowStates']")) != null && windowStates.size() > 0) {
            for (Element windowState : windowStates) {
                this.addWindowState(windowState.getText());
            }
        }
        if ((requiredCapabilities = (Element)fragment.selectSingleNode("*[local-name()='requiredCapabilities']")) != null) {
            this.setRequiredCapabilities(requiredCapabilities.getText());
        }
    }

    public String getCustomizationString() {
        if (this.parameters != null) {
            return DashboardDocument.encodeCustoms(this.parameters);
        }
        return null;
    }

    private void parseImplementation(InputStream inputStream) {
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read(inputStream);
            Element implementationElement = doc.getRootElement();
            if (implementationElement != null) {
                Element meta;
                Element descriptionElement;
                Element titleElement;
                Element messageElement = (Element)implementationElement.selectSingleNode("/*[local-name()='implementation']/*[local-name()='message']");
                if (messageElement != null) {
                    this.messageFile = "/WEB-INF/fragments/producers" + messageElement.attributeValue("source");
                }
                if (this.title == null && (titleElement = (Element)implementationElement.selectSingleNode("/*[local-name()='implementation']/*[local-name()='info']/*[local-name()='title']")) != null) {
                    this.title = titleElement.getText();
                    this.titleResourceID = titleElement.attributeValue("resourceName");
                    this.titleResourceValueList = DispatcherMessageFileHelper.getResourceValueListContentLocale(this.titleResourceID, this.messageFile, this.context, this.logger);
                }
                if (this.description == null && (descriptionElement = (Element)implementationElement.selectSingleNode("/*[local-name()='implementation']/*[local-name()='info']/*[local-name()='description']")) != null) {
                    this.description = descriptionElement.getText();
                    this.descriptionResourceID = descriptionElement.attributeValue("resourceName");
                    this.descriptionResourceValueList = DispatcherMessageFileHelper.getResourceValueListContentLocale(this.descriptionResourceID, this.messageFile, this.context, this.logger);
                }
                if ((meta = (Element)implementationElement.selectSingleNode("/*[local-name()='implementation']/*[local-name()='meta']")) != null) {
                    Element requiredCapabilities;
                    List windowStates;
                    List modes = meta.selectNodes("*[local-name()='modes']");
                    if (modes != null && modes.size() > 0) {
                        for (Element mode : modes) {
                            this.addMode(mode.getText());
                        }
                    }
                    if ((windowStates = meta.selectNodes("*[local-name()='windowStates']")) != null && windowStates.size() > 0) {
                        for (Element windowState : windowStates) {
                            this.addWindowState(windowState.getText());
                        }
                    }
                    if ((requiredCapabilities = (Element)meta.selectSingleNode("*[local-name()='requiredCapabilities']")) != null) {
                        this.setRequiredCapabilities(requiredCapabilities.getText());
                    }
                }
            }
        }
        catch (DocumentException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("An error occurred while parsing the implementaion file of the producer: Fragments", e);
            }
            return;
        }
    }

    private void addMode(String mode) {
        if (mode != null && !this.modes.contains(mode)) {
            this.modes.add(mode);
        }
    }

    private void setRequiredCapabilities(String requiredCapabilities) {
        this.requiredCapabilities = requiredCapabilities;
    }

    private void addWindowState(String windowState) {
        if (windowState != null && !this.windowStates.contains(windowState)) {
            this.windowStates.add(windowState);
        }
    }

    private boolean hasMode(String mode) {
        return this.modes != null && this.modes.contains("edit");
    }

    public boolean usesGenericEditor() {
        return this.useGenericEditor;
    }

    public void removeGenericEditorFlag() {
        this.useGenericEditor = false;
    }

    public String getHandle() {
        String customizationString;
        String calculatedHandle = this.handle;
        if (this.useGenericEditor) {
            calculatedHandle = this.handle + "#noedit";
        }
        if ((customizationString = this.getCustomizationString()) != null && customizationString.length() > 0) {
            calculatedHandle = calculatedHandle + (this.handle.indexOf(35) == -1 ? "#" : ":") + customizationString.hashCode();
        }
        return calculatedHandle;
    }

    public String getHref() {
        return this.href;
    }

    public String getDefaultTitle() {
        return this.title;
    }

    public void writeResourceList(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeResourceList(xsw, this.titleResourceID, this.titleResourceValueList);
        this.writeResourceList(xsw, this.descriptionResourceID, this.descriptionResourceValueList);
    }

    private void writeResourceList(XMLStreamWriter xsw, String resourceId, List resourceList) throws XMLStreamException {
        if (resourceId != null && resourceList != null) {
            xsw.writeStartElement(WSRP_NAMESPACE_URI, "resources");
            xsw.writeAttribute("resourceName", resourceId);
            for (ResourceValue resourceValue : resourceList) {
                xsw.writeStartElement(WSRP_NAMESPACE_URI, "values");
                xsw.writeAttribute("xml:lang", resourceValue.getLocaleName());
                StaxUtils.writeTextElement(xsw, WSRP_NAMESPACE_URI, "value", resourceValue.getValue());
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }
    }

    public void writeOfferedPortlet(XMLStreamWriter wsrpResponseXMLWriter) throws XMLStreamException {
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "offeredPortlets");
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "portletHandle", this.getHandle());
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "markupTypes");
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "mimeType");
        wsrpResponseXMLWriter.writeCharacters(this.mimeType);
        wsrpResponseXMLWriter.writeEndElement();
        Iterator modeIt = this.modes.iterator();
        while (modeIt.hasNext()) {
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "modes");
            String mode = WSRPParamUtils.WSRPModeFromFragment((String)modeIt.next());
            wsrpResponseXMLWriter.writeCharacters(mode);
            wsrpResponseXMLWriter.writeEndElement();
        }
        Iterator windowStateIt = this.windowStates.iterator();
        while (windowStateIt.hasNext()) {
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "windowStates");
            String windowState = WSRPParamUtils.WSRPWindowStateFromFragment((String)windowStateIt.next());
            wsrpResponseXMLWriter.writeCharacters(windowState);
            wsrpResponseXMLWriter.writeEndElement();
        }
        wsrpResponseXMLWriter.writeEndElement();
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "description");
        wsrpResponseXMLWriter.writeAttribute("xml:lang", "en");
        if (this.descriptionResourceID != null) {
            wsrpResponseXMLWriter.writeAttribute("resourceName", this.descriptionResourceID);
        }
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "value");
        String description = this.getDescription("en");
        if (description != null) {
            wsrpResponseXMLWriter.writeCharacters(description);
        }
        wsrpResponseXMLWriter.writeEndElement();
        wsrpResponseXMLWriter.writeEndElement();
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "title");
        wsrpResponseXMLWriter.writeAttribute("xml:lang", "en");
        if (this.titleResourceID != null) {
            wsrpResponseXMLWriter.writeAttribute("resourceName", this.titleResourceID);
        }
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "value");
        String title = this.getTitle("en");
        if (title != null) {
            wsrpResponseXMLWriter.writeCharacters(title);
        }
        wsrpResponseXMLWriter.writeEndElement();
        wsrpResponseXMLWriter.writeEndElement();
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "usesMethodGet", "false");
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "defaultMarkupSecure", "false");
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "onlySecure", "false");
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "userContextStoredInSession", "false");
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "templatesStoredInSession", "false");
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "hasUserSpecificState", "true");
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "doesUrlTemplateProcessing", "false");
        if (this.requiredCapabilities != null) {
            wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_URI, "extensions");
            wsrpResponseXMLWriter.writeStartElement(CPS_EXT_NAMESPACE_PREFIX, "meta", CPS_EXT_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeNamespace(CPS_EXT_NAMESPACE_PREFIX, CPS_EXT_NAMESPACE_URI);
            wsrpResponseXMLWriter.setPrefix(CPS_EXT_NAMESPACE_PREFIX, CPS_EXT_NAMESPACE_URI);
            wsrpResponseXMLWriter.writeStartElement(CPS_EXT_NAMESPACE_URI, "requiredCapabilities");
            wsrpResponseXMLWriter.writeCharacters(this.requiredCapabilities);
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
            wsrpResponseXMLWriter.writeEndElement();
        }
        wsrpResponseXMLWriter.writeEndElement();
    }

    private String getTitle(String locale) {
        String title = this.getResourceValue(this.titleResourceValueList, locale);
        if (title != null) {
            return title;
        }
        return this.title;
    }

    private String getResourceValue(List resourceList, String locale) {
        if (resourceList != null) {
            for (ResourceValue resourceValue : resourceList) {
                if (!resourceValue.getLocaleName().equals(locale)) continue;
                return resourceValue.getValue();
            }
        }
        return null;
    }

    private String getDescription(String locale) {
        String description = this.getResourceValue(this.descriptionResourceValueList, locale);
        if (description != null) {
            return description;
        }
        return this.description;
    }

    public List getDescriptionResourceValueList() {
        return this.descriptionResourceValueList;
    }

    public String getDefaultDescription() {
        return this.description;
    }
}

