/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.autoregistration;

import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.autoregistration.Fragment;
import com.cognos.portal.fragment.autoregistration.IAutoRegistrationPlugin;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.localization.DispatcherMessageFileHelper;
import com.cognos.portal.xml.stream.StaxUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FragmentProducer {
    public static final String FRAGMENT_PRODUCER_ENDPOINT = "/fragmentproducer";
    private static final String DEFAULT_FRAGMENT_PRODUCER_WSRP_ENDPOINT = "bus://wsrp/fragments";
    private static final String DEFAULT_PORTAL_PACKAGE = "Connection";
    private static final String WSRP_NAMESPACE_URI = "urn:oasis:names:tc:wsrp:v1:types";
    private static final String WSRP_NAMESPACE_PREFIX = "wsrp";
    private final PogoEngineContext context;
    private String path;
    private String title;
    private String version = "1.0";
    private String handle;
    private String endpoint = "";
    private String messageFile;
    private String portalPackage;
    private List fragments;
    private ServiceLogger logger;
    private String wsrpEndpointBaseURI;
    private String titleResourceID;
    private List titleResourceValueList;
    private boolean useGenericEditForAllFragments;
    private StringBuffer errorBuffer;
    private List plugins;
    private static final String ROUTING_NAMESPACE_PREFIX = "r";
    private static final String ROUTING_NAMESPACE_URI = "http://developer.cognos.com/schemas/fragments/routing/1/";

    public FragmentProducer(PogoEngineContext context, String path, ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(FragmentProducer.class) : null;
        this.context = context;
        this.path = path;
        this.fragments = new ArrayList();
        this.parse();
        if (!this.isError()) {
            this.fixUpFragments();
        }
    }

    public boolean isError() {
        return this.errorBuffer != null;
    }

    public String getError() {
        return this.errorBuffer != null ? this.errorBuffer.toString() : null;
    }

    private void addError(String errorMessage) {
        if (this.errorBuffer == null) {
            this.errorBuffer = new StringBuffer();
        }
        this.errorBuffer.append(errorMessage);
        this.errorBuffer.append("\n");
    }

    private void fixUpFragments() {
        this.useGenericEditForAllFragments = true;
        for (Fragment fragment : this.fragments) {
            if (fragment.usesGenericEditor()) continue;
            this.useGenericEditForAllFragments = false;
            break;
        }
        if (this.useGenericEditForAllFragments) {
            for (Fragment fragment : this.fragments) {
                fragment.removeGenericEditorFlag();
            }
        }
    }

    private void parse() {
        InputStream inputStream = this.context.getResourceAsStream(this.path + "producer.xml");
        if (inputStream != null) {
            SAXReader reader = new SAXReader();
            try {
                Document doc = reader.read(inputStream);
                Element producerElement = doc.getRootElement();
                if (producerElement != null) {
                    List fragments;
                    List pluginElements;
                    Element titleElement;
                    Element messageElement;
                    this.version = producerElement.attributeValue("version");
                    if (this.version == null || "".equals(this.version)) {
                        this.version = "1.0";
                    }
                    if ((messageElement = (Element)producerElement.selectSingleNode("/*[local-name()='producer']/*[local-name()='message']")) != null) {
                        this.messageFile = "/WEB-INF/fragments/producers" + messageElement.attributeValue("source");
                    }
                    if ((titleElement = (Element)producerElement.selectSingleNode("/*[local-name()='producer']/*[local-name()='name']")) != null) {
                        this.title = titleElement.getText();
                        this.titleResourceID = titleElement.attributeValue("resourceName");
                        this.titleResourceValueList = DispatcherMessageFileHelper.getResourceValueListContentLocale(this.titleResourceID, this.messageFile, this.context, this.logger);
                    }
                    this.portalPackage = producerElement.valueOf("/*[local-name()='producer']/*[local-name()='portalPackage']");
                    if (this.portalPackage == null || this.portalPackage.length() == 0) {
                        this.portalPackage = DEFAULT_PORTAL_PACKAGE;
                    }
                    if ((pluginElements = producerElement.selectNodes("/*[local-name()='producer']/*[local-name()='plugin']")) != null) {
                        for (Element pluginElement : pluginElements) {
                            this.addPlugin(pluginElement.getText(), "true".equalsIgnoreCase(pluginElement.attributeValue("executeOnUpdate")));
                        }
                    }
                    this.handle = producerElement.valueOf("/*[local-name()='producer']/*[local-name()='handle']");
                    if (this.handle == null || this.handle.length() == 0) {
                        String error = "Missing handle for fragment producer: " + this.title;
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error(error);
                        }
                        this.addError(error);
                        return;
                    }
                    Element endpointElement = (Element)producerElement.selectSingleNode("/*[local-name()='producer']/*[local-name()='href']");
                    if (endpointElement != null) {
                        this.endpoint = endpointElement.getText();
                    }
                    if ((fragments = producerElement.selectNodes("/*[local-name()='producer']/*[local-name()='fragment']")) != null && fragments.size() > 0) {
                        boolean includeEndPoint = true;
                        if (this.endpoint.equals("") && this.isImplementationOnly(fragments)) {
                            this.endpoint = FRAGMENT_PRODUCER_ENDPOINT;
                            includeEndPoint = false;
                        }
                        for (Element frag : fragments) {
                            Fragment fragment = new Fragment(this.context, frag, this.messageFile, includeEndPoint, this.logger);
                            if (!fragment.isError()) {
                                this.addFragment(fragment);
                                continue;
                            }
                            this.addError(fragment.getError());
                        }
                    }
                }
            }
            catch (DocumentException e) {
                String error = "An error occurred while parsing the implementaion file of the producer: " + this.path;
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(error, e);
                }
                this.addError(error);
                return;
            }
        }
    }

    private boolean isImplementationOnly(List fragments) {
        for (Element frag : fragments) {
            Element implementation = (Element)frag.selectSingleNode("*[local-name()='implementation']");
            if (implementation != null) continue;
            return false;
        }
        return true;
    }

    public List getTitleResourceValueList() {
        return this.titleResourceValueList;
    }

    public String getIdentifier() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPath() {
        return this.path;
    }

    public String getPortalPackage() {
        return this.portalPackage;
    }

    public String getHandle() {
        return this.handle;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getDefaultTitle() {
        return this.title;
    }

    public List getFragments() {
        return this.fragments;
    }

    public void addFragment(Fragment fragment) {
        this.fragments.add(fragment);
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setWSRPEndpointBaseURI(String baseUri) {
        this.wsrpEndpointBaseURI = baseUri;
    }

    private String getWSRPEndpointBaseURI() {
        return this.wsrpEndpointBaseURI != null ? this.wsrpEndpointBaseURI : DEFAULT_FRAGMENT_PRODUCER_WSRP_ENDPOINT;
    }

    public String getWSRPMarkupEndpoint() {
        StringBuffer uri = new StringBuffer();
        uri.append(this.getWSRPEndpointBaseURI());
        uri.append("/markup/handle/");
        uri.append(this.getHandle());
        if (this.useGenericEditForAllFragments) {
            uri.append("/edit:generic");
        }
        return uri.toString();
    }

    public String getWSRPDescriptionEndpoint() {
        String href = this.getWSRPEndpointBaseURI() + "/description/producerxml/";
        try {
            href = href + EncodingUtils.web64encode(this.getPath().getBytes("UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("getWSRPDescriptionEndpoint:: error while encoding path", e);
            }
            throw new RuntimeException(e);
        }
        return href;
    }

    public String getWSRPRegistrationEndpoint() {
        String href = this.getWSRPEndpointBaseURI() + "/registration/producerxml/";
        try {
            href = href + EncodingUtils.web64encode(this.getPath().getBytes("UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("getWSRPRegistrationEndpoint:: error while encoding path", e);
            }
            throw new RuntimeException(e);
        }
        return href;
    }

    public String getWSRPManagementEndpoint() {
        return this.getWSRPEndpointBaseURI() + "/management";
    }

    public void writeServiceDescriptionResponse(XMLStreamWriter wsrpResponseXMLWriter) throws XMLStreamException {
        this.writeServiceDescription(wsrpResponseXMLWriter, "getServiceDescriptionResponse");
    }

    public void writeServiceDescription(XMLStreamWriter wsrpResponseXMLWriter) throws XMLStreamException {
        this.writeServiceDescription(wsrpResponseXMLWriter, "serviceDescription");
    }

    private void writeServiceDescription(XMLStreamWriter wsrpResponseXMLWriter, String tag) throws XMLStreamException {
        wsrpResponseXMLWriter.setPrefix(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
        wsrpResponseXMLWriter.writeStartElement(WSRP_NAMESPACE_PREFIX, tag, WSRP_NAMESPACE_URI);
        wsrpResponseXMLWriter.writeNamespace(WSRP_NAMESPACE_PREFIX, WSRP_NAMESPACE_URI);
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "requiresRegistration", "true");
        for (Fragment fragment : this.fragments) {
            fragment.writeOfferedPortlet(wsrpResponseXMLWriter);
        }
        StaxUtils.writeTextElement(wsrpResponseXMLWriter, WSRP_NAMESPACE_URI, "requiresInitCookie", "perUser");
        this.writeResourceList(wsrpResponseXMLWriter);
        wsrpResponseXMLWriter.writeEndElement();
    }

    private void writeResourceList(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(WSRP_NAMESPACE_URI, "resourceList");
        for (Fragment fragment : this.fragments) {
            fragment.writeResourceList(xsw);
        }
        xsw.writeEndElement();
    }

    public void writeRouting(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.setPrefix(ROUTING_NAMESPACE_PREFIX, ROUTING_NAMESPACE_URI);
        xsw.writeStartElement(ROUTING_NAMESPACE_URI, "segment");
        xsw.writeNamespace(ROUTING_NAMESPACE_PREFIX, ROUTING_NAMESPACE_URI);
        xsw.writeAttribute("name", this.handle);
        xsw.writeAttribute("set", this.endpoint);
        for (Fragment fragment : this.fragments) {
            String handle = fragment.getHandle();
            if (handle == null) continue;
            xsw.writeStartElement(ROUTING_NAMESPACE_URI, "segment");
            int index = handle.indexOf(35);
            if (index != -1) {
                handle = handle.substring(0, index);
            }
            xsw.writeAttribute("name", handle);
            xsw.writeAttribute("add", fragment.getHref());
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    private void addPlugin(String className, boolean executeOnUpdate) {
        block10: {
            if (this.plugins == null) {
                this.plugins = new ArrayList();
            }
            try {
                Class<?> pluginClass = this.getClass().getClassLoader().loadClass(className);
                Constructor<?> constructor = pluginClass.getConstructor(new Class[0]);
                Object plugin = constructor.newInstance(new Object[0]);
                if (plugin instanceof IAutoRegistrationPlugin) {
                    this.plugins.add(new Plugin((IAutoRegistrationPlugin)plugin, executeOnUpdate));
                } else if (this.logger.isErrorEnabled()) {
                    this.logger.error("The plugin class '" + className + "' for producer '" + this.path + "' does not implement the IAutoRegistrationPlugin interface");
                }
            }
            catch (ClassNotFoundException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not find the plugin class '" + className + "' for producer '" + this.path + "'");
                }
            }
            catch (NoSuchMethodException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not find the correct constructor for the plugin class '" + className + "' for producer '" + this.path + "'", e);
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block10;
                this.logger.error("Could not create instance of the plugin class '" + className + "' for producer '" + this.path + "'", e);
            }
        }
    }

    public void executePlugins(boolean isOnUpdate) {
        if (this.plugins != null) {
            for (Plugin pluginHolder : this.plugins) {
                boolean success;
                block5: {
                    if (!pluginHolder.executeOnUpdate && isOnUpdate) continue;
                    success = false;
                    try {
                        success = pluginHolder.plugin.execute(this.logger);
                    }
                    catch (Throwable t) {
                        if (!this.logger.isErrorEnabled()) break block5;
                        this.logger.error("An error occured while executing the plugin '" + pluginHolder.plugin.getClass().getName() + "' for producer '" + this.path + "'.", t);
                    }
                }
                if (success) {
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("The plugin '" + pluginHolder.plugin.getClass().getName() + "' for producer '" + this.path + "' executed successfully.");
                    continue;
                }
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("The plugin '" + pluginHolder.plugin.getClass().getName() + "' for producer '" + this.path + "' failed to execute.");
            }
        }
    }

    class Plugin {
        IAutoRegistrationPlugin plugin;
        boolean executeOnUpdate;

        public Plugin(IAutoRegistrationPlugin plugin, boolean executeOnUpdate) {
            this.plugin = plugin;
            this.executeOnUpdate = executeOnUpdate;
        }
    }
}

