/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.meta;

import com.cognos.cps.services.pagelet.objects.v1.types.Fault;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.LocalizableRuntimeException;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.xts.XTSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ErrorWrapper
implements IXMLSerializable {
    private Throwable throwable;
    private String origin;

    public ErrorWrapper(Throwable throwable, String origin) {
        this.throwable = throwable;
        this.origin = origin;
    }

    @Override
    public void read(XMLStreamReader xsr) throws XMLStreamException {
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("error");
        if (this.throwable != null) {
            String code;
            xsw.writeStartElement("code");
            Throwable t = ErrorWrapper.getRootCause(this.throwable);
            if (t instanceof XTSException) {
                code = ((XTSException)t).getKey();
            } else {
                code = t.getClass().getName();
                int index = code.lastIndexOf(46);
                if (index != -1) {
                    code = code.substring(index + 1);
                }
            }
            xsw.writeCharacters(code);
            xsw.writeEndElement();
        }
        xsw.writeStartElement("message");
        if (this.throwable.getLocalizedMessage() != null) {
            xsw.writeCharacters(this.throwable.getLocalizedMessage());
        } else if (this.throwable.getMessage() != null) {
            xsw.writeCharacters(this.throwable.getMessage());
        }
        xsw.writeEndElement();
        xsw.writeStartElement("details");
        StringWriter stringWriter = new StringWriter();
        this.throwable.printStackTrace(new PrintWriter(stringWriter));
        xsw.writeCharacters(stringWriter.getBuffer().toString());
        xsw.writeEndElement();
        if (this.origin != null) {
            xsw.writeStartElement("origin");
            xsw.writeCharacters(this.origin);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.flush();
    }

    public Throwable getException() {
        return this.throwable;
    }

    private static Throwable getRootCause(Throwable t) {
        XTSException xtsEx;
        if (t instanceof InvalidCredentialsFault) {
            return t;
        }
        if (t instanceof LocalizableException) {
            LocalizableException locEx = (LocalizableException)t;
            if (locEx.getRootCause() != null) {
                return ErrorWrapper.getRootCause(locEx.getRootCause());
            }
        } else if (t instanceof LocalizableRuntimeException) {
            LocalizableRuntimeException locEx = (LocalizableRuntimeException)t;
            if (locEx.getRootCause() != null) {
                return ErrorWrapper.getRootCause(locEx.getRootCause());
            }
        } else if (t instanceof Fault) {
            Fault cpsEx = (Fault)t;
            if (cpsEx.getRootCause() != null) {
                return ErrorWrapper.getRootCause(cpsEx.getRootCause());
            }
        } else if (t instanceof XTSException && (xtsEx = (XTSException)t).getDetail() != null) {
            return ErrorWrapper.getRootCause(xtsEx.getDetail());
        }
        return t;
    }
}

