/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.meta;

import com.cognos.portal.fragment.meta.MetaControlGroup;
import com.cognos.portal.fragment.meta.MetaDefault;
import com.cognos.portal.fragment.meta.MetaLocalizedString;
import com.cognos.portal.fragment.meta.MetaProperty;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.ListEnumerator;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.StaxUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Meta
implements IXMLSerializable {
    List customs;
    List transients;
    List controlGroups;
    List modes;
    List windowStates;
    Validator validator = null;
    String requiredCapabilities;

    public Meta(XMLStreamReader xsr) throws XMLStreamException {
        this.read(xsr);
    }

    public Meta() {
    }

    public Meta(Validator obj) {
        this.validator = obj;
    }

    public void addControlGroup(MetaControlGroup aControlGroup) {
        if (this.controlGroups == null) {
            this.controlGroups = new ArrayList();
        }
        this.controlGroups.add(aControlGroup);
    }

    public void addCustomProperty(MetaProperty property) {
        if (this.customs == null) {
            this.customs = new ArrayList();
        }
        this.customs.add(property);
    }

    public void removeControlGroup(String aGroupId) {
        if (this.controlGroups != null) {
            Iterator it = this.controlGroups.iterator();
            while (it.hasNext()) {
                MetaControlGroup group = (MetaControlGroup)it.next();
                if (!group.getGroupId().equals(aGroupId)) continue;
                it.remove();
                return;
            }
        }
    }

    public void removeCustomProperty(String name) {
        if (this.customs != null) {
            Iterator it = this.customs.iterator();
            while (it.hasNext()) {
                MetaProperty prop = (MetaProperty)it.next();
                if (!prop.getName().equals(name)) continue;
                it.remove();
                return;
            }
        }
    }

    public Enumeration getControlGroups() {
        return new ListEnumerator(this.controlGroups);
    }

    public Enumeration getTransientProperties() {
        return new ListEnumerator(this.transients);
    }

    public void addTransientProperty(MetaProperty property) {
        if (this.transients == null) {
            this.transients = new ArrayList();
        }
        this.transients.add(property);
    }

    public void removeTransientProperty(String name) {
        if (this.transients != null) {
            Iterator it = this.transients.iterator();
            while (it.hasNext()) {
                MetaProperty prop = (MetaProperty)it.next();
                if (!prop.getName().equals(name)) continue;
                it.remove();
                return;
            }
        }
    }

    public Enumeration getCustomProperties() {
        return new ListEnumerator(this.customs);
    }

    public void setRequiredCapabilities(String requiredCapabilities) {
        this.requiredCapabilities = requiredCapabilities;
    }

    public String getRequiredCapabilities() {
        return this.requiredCapabilities;
    }

    public void addMode(String mode) {
        if (this.modes == null) {
            this.modes = new ArrayList();
        }
        this.modes.add(mode);
    }

    public void removeMode(String mode) {
        if (this.modes != null) {
            this.modes.remove(mode);
        }
    }

    public Enumeration getModes() {
        return new ListEnumerator(this.modes);
    }

    public void addWindowState(String windowState) {
        if (this.windowStates == null) {
            this.windowStates = new ArrayList();
        }
        this.windowStates.add(windowState);
    }

    public void removeWindowState(String windowState) {
        if (this.windowStates != null) {
            this.windowStates.remove(windowState);
        }
    }

    public Enumeration getWindowStates() {
        return new ListEnumerator(this.windowStates);
    }

    @Override
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("meta");
        if (this.modes != null) {
            this.writeModes(writer);
        }
        if (this.windowStates != null) {
            this.writeWindowStates(writer);
        }
        if (this.customs != null) {
            this.writeProperties(this.customs, "customProperties", writer);
        }
        if (this.transients != null) {
            this.writeProperties(this.transients, "transientProperties", writer);
        }
        if (this.controlGroups != null) {
            this.writeControlGroups(this.controlGroups, writer);
        }
        writer.writeEndElement();
        writer.flush();
    }

    private void writeModes(XMLStreamWriter writer) throws XMLStreamException {
        for (String mode : this.modes) {
            writer.writeStartElement("modes");
            writer.writeCharacters(mode);
            writer.writeEndElement();
        }
    }

    private void writeWindowStates(XMLStreamWriter writer) throws XMLStreamException {
        for (String windowState : this.windowStates) {
            writer.writeStartElement("windowStates");
            writer.writeCharacters(windowState);
            writer.writeEndElement();
        }
    }

    private void writelocalizedString(String name, MetaLocalizedString string, XMLStreamWriter writer) throws XMLStreamException {
        String value;
        writer.writeStartElement(name);
        if (string.getLang() != null) {
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", string.getLang());
        }
        if (string.getResourceID() != null) {
            writer.writeAttribute("resourceName", string.getResourceID());
        }
        if ((value = string.getString()) != null) {
            writer.writeCharacters(value);
        }
        writer.writeEndElement();
    }

    private void writeControlGroups(List list, XMLStreamWriter writer) throws XMLStreamException {
        for (MetaControlGroup aGroup : list) {
            writer.writeStartElement("controlGroups");
            writer.writeAttribute("id", aGroup.getGroupId());
            MetaLocalizedString label = aGroup.getLabel();
            if (label != null) {
                this.writelocalizedString("label", label, writer);
            }
            writer.writeEndElement();
        }
    }

    private void writeProperties(List list, String name, XMLStreamWriter writer) throws XMLStreamException {
        for (MetaProperty m : list) {
            MetaDefault metaDefault;
            MetaLocalizedString hint;
            writer.writeStartElement(name);
            writer.writeAttribute("name", m.getName());
            MetaLocalizedString title = m.getTitle();
            if (title != null) {
                this.writelocalizedString("label", title, writer);
            }
            if ((hint = m.getHint()) != null) {
                this.writelocalizedString("hint", hint, writer);
            }
            if (m.getDataType() != null) {
                writer.writeStartElement("datatype");
                StaxUtils.writeQNameText(writer, m.getDataType());
                writer.writeEndElement();
            }
            if ((metaDefault = m.getDefault()) != null) {
                writer.writeStartElement("default");
                MetaLocalizedString value = metaDefault.getValue();
                if (value != null) {
                    this.writelocalizedString("value", value, writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public void read(XMLStreamReader reader) throws XMLStreamException {
        if (this.transients != null) {
            this.transients.clear();
        }
        if (this.customs != null) {
            this.customs.clear();
        }
        if (this.modes != null) {
            this.modes.clear();
        }
        if (this.windowStates != null) {
            this.windowStates.clear();
        }
        if (this.controlGroups != null) {
            this.controlGroups.clear();
        }
        MetaProperty property = null;
        MetaDefault defaultValue = null;
        MetaControlGroup aGroup = null;
        boolean hasValidate = false;
        int level = 0;
        int event = reader.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = reader.getLocalName();
                    if ("transientProperties".equals(localName)) {
                        hasValidate = false;
                        property = new MetaProperty();
                        property.setName(reader.getAttributeValue("", "name"));
                        this.addTransientProperty(property);
                    } else if ("controlGroups".equals(localName)) {
                        aGroup = new MetaControlGroup();
                        aGroup.setGroupId(reader.getAttributeValue("", "id"));
                        this.addControlGroup(aGroup);
                    } else if ("customProperties".equals(localName)) {
                        hasValidate = false;
                        property = new MetaProperty();
                        property.setName(reader.getAttributeValue("", "name"));
                        this.addCustomProperty(property);
                    } else {
                        MetaLocalizedString localizedStr;
                        if ("requiredCapabilities".equals(localName)) {
                            this.setRequiredCapabilities(reader.getElementText());
                            break;
                        }
                        if ("modes".equals(localName)) {
                            this.addMode(reader.getElementText());
                            break;
                        }
                        if ("windowStates".equals(localName)) {
                            this.addWindowState(reader.getElementText());
                            break;
                        }
                        if ("globalValidator".equals(localName)) {
                            if (this.validator != null) {
                                this.validator.readValidatorParam(reader);
                                break;
                            }
                            StaxUtils.moveToNextSibling(reader);
                            break;
                        }
                        if (aGroup != null) {
                            if ("label".equals(localName)) {
                                localizedStr = new MetaLocalizedString();
                                localizedStr.setLang(reader.getAttributeValue("", "lang"));
                                localizedStr.setResourceID(reader.getAttributeValue("", "resourceName"));
                                localizedStr.setString(reader.getElementText());
                                aGroup.setLabel(localizedStr);
                                aGroup = null;
                                break;
                            }
                        } else if (property != null) {
                            if ("label".equals(localName)) {
                                localizedStr = new MetaLocalizedString();
                                localizedStr.setLang(reader.getAttributeValue("", "lang"));
                                localizedStr.setResourceID(reader.getAttributeValue("", "resourceName"));
                                localizedStr.setString(reader.getElementText());
                                property.setTitle(localizedStr);
                                break;
                            }
                            if ("hint".equals(localName)) {
                                localizedStr = new MetaLocalizedString();
                                localizedStr.setLang(reader.getAttributeValue("", "lang"));
                                localizedStr.setResourceID(reader.getAttributeValue("", "resourceName"));
                                localizedStr.setString(reader.getElementText());
                                property.setHint(localizedStr);
                                break;
                            }
                            if ("datatype".equals(localName)) {
                                property.setDataType(StaxUtils.toQName(reader.getElementText(), reader.getNamespaceContext()));
                                break;
                            }
                            if ("default".equals(localName)) {
                                defaultValue = new MetaDefault();
                                property.setDefault(defaultValue);
                            } else if (!"control".equals(localName)) {
                                if (defaultValue != null) {
                                    if ("value".equals(localName)) {
                                        localizedStr = new MetaLocalizedString();
                                        localizedStr.setLang(reader.getAttributeValue("", "lang"));
                                        localizedStr.setResourceID(reader.getAttributeValue("", "resourceName"));
                                        localizedStr.setString(reader.getElementText());
                                        defaultValue.setValue(localizedStr);
                                        break;
                                    }
                                    if ("enum".equals(localName)) {
                                        defaultValue.addEnumValue(reader.getElementText());
                                        break;
                                    }
                                } else if ("validate".equals(localName)) {
                                    hasValidate = true;
                                    if (this.validator != null) {
                                        this.validator.addValidatorForProperty(property.getName(), property.getDataType(), reader);
                                        break;
                                    }
                                    StaxUtils.moveToNextSibling(reader);
                                    break;
                                }
                            }
                        }
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level < 0) {
                        return;
                    }
                    if ("default".equals(reader.getLocalName())) {
                        defaultValue = null;
                        break;
                    }
                    if (!"customProperties".equals(reader.getLocalName()) && !"transientProperties".equals(reader.getLocalName()) || this.validator == null || property == null || hasValidate) break;
                    this.validator.addValidatorForProperty(property.getName(), property.getDataType(), null);
                }
            }
            event = reader.next();
        }
    }
}

