/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.meta;

import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.StaxUtils;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class NamedParameters
extends Parameters
implements IXMLSerializable {
    private String name;
    boolean isModified;

    public NamedParameters(XMLStreamReader xsr) throws XMLStreamException {
        this.read(xsr);
        this.setNotModified();
    }

    public NamedParameters(String name) {
        this.name = name;
    }

    @Override
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(this.name);
        for (Parameters.NameValuePair valuePair : this) {
            String[] values = valuePair.getValues();
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                writer.writeStartElement("param");
                writer.writeAttribute("name", valuePair.getName());
                if (values[i] != null) {
                    writer.writeCharacters(values[i]);
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        writer.flush();
    }

    @Override
    public void read(XMLStreamReader xsr) throws XMLStreamException {
        if (!xsr.isStartElement()) {
            StaxUtils.moveToNextElement(xsr);
        }
        this.name = xsr.getLocalName();
        this.clear();
        String name = null;
        int level = 0;
        while (xsr.hasNext()) {
            int event = xsr.next();
            String localName = null;
            switch (event) {
                case 1: {
                    localName = xsr.getLocalName();
                    if ("param".equals(localName)) {
                        name = xsr.getAttributeValue("", "name");
                        String text = xsr.getElementText();
                        String value = text != null ? text : "";
                        this.add(name, value);
                        if (level != 0) break;
                        level = 1;
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level <= 0) {
                        return;
                    }
                    localName = xsr.getLocalName();
                    if (!"param".equals(localName)) break;
                    name = null;
                }
            }
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setNotModified() {
        this.isModified = false;
    }

    private void setModified() {
        if (!this.isModified) {
            this.isModified = true;
        }
    }

    @Override
    public boolean add(Object o) {
        this.setModified();
        return super.add(o);
    }

    @Override
    public Parameters.NameValuePair add(String name, String value) {
        this.setModified();
        return super.add(name, value);
    }

    @Override
    public Parameters.NameValuePair add(String name, String[] values) {
        this.setModified();
        return super.add(name, values);
    }

    @Override
    public boolean addAll(Collection c) {
        this.setModified();
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.setModified();
        super.clear();
    }

    @Override
    public boolean remove(Object o) {
        this.setModified();
        return super.remove(o);
    }

    @Override
    public boolean remove(String name) {
        this.setModified();
        return super.remove(name);
    }

    @Override
    public boolean removeAll(Collection c) {
        this.setModified();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        this.setModified();
        return super.retainAll(c);
    }

    @Override
    public void setValue(String name, String value) {
        this.setModified();
        super.setValue(name, value);
    }

    @Override
    public void setValues(String name, String[] values) {
        this.setModified();
        super.setValues(name, values);
    }
}

