/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.NamedParameters;
import com.cognos.portal.fragment.producer.FragmentRuntimeTrace;
import com.cognos.portal.fragment.producer.helpers.Preferences;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.schemas.fragments.Css;
import com.cognos.portal.schemas.fragments.Default;
import com.cognos.portal.schemas.fragments.Error;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Info;
import com.cognos.portal.schemas.fragments.Library;
import com.cognos.portal.schemas.fragments.Meta;
import com.cognos.portal.schemas.fragments.Properties;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.LocalizableRuntimeException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.RuntimeTrace;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.LocalizedXMLStreamReader;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLInsert;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class FragmentProducer
extends PipelineDefinition {
    private Fragment fragment;
    private XMLRecorderStreamWriter metaXml;
    private XMLRecorderStreamWriter infoXml;
    private String messageFile;
    private ServiceLogger logger;
    private static final String META_XML = "<meta/>";
    private static final String GLOBAL_VALIDATOR_XML = "<globalValidator version=\"1.0\"/>";
    private static final String TARGET_PARAM_VALIDATOR_XML = "<val:parameter xmlns:val=\"http://developer.cognos.com/schemas/validator/1/\" skipJavaScript=\"true\"><val:name>target</val:name><val:rule><val:type><val:string minLength=\"1\" maxLength=\"256\" /></val:type></val:rule></val:parameter>";

    public FragmentProducer(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(FragmentProducer.class) : null;
    }

    @Override
    protected RuntimeTrace createRuntimeTrace(Pipeline pipeline) {
        return new FragmentRuntimeTrace(pipeline, this, this.logger);
    }

    protected void readImplementation(XMLStreamReader reader, Environment env) throws PipelineException {
        this.fragment = new Fragment();
        int level = 0;
        try {
            int event = reader.getEventType();
            while (true) {
                switch (event) {
                    case 1: {
                        String localName = reader.getLocalName();
                        if ("message".equals(localName)) {
                            this.messageFile = reader.getAttributeValue("", "source");
                        } else {
                            if ("info".equals(localName)) {
                                this.infoXml = XMLStreamFactory.createXMLRecorderStreamWriter();
                                StaxUtils.copyCurrentElement(reader, this.infoXml);
                                break;
                            }
                            if ("meta".equals(localName)) {
                                this.copyMeta(reader);
                                break;
                            }
                            if ("library".equals(localName)) {
                                Library scriptLibrary = new Library();
                                scriptLibrary.read(reader);
                                this.fragment.addLibrary(scriptLibrary);
                                break;
                            }
                            if ("css".equals(localName)) {
                                Css styleLink = new Css();
                                styleLink.read(reader);
                                this.fragment.addCss(styleLink);
                                break;
                            }
                            if ("pipeline".equals(localName)) {
                                this.readPipeline(reader, env);
                                break;
                            }
                        }
                        ++level;
                        break;
                    }
                    case 2: {
                        --level;
                        break;
                    }
                    case 7: {
                        ++level;
                        break;
                    }
                    case 8: {
                        --level;
                    }
                }
                if (reader.hasNext() && level > 0) {
                    event = reader.next();
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not process implementation file xml", e);
            }
            throw new PipelineException("pf.fragment.producer.executionfailed", e);
        }
    }

    private void copyMeta(XMLStreamReader reader) throws XMLStreamException {
        XMLStreamReader targetValidatorReader = XMLStreamFactory.createXMLStreamReader(new StringReader(TARGET_PARAM_VALIDATOR_XML));
        XMLStreamReader globalValidatorReader = XMLStreamFactory.createXMLStreamReader(new StringReader(GLOBAL_VALIDATOR_XML));
        XMLInsert insertReader = new XMLInsert(reader);
        insertReader.insertXMLUnderIfNotExists("meta", globalValidatorReader);
        insertReader.insertXMLUnder("globalValidator", targetValidatorReader);
        this.metaXml = XMLStreamFactory.createXMLRecorderStreamWriter();
        StaxUtils.copyCurrentElement(insertReader, this.metaXml);
    }

    @Override
    public void initialize(XMLStreamReader reader, Environment env) throws PipelineException {
        this.readImplementation(reader, env);
        if (this.metaXml == null) {
            try {
                this.copyMeta(XMLStreamFactory.createXMLStreamReader(new StringReader(META_XML)));
            }
            catch (XMLStreamException e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("could not add default meta element", e);
                }
                throw new PipelineException("pf.fragment.producer.executionfailed", e);
            }
        }
    }

    @Override
    public String executePipeline(Pipeline pipeline) throws PipelineException {
        try {
            int i;
            Fragment runtimeFragment = this.createFragmentCopy(this.fragment, pipeline);
            pipeline.setParam("fragment", runtimeFragment);
            XMLParameters customs = new XMLParameters("customs");
            XMLParameters transients = new XMLParameters("transients", true);
            XMLParameters interactions = new XMLParameters("interactions");
            NamedParameters controllerParams = new NamedParameters("controllerParams");
            Parameters params = (Parameters)pipeline.getParam("params");
            Meta meta = runtimeFragment.getMeta();
            for (Parameters.NameValuePair nvp : params) {
                String name = nvp.getName();
                if (name.startsWith("frag-")) {
                    ((Parameters)controllerParams).add(name, nvp.getValues());
                    continue;
                }
                String[] values = nvp.getValues();
                if (values == null) continue;
                for (i = 0; i < values.length; ++i) {
                    XMLParameter xmlParam = new XMLParameter(name, values[i]);
                    boolean isCustom = this.isCustom(xmlParam.getName(), meta);
                    if (isCustom) {
                        customs.add(xmlParam);
                        continue;
                    }
                    boolean isTransient = this.isTransient(xmlParam.getName(), meta);
                    if (isTransient) {
                        transients.add(xmlParam);
                        continue;
                    }
                    interactions.add(xmlParam);
                }
            }
            if (meta != null) {
                Properties prop = null;
                Default defaultObj = null;
                String defaultValue = null;
                int count = meta.getCustomPropertiesCount();
                for (i = 0; i < count; ++i) {
                    prop = meta.getCustomProperties(i);
                    defaultObj = prop.getDefault();
                    if (defaultObj == null) continue;
                    defaultValue = defaultObj.getValue();
                    if (customs.getXMLParameter(prop.getName()) != null || defaultValue == null || defaultValue.length() <= 0) continue;
                    customs.add(new XMLParameter(prop.getName(), defaultValue));
                }
                count = meta.getTransientPropertiesCount();
                for (i = 0; i < count; ++i) {
                    prop = meta.getTransientProperties(i);
                    defaultObj = prop.getDefault();
                    if (defaultObj == null) continue;
                    defaultValue = defaultObj.getValue();
                    if (transients.getXMLParameter(prop.getName()) != null || defaultValue == null || defaultValue.length() <= 0) continue;
                    transients.add(new XMLParameter(prop.getName(), defaultValue));
                }
            }
            customs.setNotModified();
            pipeline.setParam("customs", customs);
            pipeline.setParam("transients", transients);
            pipeline.setParam("controllerParams", controllerParams);
            pipeline.setParam("interactions", interactions);
            if ("meta-only".equals(controllerParams.getValue("frag-directive")) && this.hasOutputProcess("fragmentResponse_metaonly")) {
                pipeline.setParam("target", "fragmentResponse_metaonly");
            }
            if (meta != null && !pipeline.getEnv().hasCapabilities(meta.getRequiredCapabilities())) {
                throw new PipelineException("pf.fragment.server.notsufficientcapabilities_portlet");
            }
            XMLParameters state = this.getStateParameters(params);
            state.setNotModified();
            pipeline.setParam("state", state);
            if (pipeline.acceptsParam("preferences")) {
                pipeline.setParam("preferences", new Preferences(pipeline.getEnv()));
            }
        }
        catch (LocalizableRuntimeException e) {
            IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
            Fragment frag = new Fragment();
            Error error = new Error();
            String code = e.getClass().getName();
            int index = code.lastIndexOf(46);
            if (index != -1) {
                code = code.substring(index + 1);
            }
            if ("InvalidCredentialsFault".equals(code)) {
                code = "invalidCredentials";
            }
            error.setCode(code);
            error.setMessage(e.getLocalizedMessage());
            frag.setError(error);
            try {
                XMLStreamWriter xsw = output.getXMLStreamWriter();
                frag.write(xsw);
                xsw.flush();
            }
            catch (XMLStreamException ex) {
                throw new PipelineException("pf.pipeline.process.error", new Object[]{"unknown"}, ex);
            }
            pipeline.addOutput("runtime_error", output);
            return "runtime_error";
        }
        return super.executePipeline(pipeline);
    }

    private boolean isCustom(String name, Meta meta) {
        if (meta != null && name != null) {
            int count = meta.getCustomPropertiesCount();
            for (int i = 0; i < count; ++i) {
                Properties prop = meta.getCustomProperties(i);
                if (!name.equals(prop.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTransient(String name, Meta meta) {
        if (meta != null && name != null) {
            int count = meta.getTransientPropertiesCount();
            for (int i = 0; i < count; ++i) {
                Properties prop = meta.getTransientProperties(i);
                if (!name.equals(prop.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private XMLParameters getStateParameters(Parameters params) {
        XMLParameters stateParams;
        block5: {
            String state;
            stateParams = new XMLParameters("state");
            if (params != null && (state = params.getValue("frag-state")) != null && state.length() > 0) {
                byte[] decoded = EncodingUtils.base64decode(state, true);
                try {
                    StringReader reader = new StringReader(new String(decoded, "UTF-8"));
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(reader);
                    stateParams.read(xsr);
                }
                catch (UnsupportedEncodingException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("could not decode the state", e);
                    }
                }
                catch (XMLStreamException e) {
                    if (this.logger == null || !this.logger.isErrorEnabled()) break block5;
                    this.logger.error("could not create the xml stream reader", e);
                }
            }
        }
        return stateParams;
    }

    private Fragment createFragmentCopy(Fragment fragment, Pipeline pipeline) throws PipelineException {
        Fragment copy = null;
        if (fragment != null) {
            int i;
            LocalizedXMLStreamReader xsr;
            copy = new Fragment();
            if (this.infoXml != null) {
                Info info = new Info();
                try {
                    xsr = new LocalizedXMLStreamReader(this.infoXml.toXMLStreamReader(), pipeline.getEnv(), this.messageFile, pipeline.getEnv().getProductLocale());
                    if (xsr.nextTag() == 1) {
                        info.read(xsr);
                    }
                }
                catch (XMLStreamException e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("error while reading the info xml", e);
                    }
                    throw new PipelineException("pf.fragment.producer.executionfailed");
                }
                copy.setInfo(info);
            }
            if (this.metaXml != null) {
                Meta meta = new Meta();
                try {
                    xsr = new LocalizedXMLStreamReader(this.metaXml.toXMLStreamReader(), pipeline.getEnv(), this.messageFile, pipeline.getEnv().getProductLocale());
                    if (xsr.nextTag() == 1) {
                        meta.read(xsr);
                    }
                }
                catch (XMLStreamException e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("error while reading the meta xml", e);
                    }
                    throw new PipelineException("pf.fragment.producer.executionfailed");
                }
                copy.setMeta(meta);
            }
            int count = fragment.getCssCount();
            for (i = 0; i < count; ++i) {
                copy.addCss(fragment.getCss(i));
            }
            count = fragment.getLibraryCount();
            for (i = 0; i < count; ++i) {
                copy.addLibrary(fragment.getLibrary(i));
            }
        }
        return copy;
    }
}

