/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.meta.ErrorWrapper;
import com.cognos.portal.schemas.AnyType;
import com.cognos.portal.schemas.fragments.Error;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Library;
import com.cognos.portal.schemas.fragments.Markup;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.RuntimeTrace;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.IsolatedXMLStreamReader;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class FragmentRuntimeTrace
extends RuntimeTrace {
    private String FRAGMENT_DEBUG_OUTPUT_LABEL = "fragment_debug_output";
    private PipelineDefinition pd;
    private Pipeline pipeline;

    public FragmentRuntimeTrace(Pipeline pipeline, PipelineDefinition pipelineDefinition, ServiceLogger logger) {
        super(pipeline, pipelineDefinition, logger);
        this.pipeline = pipeline;
        this.pd = pipelineDefinition;
    }

    @Override
    public void setDebugMode(String debug) {
        super.setDebugMode(debug);
        if ("fragment".equals(debug) && !this.isDebugMode()) {
            this.enableDebugMode();
        }
    }

    @Override
    public String updateOutputForDebug(String outputName) throws PipelineException {
        try {
            Fragment fragment;
            if ("fragment".equals(this.getDebugCommand()) && (fragment = (Fragment)this.pipeline.getParam("fragment")) != null) {
                Markup m;
                Library library = new Library();
                library.setHref("$WEB$/fragments/debug/pipeline.js");
                fragment.addLibrary(library);
                if (this.getErrorOriginProcess() != null) {
                    XMLStreamReader errorReader;
                    IPipelineOutput errorOutput;
                    if (fragment.getError() == null && (errorOutput = this.pipeline.getOutput(this.getErrorOriginProcess().getErrorOutputLabel())) != null && (errorReader = errorOutput.toXMLStreamReader()) != null && errorReader.nextTag() != -1 && "fragment".equals(errorReader.getLocalName())) {
                        fragment.read(errorReader);
                    }
                    if (fragment.getError() == null) {
                        ErrorWrapper errorWrapper = (ErrorWrapper)this.pipeline.getParam("error");
                        Error error = new Error();
                        String code = null;
                        String message = null;
                        String details = null;
                        if (errorWrapper != null) {
                            Throwable t = errorWrapper.getException();
                            code = t.getClass().getName();
                            message = t.getMessage();
                            Throwable cause = t.getCause();
                            if (cause != null) {
                                StringWriter writer = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(writer);
                                cause.printStackTrace(printWriter);
                                details = writer.getBuffer().toString();
                            }
                        } else {
                            code = "fragment_error";
                            message = "An error occured while executing the fragment producer. More information is available in the pipeline debug view.";
                        }
                        error.setCode(code);
                        error.setMessage(message);
                        error.setDetails(details);
                    }
                }
                if (fragment.getMarkupCount() == 0) {
                    m = new Markup();
                    String defaultMarkup = null;
                    if (this.getErrorOriginProcess() != null) {
                        StringWriter writer = new StringWriter();
                        Error error = fragment.getError();
                        if (error != null) {
                            writer.write("The following error has occured while executing the fragment producer:<br> ");
                            writer.write(error.getCode() + "<br>");
                            writer.write(error.getMessage() + "<br>");
                            String detail = error.getDetails();
                            if (detail != null) {
                                writer.write("Details:<div style=\"height:200px; overflow: auto; border:solid 1px black; font-size:8pt\"><pre>");
                                StringBuffer encodedDetail = new StringBuffer();
                                EncodingUtils.htmlencode(detail, encodedDetail);
                                writer.write(encodedDetail.toString());
                                writer.write("</pre></div>");
                            }
                        }
                        defaultMarkup = writer.getBuffer().toString();
                    } else {
                        defaultMarkup = "";
                    }
                    m.setMarkupString(defaultMarkup);
                    this.pipeline.getOutput(outputName);
                    fragment.addMarkup(m);
                }
                m = fragment.getMarkup(0);
                IPipelineOutput output = this.getDebugHelper().getPipelineDebugOutput(this.pd, this.logger);
                if (output != null) {
                    if (m.getMarkupString() != null) {
                        StringBuffer html = new StringBuffer();
                        this.writePipelineDebugHtml(html);
                        StringBuffer script = new StringBuffer();
                        this.writePipelineJavascript(output.toXMLStreamReader(), script);
                        m.setMarkupString(m.getMarkupString() + html.toString() + script.toString());
                    } else if (m.getMarkupXml() != null) {
                        AnyType anyType = m.getMarkupXml();
                        StringWriter writer = new StringWriter();
                        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
                        xsw.writeStartElement("markup");
                        anyType.write(xsw);
                        this.writePipelineDebugHtml(xsw);
                        this.writePipelineJavascript(output.toXMLStreamReader(), xsw);
                        xsw.writeEndElement();
                        xsw.close();
                        anyType.read(XMLStreamFactory.createXMLStreamReader(new StringReader(writer.getBuffer().toString())));
                    }
                }
                IPipelineOutput newOutput = PipelineOutputFactory.getInstance().createOutput();
                fragment.write(newOutput.getXMLStreamWriter());
                this.pipeline.addOutput(this.FRAGMENT_DEBUG_OUTPUT_LABEL, newOutput);
                return this.FRAGMENT_DEBUG_OUTPUT_LABEL;
            }
            return super.updateOutputForDebug(outputName);
        }
        catch (XMLStreamException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error while writing the debug output for the fragment", e);
            }
            throw new PipelineException("Cannot write debug output for fragment", e);
        }
    }

    private void writePipelineDebugHtml(StringBuffer buffer) throws XMLStreamException {
        buffer.append("<div id=\"_THIS_debugViewContainer\"></div>");
    }

    private void writePipelineJavascript(XMLStreamReader xsr, StringBuffer buffer) throws XMLStreamException {
        buffer.append("<script>");
        buffer.append(this.getPipelineJavascript(xsr));
        buffer.append("</script>");
    }

    private void writePipelineDebugHtml(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("div");
        writer.writeAttribute("id", "_THIS_debugViewContainer");
        writer.writeEndElement();
    }

    private void writePipelineJavascript(XMLStreamReader xsr, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("script");
        writer.writeCharacters(this.getPipelineJavascript(xsr));
        writer.writeEndElement();
    }

    private String getPipelineJavascript(XMLStreamReader xsr) {
        StringBuffer buffer = new StringBuffer();
        try {
            if (StaxUtils.moveToElement("pipeline", xsr)) {
                buffer.append("function _THIS_load(){ \n");
                buffer.append("_F_pipeline.executions['_THIS_execution'] = new _F_pipeline.execution({id:\"_THIS_execution\", name:_THIS_.title + \" - Pipeline\"});\n");
                buffer.append("var _THIS_execution = _F_pipeline.executions['_THIS_execution'];\n");
                while (xsr.hasNext()) {
                    xsr.next();
                    if (!xsr.isStartElement()) continue;
                    String localName = xsr.getLocalName();
                    if ("params".equals(localName)) {
                        this.writePipelineParts(xsr, buffer);
                        continue;
                    }
                    if ("processes".equals(localName)) {
                        this.writePipelineParts(xsr, buffer);
                        continue;
                    }
                    StaxUtils.moveToNextSibling(xsr);
                }
                buffer.append("}\n");
                buffer.append("_F_pipeline.attach(_THIS_, \"_THIS_execution\", _THIS_load);\n");
            }
        }
        catch (Exception e) {
            buffer.append("alert(\"Error while writing pipeline debug information</div>\");\n");
        }
        return buffer.toString();
    }

    private void writePipelineParts(XMLStreamReader xsr, StringBuffer buffer) {
        try {
            xsr = new IsolatedXMLStreamReader(xsr);
            xsr.nextTag();
            while (xsr.hasNext()) {
                xsr.next();
                if (!xsr.isStartElement()) continue;
                String localName = xsr.getLocalName();
                if ("param".equals(localName)) {
                    this.writeParamJavascript(xsr, "_THIS_execution", buffer);
                    continue;
                }
                if ("process".equals(localName)) {
                    this.writeProcessJavascript(xsr, "_THIS_execution", buffer);
                    continue;
                }
                StaxUtils.moveToNextSibling(xsr);
            }
        }
        catch (Exception e) {
            buffer.append("alert(\"Error while writing pipeline debug information</div>\");\n");
        }
    }

    private void writeParamJavascript(XMLStreamReader xsr, String parent, StringBuffer buffer) throws XMLStreamException {
        String name = xsr.getAttributeValue("", "name");
        String before = "";
        if (StaxUtils.moveToChildElement("runtimeValueBeforeExecution", xsr)) {
            before = this.getJavascriptValue(xsr);
        }
        String after = "";
        if (StaxUtils.moveToChildElement("runtimeValueAfterExecution", xsr)) {
            after = this.getJavascriptValue(xsr);
        }
        buffer.append(parent);
        buffer.append(".addParam(new _F_pipeline.param({name:\"" + name + "\", content:\"" + after + "\", initialValue: false}));\n");
        buffer.append(parent);
        buffer.append(".addParamInitialValue(new _F_pipeline.param({name:\"" + name + "\", content:\"" + before + "\", initialValue: true}));\n");
    }

    private String getJavascriptValue(XMLStreamReader xsr) throws XMLStreamException {
        if (xsr.getAttributeValue("", "null") != null) {
            return "NULL";
        }
        String type = xsr.getAttributeValue("", "class");
        if ("java.lang.String".equals(type)) {
            return EncodingUtils.javascriptencode(xsr.getElementText());
        }
        StringWriter writer = new StringWriter();
        XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(writer);
        StaxUtils.copyChildren(xsr, xsw);
        xsw.close();
        String value = writer.getBuffer().toString();
        value = value.replaceAll("_MIME_BOUNDARY_Q739K9UU82UDLK73", "_MIME_BOUNDARY_REPLACED_SO_IT_DOESNT_CONFLICT_WITH_RESPONSE");
        value = value.replaceAll("_THIS", "_(THIS)");
        return EncodingUtils.javascriptencode(value);
    }

    private void writeProcessJavascript(XMLStreamReader xsr, String parent, StringBuffer buffer) throws XMLStreamException {
        String name = xsr.getAttributeValue("", "name");
        buffer.append("var _THIS_process = new _F_pipeline.process({classname:\"\", name:\"" + name + "\"});\n");
        buffer.append(parent).append(".addProcess(_THIS_process);\n");
        xsr = new IsolatedXMLStreamReader(xsr);
        xsr.nextTag();
        while (xsr.hasNext()) {
            xsr.next();
            if (!xsr.isStartElement()) continue;
            String localName = xsr.getLocalName();
            if ("outputs".equals(localName)) {
                this.writeProcessPart(xsr, "_THIS_process", buffer);
                continue;
            }
            if ("inputs".equals(localName)) {
                this.writeProcessPart(xsr, "_THIS_process", buffer);
                continue;
            }
            if ("params".equals(localName)) {
                this.writeProcessPart(xsr, "_THIS_process", buffer);
                continue;
            }
            if ("trace".equals(localName)) {
                this.writeTraceJavascript(xsr, "_THIS_process", buffer);
                continue;
            }
            StaxUtils.moveToNextSibling(xsr);
        }
    }

    private void writeProcessPart(XMLStreamReader xsr, String parent, StringBuffer buffer) throws XMLStreamException {
        xsr = new IsolatedXMLStreamReader(xsr);
        xsr.nextTag();
        while (xsr.hasNext()) {
            xsr.next();
            if (!xsr.isStartElement()) continue;
            String localName = xsr.getLocalName();
            if ("output".equals(localName)) {
                this.writeOutputJavascript(xsr, "_THIS_process", buffer);
                continue;
            }
            if ("input".equals(localName)) {
                this.writeInputJavascript(xsr, "_THIS_process", buffer);
                continue;
            }
            if ("param".equals(localName)) {
                this.writeParamJavascript(xsr, "_THIS_process", buffer);
                continue;
            }
            StaxUtils.moveToNextSibling(xsr);
        }
    }

    private void writeOutputJavascript(XMLStreamReader xsr, String parent, StringBuffer buffer) throws XMLStreamException {
        String name = xsr.getAttributeValue("", "name");
        String label = xsr.getAttributeValue("", "label");
        if (label == null) {
            label = "";
        }
        String content = "";
        if (StaxUtils.moveToChildElement("runtimeValue", xsr)) {
            content = this.getJavascriptValue(xsr);
        }
        buffer.append(parent);
        buffer.append(".addOutput(new _F_pipeline.output({name:\"" + name + "\", label:\"" + label + "\", content:\"" + content + "\"}));\n");
    }

    private void writeTraceJavascript(XMLStreamReader xsr, String parent, StringBuffer buffer) throws XMLStreamException {
        String name = xsr.getAttributeValue("", "name");
        String content = this.getJavascriptValue(xsr);
        buffer.append(parent);
        buffer.append(".addTrace(new _F_pipeline.trace({name:\"" + name + "\", content:\"" + content + "\"}));\n");
    }

    private void writeInputJavascript(XMLStreamReader xsr, String parent, StringBuffer buffer) throws XMLStreamException {
        String name = xsr.getAttributeValue("", "name");
        String label = xsr.getAttributeValue("", "label");
        String content = "";
        if (label == null) {
            label = "";
            if (StaxUtils.moveToChildElement("runtimeValue", xsr)) {
                content = this.getJavascriptValue(xsr);
            }
        }
        buffer.append(parent);
        buffer.append(".addInput(new _F_pipeline.input({name:\"" + name + "\", label:\"" + label + "\", content:\"" + content + "\"}));\n");
    }
}

