/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.XSLTFactory;
import com.cognos.portal.fragment.meta.NamedParameters;
import com.cognos.portal.fragment.producer.FragmentProducer;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.IPipelineProvider;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jd.xml.util.UriResolver;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import org.xml.sax.SAXException;

public class ProducerPipelineProvider
implements IPipelineProvider {
    static String xslt_path = "com/cognos/portal/fragment/producer/xslt/impl2pipeline.xslt";

    private static Reader transformImplementation(InputStream in, ServiceLogger logger) throws PipelineException {
        try {
            Stylesheet s = XSLTFactory.getInstance().getStylesheet(xslt_path, null);
            if (s != null) {
                StringWriter writer = new StringWriter();
                XmlSource source = new XmlSource("", in, true);
                XsltResult result = new XsltResult("", (Writer)writer, false);
                s.setUriResolver(new UriResolver(){

                    public XmlSource resolveUri(String href, String baseuri) throws IOException {
                        String path = xslt_path;
                        if (href != null && href.length() > 0) {
                            path = path.substring(0, path.lastIndexOf(47) + 1) + href;
                        }
                        return new XmlSource("", this.getClass().getClassLoader().getResourceAsStream(path), true);
                    }
                });
                s.transform(source, result);
                return new StringReader(writer.getBuffer().toString());
            }
        }
        catch (XsltException e) {
            if (logger.isErrorEnabled()) {
                logger.error("encountered an xslt error when transforming implementation file", e);
            }
            throw new PipelineException("cannot transform implementation file to pipeline spec", e);
        }
        catch (LocalizableException e) {
            if (logger.isErrorEnabled()) {
                logger.error("encountered an error retrieving the stylesheet", e);
            }
            throw new PipelineException("cannot transform implementation file to pipeline spec", e);
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error("encountered an IO error when transforming implementation file", e);
            }
            throw new PipelineException("cannot transform implementation file to pipeline spec", e);
        }
        catch (SAXException e) {
            if (logger.isErrorEnabled()) {
                logger.error("encountered a SAX error when transforming implementation file", e);
            }
            throw new PipelineException("cannot transform implementation file to pipeline spec", e);
        }
        return new InputStreamReader(in);
    }

    @Override
    public PipelineDefinition createPipelineDefinition(String path, Environment env, ServiceLogger logger) throws PipelineException {
        path = path + "/implementation.xml";
        InputStream in = null;
        try {
            in = env.getTargetStream(path, null);
        }
        catch (DashboardException e) {
            return null;
        }
        if (in != null) {
            Reader reader = ProducerPipelineProvider.transformImplementation(in, logger);
            try {
                XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(reader);
                FragmentProducer def = new FragmentProducer(logger);
                ((PipelineDefinition)def).initialize(xsr, env);
                return def;
            }
            catch (XMLStreamException e) {
                throw new PipelineException("could read implementation file for path '" + path + "'");
            }
        }
        return null;
    }

    @Override
    public void configurePipeline(Pipeline pipeline, Environment env) throws PipelineException {
        NamedParameters parameters = new NamedParameters("params");
        Enumeration e = env.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = env.getParameter(name);
            if ("target".equals(name)) {
                pipeline.setParam("target", value);
                continue;
            }
            ((Parameters)parameters).add(name, value);
        }
        pipeline.setParam("params", parameters);
    }
}

