/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.bseries.xts;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.util.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.Element;

public class XTSProcessorWrapper {
    protected String CALLER_ID = "CRN";
    private ServiceLogger logger;

    public IPipelineOutput invoke(String morphlet, Document input, Environment env) throws PipelineException {
        Object xtsRequestTimer = null;
        if (this.logger.isPerfLevelEnabled(1)) {
            xtsRequestTimer = this.logger.startTimer(1, "invoke", "Create XTSEnv + execute", null);
        }
        XTSEnvironment xtsenv = this.createXTSEnvironment(morphlet, env);
        try {
            XTSProcessor.getInstance((String)this.CALLER_ID).execute(morphlet, input, xtsenv);
            IPipelineOutput iPipelineOutput = this.getOutputResponse(input, env, xtsenv, null);
            return iPipelineOutput;
        }
        catch (XTSException e) {
            throw new PipelineException("failed to execute morphlet ", e);
        }
        finally {
            xtsenv.cleanup();
            if (xtsRequestTimer != null) {
                this.logger.stopTimer(xtsRequestTimer);
            }
        }
    }

    public void invokeNoResultProcess(String morphlet, Document input, Environment env) throws PipelineException {
        Object xtsRequestTimer = null;
        if (this.logger.isPerfLevelEnabled(1)) {
            xtsRequestTimer = this.logger.startTimer(1, "invokeNoResultProcess", "Create XTSEnv + execute", null);
        }
        XTSEnvironment xtsenv = this.createXTSEnvironment(morphlet, env);
        try {
            XTSProcessor.getInstance((String)this.CALLER_ID).execute(morphlet, input, xtsenv);
        }
        catch (XTSException e) {
            Throwable detail = e;
            XTSException xtserr = null;
            while (detail instanceof XTSException && (xtserr = detail).getDetail() != null) {
                detail = xtserr.getDetail();
            }
            if (xtserr instanceof XTSSoapFaultException) {
                Reader reader = ((XTSSoapFaultException)xtserr).getFaultReaderCopy();
                StringBuffer buf = new StringBuffer();
                try {
                    char[] cbuf = new char[4096];
                    int bytesRead = reader.read(cbuf, 0, cbuf.length);
                    while (bytesRead != -1) {
                        buf.append(cbuf, 0, bytesRead);
                        bytesRead = reader.read(cbuf, 0, cbuf.length);
                    }
                    if (buf.toString().indexOf("CM-REQ-4159") != -1) {
                        throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, xtserr);
                    }
                }
                catch (IOException ex) {
                    throw new PipelineException("failed to read soap fault", ex);
                }
            }
            throw new PipelineException("failed to execute morphlet ", detail);
        }
        finally {
            xtsenv.cleanup();
            if (xtsRequestTimer != null) {
                this.logger.stopTimer(xtsRequestTimer);
            }
        }
    }

    protected IPipelineOutput getOutputResponse(Document inputdoc, Environment env, XTSEnvironment xtsenv, List contentObjList) throws PipelineException {
        Object getOutputResponseTimer = null;
        if (this.logger.isPerfLevelEnabled(1)) {
            getOutputResponseTimer = this.logger.startTimer(1, "getOutputResponse", "Getting xts output response", null);
        }
        try {
            IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
            Element outputElement = inputdoc.getRootElement().element("output");
            List partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART);
            if (partElemList.size() > 0) {
                String xml;
                Element partElem = (Element)partElemList.get(0);
                Element entityBodyElem = partElem.element(XTSConstants.ELEM_NM_ENTITYBODY);
                if (entityBodyElem == null) {
                    IPipelineOutput iPipelineOutput = output;
                    return iPipelineOutput;
                }
                String refId = entityBodyElem.attributeValue("refId");
                if (refId != null) {
                    XTSOutputObject obj = xtsenv.getContentStream(refId);
                    if (obj == null) {
                        Object[] args = new String[]{refId};
                        throw new PipelineException("output.invalidrefid", args);
                    }
                    InputStream in = obj.getInputStream();
                    OutputStream out = output.getOutputStream();
                    byte[] buff = new byte[1024];
                    int read = 0;
                    while ((read = in.read(buff)) != -1) {
                        out.write(buff, 0, read);
                    }
                    out.close();
                    if (contentObjList != null) {
                        contentObjList.add(obj);
                    }
                    IPipelineOutput iPipelineOutput = output;
                    return iPipelineOutput;
                }
                List elements = entityBodyElem.elements();
                if (elements.size() == 1) {
                    xml = ((Element)elements.get(0)).asXML();
                } else {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("<result>");
                    for (Element e : elements) {
                        buffer.append(e.asXML());
                    }
                    buffer.append("</result>");
                    xml = buffer.toString();
                }
                XMLStreamWriter xsw = output.getXMLStreamWriter();
                if (xml != null) {
                    StaxUtils.copyCurrentElement(XMLStreamFactory.createXMLStreamReader(new StringReader(xml)), xsw);
                }
                xsw.flush();
                xsw.close();
                IPipelineOutput iPipelineOutput = output;
                return iPipelineOutput;
            }
            XMLStreamWriter xsw = output.getXMLStreamWriter();
            xsw.writeStartElement("error");
            xsw.writeCharacters("no output elements in xts output");
            xsw.writeEndElement();
            xsw.flush();
            IPipelineOutput iPipelineOutput = output;
            return iPipelineOutput;
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("cannot build xts output", e);
            }
            throw new PipelineException("cannot build xts output ", e);
        }
        catch (XTSException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("cannot build xts output", e);
            }
            throw new PipelineException("cannot build xts output ", e);
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not read XTS output", e);
            }
            throw new PipelineException("could not read XTS output ", e);
        }
        finally {
            if (getOutputResponseTimer != null) {
                this.logger.stopTimer(getOutputResponseTimer);
            }
        }
    }

    protected XTSEnvironment createXTSEnvironment(String morphlet, Environment env) {
        XTSEnvironment xtsenv = new XTSEnvironment(this.CALLER_ID);
        xtsenv.setMorphletName(morphlet);
        Locale locale = new Locale(env.getProductLocale());
        xtsenv.setLocale(locale);
        xtsenv.setLookupList(LocaleUtils.createLookupList((Locale)locale, (boolean)false));
        xtsenv.setRequestContext(ServiceLoggerImpl.getRequestId());
        xtsenv.setSessionContext(ServiceLoggerImpl.getSessionId());
        xtsenv.setStepContext("");
        xtsenv.setSubRequestContext("");
        return xtsenv;
    }

    public XTSProcessorWrapper(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(XTSProcessorWrapper.class) : null;
    }
}

