/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.helpers;

import com.cognos.portal.schemas.fragments.Param;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLParameter
extends Param {
    private static final String XML_MARKER = ".xml";
    private static final int XML_MARKER_LENGTH = ".xml".length();
    private String name;
    private String value;
    private boolean isXML;
    private XMLRecorderStreamWriter recordedXML;

    public XMLParameter(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public XMLParameter(XMLStreamReader reader) throws XMLStreamException {
        this.read(reader);
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.isXML = name.endsWith(XML_MARKER);
            this.name = this.isXML ? name.substring(0, name.length() - XML_MARKER_LENGTH) : name;
        }
    }

    @Override
    public void setValue(String value) {
        if (this.isXML && value != null) {
            try {
                StringBuffer tmpValue = new StringBuffer();
                tmpValue.append("<param name=\"");
                EncodingUtils.xmlEncode(this.getName(), tmpValue);
                tmpValue.append("\">");
                tmpValue.append(new String(EncodingUtils.base64decode(value, true), "UTF-8"));
                tmpValue.append("</param>");
                this.recordedXML = new XMLRecorderStreamWriter();
                StaxUtils.copyCurrentElement(XMLStreamFactory.createXMLStreamReader(new StringReader(tmpValue.toString())), this.recordedXML);
                this.recordedXML.close();
            }
            catch (Exception e) {
                this.isXML = false;
            }
        }
        this.value = value;
    }

    public boolean isXML() {
        return this.isXML;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        if (this.value == null && this.recordedXML != null) {
            SharedByteArrayOutputStream output = new SharedByteArrayOutputStream(512);
            try {
                StaxUtils.copyChildren(this.recordedXML.toXMLStreamReader(), XMLStreamFactory.createXMLStreamWriter(output));
                this.value = EncodingUtils.base64encode(output.toByteArray(), true);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Cannot reader xml value from xml reader");
            }
        }
        return this.value;
    }

    public XMLStreamReader getValueAsXML() throws XMLStreamException {
        if (this.recordedXML != null) {
            return this.recordedXML.toXMLStreamReader();
        }
        return null;
    }

    @Override
    public void read(XMLStreamReader reader) throws XMLStreamException {
        this.isXML = false;
        this.value = null;
        this.name = null;
        this.recordedXML = null;
        this.setName(reader.getAttributeValue("", "name"));
        StringBuffer buffer = null;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (this.recordedXML == null) {
                        this.recordedXML = XMLStreamFactory.createXMLRecorderStreamWriter();
                        this.recordedXML.writeStartElement("param");
                        if (this.name != null) {
                            this.recordedXML.writeAttribute("name", this.name);
                        }
                        this.isXML = true;
                    }
                    StaxUtils.copyCurrentElement(reader, this.recordedXML);
                    break;
                }
                case 2: {
                    if (this.recordedXML != null) {
                        this.recordedXML.writeEndElement();
                    } else {
                        this.value = buffer != null ? buffer.toString() : "";
                    }
                    return;
                }
                case 4: {
                    if (this.recordedXML != null) break;
                    if (buffer == null) {
                        buffer = new StringBuffer();
                    }
                    buffer.append(reader.getText());
                    break;
                }
            }
        }
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.name != null) {
            xsw.writeAttribute("name", this.name);
        }
        if (this.isXML()) {
            XMLStreamReader reader = this.recordedXML.toXMLStreamReader();
            if (reader.nextTag() == 1) {
                StaxUtils.copyChildren(reader, xsw);
            }
        } else {
            String s = this.getValue();
            if (s != null) {
                xsw.writeCharacters(s);
            }
        }
    }
}

