/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.helpers;

import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.StaxUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLParameters
implements Collection,
IXMLSerializable {
    private List params = new ArrayList();
    private boolean isMerge;
    private boolean isModified;
    private String name;

    public XMLParameters(XMLStreamReader xsr) throws XMLStreamException {
        this.read(xsr);
        this.setNotModified();
    }

    public XMLParameters(String name) {
        this(name, false);
    }

    public XMLParameters(String name, boolean merge) {
        this.isMerge = merge;
        this.name = name;
    }

    public XMLParameter setParameter(String name, String value) {
        Iterator it = this.params.iterator();
        while (it.hasNext()) {
            XMLParameter nvp = (XMLParameter)it.next();
            if (!nvp.getName().equals(name)) continue;
            it.remove();
        }
        return this.addParameter(name, value);
    }

    public XMLParameter addParameter(String name, String value) {
        this.setModified();
        XMLParameter p = new XMLParameter(name, value);
        this.params.add(p);
        return p;
    }

    public boolean remove(String name) {
        this.setModified();
        XMLParameter nvp = this.getXMLParameter(name);
        if (nvp != null) {
            this.params.remove(nvp);
            return true;
        }
        return false;
    }

    public String getValue(String name) {
        XMLParameter nvp = this.getXMLParameter(name);
        if (nvp != null) {
            return nvp.getValue();
        }
        return null;
    }

    public String[] getValues(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (XMLParameter nvp : this.params) {
            if (!nvp.getName().equals(name)) continue;
            values.add(nvp.getValue());
        }
        return values.toArray(new String[values.size()]);
    }

    public XMLParameter getXMLParameter(String name) {
        for (XMLParameter nvp : this.params) {
            if (!nvp.getName().equals(name)) continue;
            return nvp;
        }
        return null;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public void clear() {
        this.setModified();
        this.params.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.params.toArray();
    }

    public boolean add(Object o) {
        this.setModified();
        if (o instanceof XMLParameter) {
            return this.params.add(o);
        }
        if (o instanceof XMLParameters) {
            return this.params.addAll((XMLParameters)o);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof XMLParameter) {
            return this.params.contains(o);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        this.setModified();
        if (o instanceof XMLParameter) {
            return this.remove(((XMLParameter)o).getName());
        }
        return false;
    }

    public boolean addAll(Collection c) {
        this.setModified();
        return this.add(c);
    }

    public boolean containsAll(Collection c) {
        return this.params.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        this.setModified();
        return this.params.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.setModified();
        return this.params.retainAll(c);
    }

    @Override
    public Iterator iterator() {
        return this.params.iterator();
    }

    public Object[] toArray(Object[] a) {
        return this.params.toArray(a);
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(this.name != null ? this.name : "parameters");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            xsw.writeStartElement("param");
            ((XMLParameter)it.next()).write(xsw);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.flush();
    }

    @Override
    public void read(XMLStreamReader xsr) throws XMLStreamException {
        if (!xsr.isStartElement()) {
            StaxUtils.moveToNextElement(xsr);
        }
        this.name = xsr.getLocalName();
        if (!this.isMerge) {
            this.clear();
        }
        int level = 0;
        while (xsr.hasNext()) {
            int event = xsr.next();
            String localName = null;
            switch (event) {
                case 1: {
                    localName = xsr.getLocalName();
                    if ("param".equals(localName)) {
                        XMLParameter object = new XMLParameter(xsr);
                        this.add(object);
                        if (level != 0) break;
                        level = 1;
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level <= 0) {
                        return;
                    }
                    localName = xsr.getLocalName();
                }
            }
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setNotModified() {
        this.isModified = false;
    }

    private void setModified() {
        if (!this.isModified) {
            this.isModified = true;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.params.iterator();
        boolean more = false;
        while (it.hasNext()) {
            XMLParameter nvp = (XMLParameter)it.next();
            String value = nvp.getValue();
            if (more) {
                sb.append('&');
            }
            sb.append(nvp.getName());
            if (nvp.isXML()) {
                sb.append(".xml");
            }
            sb.append('=');
            if (value != null) {
                sb.append(EncodingUtils.urlencode(value, "UTF-8", true));
            }
            more = true;
        }
        return sb.toString();
    }

    public static XMLParameters parse(String params) {
        XMLParameters parameters = new XMLParameters(null, false);
        int i = params.indexOf(38);
        while (i >= 0) {
            String temp = params.substring(0, i);
            XMLParameters.parseNameValue(parameters, temp);
            params = params.substring(i + 1);
            i = params.indexOf(38);
        }
        XMLParameters.parseNameValue(parameters, params);
        return parameters;
    }

    private static void parseNameValue(XMLParameters parameters, String namesValues) {
        int p = namesValues.indexOf(61);
        if (p >= 0) {
            parameters.addParameter(namesValues.substring(0, p), EncodingUtils.urldecode(namesValues.substring(p + 1), "UTF-8"));
        } else {
            parameters.addParameter(namesValues, null);
        }
    }
}

