/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.process.SimpleXMLProcess;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class ContextUpgradeProcess
extends Stage {
    protected static String XML_LANG_NAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    protected static String XML_LANG_NAMESPACEPRFIX = "xml";
    protected static String XML_LANG = "lang";
    private ServiceLogger logger;

    public ContextUpgradeProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(SimpleXMLProcess.class) : null;
    }

    @Override
    public void executeImpl(StageContext context) throws PipelineException {
        String wsrp_context = context.getInteractionParams().getValue("wsrp_portlet_context");
        XMLParameters customParamsWriter = context.getCustomsParams();
        HashMap<String, String> old_properties = new HashMap<String, String>();
        if (wsrp_context != null && wsrp_context.length() > 0 && customParamsWriter != null) {
            block23: {
                block22: {
                    byte[] wsrp_context_decoded = EncodingUtils.base64decode(wsrp_context, true);
                    try {
                        StringReader reader = new StringReader("<context>" + new String(wsrp_context_decoded, "UTF-8") + "</context>");
                        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(reader);
                        int level = 0;
                        int event = xsr.getEventType();
                        while (xsr.hasNext()) {
                            if (event == 1) {
                                String localName = xsr.getLocalName();
                                if ("param".equals(localName)) {
                                    String name = xsr.getAttributeValue("", "name");
                                    String value = xsr.getElementText();
                                    old_properties.put(name, value);
                                }
                                ++level;
                            } else if (event == 2 && --level < 0) break;
                            event = xsr.next();
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if (this.logger != null && this.logger.isErrorEnabled()) {
                            this.logger.error("could not decode the state", e);
                        }
                    }
                    catch (XMLStreamException e) {
                        if (this.logger == null || !this.logger.isErrorEnabled()) break block22;
                        this.logger.error("could not create the xml stream reader", e);
                    }
                }
                String wsrp_state_extension = context.getInteractionParams().getValue("wsrp_portlet_state_extension");
                if (wsrp_state_extension != null) {
                    byte[] wsrp_state_extension_decoded = EncodingUtils.base64decode(wsrp_state_extension, true);
                    try {
                        StringReader reader = new StringReader("<extension>" + new String(wsrp_state_extension_decoded, "UTF-8") + "</extension>");
                        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(reader);
                        int level = 0;
                        int event = xsr.getEventType();
                        while (xsr.hasNext()) {
                            if (event == 1) {
                                String name;
                                String localName = xsr.getLocalName();
                                if ("externalRef".equals(localName) && old_properties.containsKey(name = xsr.getAttributeValue("", "name"))) {
                                    String value = xsr.getElementText();
                                    old_properties.put(name, value);
                                }
                                ++level;
                            } else if (event == 2 && --level < 0) break;
                            event = xsr.next();
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if (this.logger != null && this.logger.isErrorEnabled()) {
                            this.logger.error("could not decode the state", e);
                        }
                    }
                    catch (XMLStreamException e) {
                        if (this.logger == null || !this.logger.isErrorEnabled()) break block23;
                        this.logger.error("could not create the xml stream reader", e);
                    }
                }
            }
            this.upgrade(old_properties, customParamsWriter);
            context.getInteractionParams().addAll((Collection)customParamsWriter);
            customParamsWriter.setNotModified();
        }
    }

    protected abstract void upgrade(Map var1, XMLParameters var2) throws PipelineException;

    @Override
    public boolean canShare() {
        return true;
    }
}

