/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.XSLTFactory;
import com.cognos.portal.fragment.producer.process.XSLTStageProcess;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.fragments.Css;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Library;
import com.cognos.portal.schemas.fragments.Markup;
import com.cognos.portal.schemas.fragments.MarkupValidator;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jd.xml.xslt.Transformation;
import jd.xml.xslt.TransformationChain;
import jd.xml.xslt.format.OutputFormat;

public class DefaultRenderProcess
extends XSLTStageProcess {
    private static final String DEFAULT_MODE = "view";
    private static final String MODE_CONTROLLER_PARAM = "frag-mode";
    private static final String VIEW_CONTROLLER_PARAM = "frag-view";
    private ServiceLogger logger;
    private Map modes;
    private String defaultMode;

    public DefaultRenderProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(DefaultRenderProcess.class) : null;
    }

    @Override
    public void initialize(Map inputs) throws PipelineException {
        this.modes = new HashMap();
        try {
            XMLStreamReader xsr = (XMLStreamReader)inputs.get("render.config");
            if (xsr != null) {
                int event = xsr.next();
                while (event != 8 && xsr.hasNext()) {
                    switch (event) {
                        case 1: {
                            Mode mode;
                            if (!"mode".equals(xsr.getLocalName())) break;
                            String modeString = xsr.getAttributeValue("", "name");
                            if (modeString == null || modeString.length() == 0) {
                                modeString = DEFAULT_MODE;
                            }
                            if ((mode = (Mode)this.modes.get(modeString)) == null) {
                                mode = new Mode();
                                String separator = modeString.indexOf(",") == -1 ? " " : ",";
                                StringTokenizer tokens = new StringTokenizer(modeString, separator);
                                modeString = null;
                                while (tokens.hasMoreTokens()) {
                                    String token = tokens.nextToken().trim();
                                    if (modeString == null) {
                                        modeString = token;
                                    }
                                    this.modes.put(token, mode);
                                }
                            }
                            if (this.defaultMode == null || modeString.equals(DEFAULT_MODE)) {
                                this.defaultMode = modeString;
                            }
                            this.readViews(mode, xsr);
                        }
                    }
                    event = xsr.next();
                }
                xsr.close();
            }
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Could not initialize process '" + this.getName() + "'", e);
            }
            throw new PipelineException("Could not initialize process '" + this.getName() + "'");
        }
    }

    private void readViews(Mode mode, XMLStreamReader xsr) throws XMLStreamException, PipelineException {
        int level = 0;
        int event = xsr.next();
        while (event != 8 && xsr.hasNext()) {
            switch (event) {
                case 1: {
                    if ("library".equals(xsr.getLocalName())) {
                        Library library = new Library();
                        library.read(xsr);
                        mode.addLibrary(library);
                        break;
                    }
                    if ("css".equals(xsr.getLocalName())) {
                        Css style = new Css();
                        style.read(xsr);
                        mode.addStyle(style);
                        break;
                    }
                    if ("transforms".equals(xsr.getLocalName())) {
                        String view = xsr.getAttributeValue("", DEFAULT_MODE);
                        this.readTransforms(mode, view, xsr);
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return;
                }
            }
            event = xsr.next();
        }
    }

    private void readTransforms(Mode mode, String view, XMLStreamReader xsr) throws XMLStreamException, PipelineException {
        int level = 0;
        Transform transform = null;
        int event = xsr.next();
        while (event != 8 && xsr.hasNext()) {
            switch (event) {
                case 1: {
                    String localName = xsr.getLocalName();
                    if ("transform".equals(localName)) {
                        String transform_source = xsr.getAttributeValue("", "source");
                        transform = new Transform(transform_source);
                        mode.addTransform(view, transform);
                    } else if ("logicsheet".equals(localName)) {
                        if (transform != null) {
                            String logicsheet_source = xsr.getAttributeValue("", "source");
                            transform.addLogicsheet(logicsheet_source);
                        }
                    } else if ("validate".equals(localName)) {
                        mode.addValidator(view, xsr);
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if ("transform".equals(xsr.getLocalName())) {
                        transform = null;
                    }
                    if (--level >= 0) break;
                    return;
                }
            }
            event = xsr.next();
        }
    }

    private Mode getMode(String modeName) {
        Mode mode = null;
        if (modeName != null) {
            mode = (Mode)this.modes.get(modeName);
        }
        if (mode == null) {
            mode = (Mode)this.modes.get(this.defaultMode);
        }
        return mode;
    }

    @Override
    protected Transformation getTransformation(StageContext context) throws PipelineException, LocalizableException {
        Fragment fragment;
        Parameters params = (Parameters)this.getRequiredParam("controllerParams", context);
        Mode mode = this.getMode(params, fragment = (Fragment)this.getRequiredParam("fragment", context));
        if (mode != null) {
            View view;
            List modeStyles;
            List modeScripts = mode.libraries;
            if (modeScripts != null) {
                Iterator it = modeScripts.iterator();
                while (it.hasNext()) {
                    fragment.addLibrary((Library)it.next());
                }
            }
            if ((modeStyles = mode.styles) != null) {
                Iterator it = modeStyles.iterator();
                while (it.hasNext()) {
                    fragment.addCss((Css)it.next());
                }
            }
            if ((view = this.getView(params, fragment, mode)) != null) {
                String messageFile = context.getMessageFile();
                String productLocal = context.getEnv().getProductLocale();
                Environment env = context.getEnv();
                if (view.transforms.size() == 1) {
                    String transform = ((Transform)view.transforms.get((int)0)).transform;
                    List logicsheets = ((Transform)view.transforms.get((int)0)).logicsheets;
                    return XSLTFactory.getInstance().getStylesheet(transform, logicsheets, messageFile, productLocal, env);
                }
                if (view.transforms.size() > 1) {
                    TransformationChain chain = new TransformationChain();
                    for (int i = 0; i < view.transforms.size(); ++i) {
                        String uri = ((Transform)view.transforms.get((int)i)).transform;
                        List logicsheets = ((Transform)view.transforms.get((int)0)).logicsheets;
                        chain.addTransformation((Transformation)XSLTFactory.getInstance().getStylesheet(uri, logicsheets, messageFile, productLocal, env));
                    }
                    return chain;
                }
            }
        }
        return null;
    }

    @Override
    protected void handleResult(StageContext context, IPipelineOutput output, OutputFormat format) throws PipelineException, XMLStreamException {
        Parameters params = (Parameters)this.getRequiredParam("controllerParams", context);
        Fragment fragment = (Fragment)this.getRequiredParam("fragment", context);
        if (format != null) {
            String method = format.getMethod();
            if ("html".equals(method) || "text".equals(method)) {
                this.setMarkup(output.toReader(), this.getMarkup(fragment));
                this.addViewValidator(params, fragment);
                return;
            }
            String doctype = format.getDocTypePublic();
            if ("-//W3C//DTD XHTML 1.0 Transitional//EN".equals(doctype)) {
                this.setMarkup(output.toReader(), this.getMarkup(fragment));
                this.addViewValidator(params, fragment);
                return;
            }
        }
        super.handleResult(context, output, format);
        this.addViewValidator(params, fragment);
    }

    private View getView(Parameters params, Fragment fragment, Mode mode) {
        String viewName = params.getValue(VIEW_CONTROLLER_PARAM);
        if (fragment.getNewView() != null) {
            viewName = fragment.getNewView();
        }
        return mode.getView(viewName);
    }

    private Mode getMode(Parameters params, Fragment fragment) {
        String modeName = params.getValue(MODE_CONTROLLER_PARAM);
        if (fragment.getNewMode() != null) {
            modeName = fragment.getNewMode().getLocalPart();
        }
        return this.getMode(modeName);
    }

    private void addViewValidator(Parameters params, Fragment fragment) {
        View view;
        Mode mode = this.getMode(params, fragment);
        if (mode != null && (view = this.getView(params, fragment, mode)) != null && view.markupValidate != null) {
            this.getMarkup(fragment).setValidator(view.markupValidate);
        }
    }

    private Markup getMarkup(Fragment fragment) {
        Markup markup;
        if (fragment.getMarkupCount() > 0) {
            markup = fragment.getMarkup(0);
        } else {
            markup = new Markup();
            fragment.addMarkup(markup);
        }
        return markup;
    }

    private void setMarkup(Reader reader, Markup markup) throws PipelineException {
        char[] buffer = new char[1024];
        StringBuffer sb = new StringBuffer();
        try {
            int read;
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
            markup.setMarkupString(sb.toString());
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("error while reading markup reader", e);
            }
            throw new PipelineException("pf.fragment.producer.executionfailed");
        }
    }

    @Override
    public boolean canShare() {
        return false;
    }

    class Mode {
        String defaultView;
        Map views = new HashMap();
        List libraries;
        List styles;

        Mode() {
        }

        public void addTransform(String viewName, Transform transform) {
            View view;
            if (viewName == null) {
                viewName = "";
            }
            if (this.defaultView == null) {
                this.defaultView = viewName;
            }
            if ((view = (View)this.views.get(viewName)) == null) {
                view = new View();
                this.views.put(viewName, view);
            }
            view.transforms.add(transform);
        }

        public void addValidator(String viewName, XMLStreamReader xsr) throws XMLStreamException, PipelineException {
            View view;
            if (viewName == null) {
                viewName = "";
            }
            if (this.defaultView == null) {
                this.defaultView = viewName;
            }
            if ((view = (View)this.views.get(viewName)) == null) {
                view = new View();
                this.views.put(viewName, view);
            }
            view.markupValidate = new MarkupValidator();
            view.markupValidate.read(xsr);
        }

        public View getView(String viewName) {
            View result = (View)this.views.get(viewName);
            if (result == null) {
                result = (View)this.views.get(this.defaultView);
            }
            return result;
        }

        public void addLibrary(Library library) {
            if (this.libraries == null) {
                this.libraries = new ArrayList();
            }
            this.libraries.add(library);
        }

        public void addStyle(Css style) {
            if (this.styles == null) {
                this.styles = new ArrayList();
            }
            this.styles.add(style);
        }
    }

    class View {
        List transforms = new ArrayList();
        MarkupValidator markupValidate;
    }

    class Transform {
        public String transform;
        public List logicsheets;

        public Transform(String transform) {
            this.transform = transform;
            this.logicsheets = new ArrayList();
        }

        public void addLogicsheet(String logicsheet) {
            this.logicsheets.add(logicsheet);
        }
    }
}

