/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.fragments.Binary;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Param;
import com.cognos.portal.schemas.fragments.Params;
import com.cognos.portal.utils.CCLLocaleUtils;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class FragmentXMLProcess
extends Stage {
    private static String XML_LANG_NAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    private static String XML_LANG = "lang";
    private ServiceLogger logger;

    public FragmentXMLProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(FragmentXMLProcess.class) : null;
    }

    @Override
    protected void executeImpl(StageContext context) throws PipelineException {
        try {
            XMLParameters customsUpdate;
            Fragment fragment = context.getFragment();
            XMLParameters state = context.getStateParams();
            if (state != null && state.isModified()) {
                StringWriter stringWriter = new StringWriter();
                state.write(XMLStreamFactory.createXMLStreamWriter(stringWriter));
                stringWriter.close();
                Binary binary = new Binary();
                binary.setValue(EncodingUtils.compress(stringWriter.getBuffer().toString().getBytes("UTF-8")));
                fragment.setState(binary);
            }
            if ((customsUpdate = context.getCustomsParams()) != null && customsUpdate.isModified()) {
                Params params = fragment.getCustomUpdate();
                if (params == null) {
                    params = new Params();
                    fragment.setCustomUpdate(params);
                }
                Iterator it = customsUpdate.iterator();
                while (it.hasNext()) {
                    params.addParam((Param)it.next());
                }
            }
            if (fragment.getPreferredTitle() == null) {
                fragment.setPreferredTitle(this.getPreferredTitle(customsUpdate, context));
            }
            IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
            XMLStreamWriter fragmentXML = output.getXMLStreamWriter();
            fragment.write(fragmentXML);
            context.addOutput("fragmentXML", output);
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not build markup", e);
            }
            throw new PipelineException("error building markup", e);
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not read html markup", e);
            }
            throw new PipelineException("error reading html markup", e);
        }
    }

    private String getPreferredTitle(XMLParameters customs, StageContext context) throws XMLStreamException {
        String preferredTitle = null;
        XMLParameter p = customs.getXMLParameter("title");
        if (p != null && p.getValue().length() > 0) {
            if (p.isXML()) {
                XMLStreamReader titleReader = p.getValueAsXML();
                HashMap<String, String> titles = new HashMap<String, String>();
                while (titleReader.hasNext()) {
                    String value;
                    String xmlLang;
                    titleReader.next();
                    if (!titleReader.isStartElement() || !"value".equals(titleReader.getLocalName()) || (xmlLang = titleReader.getAttributeValue(XML_LANG_NAMESPACEURI, XML_LANG)) == null || xmlLang.length() <= 0 || (value = titleReader.getElementText()) == null || value.length() <= 0) continue;
                    titles.put(xmlLang, value);
                }
                String contentLocale = context.getEnv().getContentLocale();
                preferredTitle = (String)titles.get(contentLocale);
                if (preferredTitle == null) {
                    String sKeys = titles.keySet().toString();
                    String localeList = sKeys.substring(1, sKeys.length() - 1);
                    String bestFitLocale = CCLLocaleUtils.getBestFitLocale(contentLocale, localeList);
                    preferredTitle = (String)titles.get(bestFitLocale);
                }
            } else {
                preferredTitle = p.getValue();
            }
        }
        return preferredTitle;
    }

    @Override
    public boolean canShare() {
        return true;
    }

    class UpdateStreamFilter
    implements StreamFilter {
        boolean hasPreferredTitle;

        UpdateStreamFilter() {
        }

        @Override
        public boolean accept(XMLStreamReader reader) {
            if (reader.isStartElement() && "preferredTitle".equals(reader.getLocalName())) {
                this.hasPreferredTitle = true;
            }
            return true;
        }

        boolean hasPreferredTitle() {
            return this.hasPreferredTitle;
        }
    }
}

