/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.StaxUtils;
import java.util.Enumeration;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SimpleXMLProcess
extends Stage {
    private ServiceLogger logger;

    public SimpleXMLProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(SimpleXMLProcess.class) : null;
    }

    @Override
    public void executeImpl(StageContext context) throws PipelineException {
        Enumeration outputNames = context.getOutputNamesEnumeration();
        String outputName = null;
        if (outputNames.hasMoreElements()) {
            outputName = (String)outputNames.nextElement();
        }
        if (outputName != null) {
            try {
                IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
                XMLStreamWriter xsw = output.getXMLStreamWriter();
                xsw.writeStartElement(outputName);
                Enumeration enumeration = context.getInputNamesEnumeration();
                while (enumeration.hasMoreElements()) {
                    String inputName = (String)enumeration.nextElement();
                    XMLStreamReader xsr = context.getInputAsXMLStreamReader(inputName);
                    if (xsr == null) continue;
                    StaxUtils.copyCurrentElement(xsr, xsw);
                    xsr.close();
                }
                xsw.writeEndElement();
                xsw.flush();
                xsw.close();
                context.addOutput(outputName, output);
            }
            catch (XMLStreamException e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("Process '" + this.getName() + "' failed to execute", e);
                }
                throw new PipelineException("could not read inputs", e);
            }
        }
    }

    @Override
    public boolean canShare() {
        return true;
    }
}

