/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.process.XTSProcess;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaticFragmentReader
extends Stage {
    private ServiceLogger logger;

    public StaticFragmentReader(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(XTSProcess.class) : null;
    }

    @Override
    protected void executeImpl(StageContext context) throws PipelineException {
        block8: {
            String path = context.getExtraInfo();
            try {
                if (!path.endsWith(".xml")) {
                    path = path + ".xml";
                }
                Fragment fragment = context.getFragment();
                XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(context.getEnv().getTargetStream(path, null));
                if (xsr.nextTag() != 1) break block8;
                if ("fragment".equals(xsr.getLocalName())) {
                    fragment.read(xsr);
                    break block8;
                }
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("invalid xml for '" + path + "': '" + xsr.getLocalName() + "'.");
                }
                throw new PipelineException("pf.pipeline.process.error", new String[]{this.getName()});
            }
            catch (DashboardException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Cannot read '" + path + "'", e);
                }
                throw new PipelineException("pf.pipeline.process.error", new String[]{this.getName()});
            }
            catch (XMLStreamException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("xml exception while reading  '" + path + "'", e);
                }
                throw new PipelineException("pf.pipeline.process.error", new String[]{this.getName()});
            }
        }
    }

    @Override
    public boolean canShare() {
        return true;
    }
}

