/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.XSLTFactory;
import com.cognos.portal.fragment.producer.FragmentUtils;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.pipeline.utils.XMLPipeInputSource;
import com.cognos.portal.xml.pipeline.utils.XMLPipeParser;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Transformation;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.format.OutputFormat;
import org.xml.sax.InputSource;

public class XSLTProcess
extends Stage {
    private ServiceLogger logger;

    public XSLTProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(XSLTProcess.class) : null;
    }

    protected void handleResult(StageContext context, IPipelineOutput output, OutputFormat format) throws PipelineException, XMLStreamException {
        Enumeration enumeration = context.getOutputNamesEnumeration();
        if (enumeration.hasMoreElements()) {
            String outputName = (String)enumeration.nextElement();
            context.addOutput(outputName, output);
        }
    }

    @Override
    public void initialize(Map inputs) throws PipelineException {
    }

    protected Transformation getTransformation(StageContext context) throws LocalizableException {
        String logicSheetsParam = (String)context.getParam("logicsheets");
        ArrayList<String> logicSheets = null;
        if (logicSheetsParam != null && logicSheetsParam.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(logicSheetsParam, ",");
            logicSheets = new ArrayList<String>(tokens.countTokens());
            while (tokens.hasMoreTokens()) {
                logicSheets.add(tokens.nextToken());
            }
        }
        return XSLTFactory.getInstance().getStylesheet((String)this.getRequiredParam("stylesheet", context), logicSheets, context.getMessageFile(), context.getEnv().getProductLocale(), context.getEnv());
    }

    @Override
    public void executeImpl(StageContext context) throws PipelineException {
        try {
            Transformation stylesheet = this.getTransformation(context);
            XMLRecorderStreamWriter xsw = XMLStreamFactory.createXMLRecorderStreamWriter();
            FragmentUtils.createInputDocument(context, xsw);
            XMLStreamReader input = xsw.toXMLStreamReader();
            if (context.isDebugMode()) {
                context.addTraceXML("xslt_input_document", xsw.toXMLStreamReader());
            }
            if (input != null) {
                IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
                Writer writer = output.getWriter();
                XMLPipeInputSource inputSource = new XMLPipeInputSource(input);
                XmlSource source = new XmlSource((InputSource)inputSource);
                source.setParser((Object)new XMLPipeParser());
                XsltResult result = new XsltResult("", writer, false);
                stylesheet.transform(source, result);
                writer.close();
                input.close();
                this.handleResult(context, output, stylesheet.getOutputFormat());
            }
        }
        catch (Exception e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Process '" + this.getName() + "' failed to execute", e);
            }
            throw new PipelineException("Process '" + this.getName() + "' failed to execute", e);
        }
    }

    @Override
    public boolean canShare() {
        return true;
    }
}

