/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.Constants;
import com.cognos.portal.fragment.producer.FragmentUtils;
import com.cognos.portal.fragment.producer.process.XSLTProcess;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.StaxUtils;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import jd.xml.xslt.format.OutputFormat;

public class XSLTStageProcess
extends XSLTProcess {
    public XSLTStageProcess(ServiceLogger logger) {
        super(logger);
    }

    @Override
    protected void handleResult(StageContext context, IPipelineOutput output, OutputFormat format) throws PipelineException, XMLStreamException {
        XMLStreamReader xsr = output.toXMLStreamReader();
        if (StaxUtils.moveToChildElement("response", xsr)) {
            String _name = null;
            while (xsr.hasNext()) {
                int event = xsr.next();
                if (event != 1) continue;
                _name = xsr.getLocalName();
                Object param = context.getParam(_name);
                if (param != null && param instanceof IXMLSerializable && !Constants.FRAGMENT_READ_ONLY_PARAMS.contains(this.getName())) {
                    ((IXMLSerializable)param).read(xsr);
                    continue;
                }
                if (context.canOutput(_name)) {
                    IPipelineOutput newOutput = PipelineOutputFactory.getInstance().createOutput();
                    if ("render".equals(_name)) {
                        FragmentUtils.xmlToHtml(xsr, newOutput.getWriter());
                    } else {
                        XMLStreamWriter xsw = newOutput.getXMLStreamWriter();
                        if (Constants.FRAGMENT_PASS_THROUGH_INPUTS.contains(_name)) {
                            XMLStreamReader previousInput = context.getInputAsXMLStreamReader(_name);
                            if (previousInput != null) {
                                FragmentUtils.mergeInput(xsr, previousInput, xsw);
                            } else {
                                StaxUtils.copyCurrentElement(xsr, xsw);
                            }
                        } else {
                            StaxUtils.copyCurrentElement(xsr, xsw);
                        }
                        xsw.flush();
                        xsw.close();
                    }
                    context.addOutput(_name, newOutput);
                    continue;
                }
                StaxUtils.moveToNextSibling(xsr);
            }
        }
        xsr.close();
    }
}

