/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.Constants;
import com.cognos.portal.fragment.producer.FragmentUtils;
import com.cognos.portal.fragment.producer.bseries.xts.XTSProcessorWrapper;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.output.XTSConstants;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XTSProcess
extends Stage {
    private ServiceLogger logger;

    public XTSProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(XTSProcess.class) : null;
    }

    @Override
    protected void executeImpl(StageContext context) throws PipelineException {
        try {
            List responseElements;
            Element partElem;
            Element entityBodyElem;
            Element response;
            List partElemList;
            String morphlet = (String)this.getRequiredParam("m", context);
            Document input = this.createInputDocument(context);
            if (context.isDebugMode()) {
                context.addTraceXML("xts_input", this.elementToReader(input.getRootElement()));
            }
            ((XTSProcessorWrapper)context.getEnv().getProperty("xts")).invokeNoResultProcess(morphlet, input, context.getEnv());
            Element outputElement = input.getRootElement().element("output");
            if (context.isDebugMode()) {
                context.addTraceXML("xts_output", this.elementToReader(outputElement));
            }
            if ((partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART)).size() > 0 && (response = (entityBodyElem = (partElem = (Element)partElemList.get(0)).element(XTSConstants.ELEM_NM_ENTITYBODY)).element("response")) != null && (responseElements = response.elements()) != null) {
                for (Element elem : responseElements) {
                    String name = elem.getName();
                    Object param = context.getParam(name);
                    if (param != null && param instanceof IXMLSerializable && !Constants.FRAGMENT_READ_ONLY_PARAMS.contains(name)) {
                        this.elementToXML(elem, (IXMLSerializable)param);
                        continue;
                    }
                    if (!context.canOutput(name)) continue;
                    IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
                    XMLStreamReader xsr = this.elementToReader(elem);
                    if ("render".equals(name)) {
                        FragmentUtils.xmlToHtml(xsr, output.getWriter());
                    } else {
                        XMLStreamWriter xsw = output.getXMLStreamWriter();
                        if (Constants.FRAGMENT_PASS_THROUGH_INPUTS.contains(name)) {
                            XMLStreamReader previousInput = context.getInputAsXMLStreamReader(name);
                            if (previousInput != null) {
                                FragmentUtils.mergeInput(xsr, previousInput, xsw);
                            } else {
                                StaxUtils.copyCurrentElement(xsr, xsw);
                            }
                        } else {
                            StaxUtils.copyCurrentElement(xsr, xsw);
                        }
                        xsw.close();
                    }
                    xsr.close();
                    context.addOutput(name, output);
                }
            }
        }
        catch (XMLStreamException e1) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not write element to xml param", e1);
            }
            throw new PipelineException("exception while writing element to xml param", e1);
        }
    }

    private void elementToXML(Element e, IXMLSerializable object) throws XMLStreamException {
        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(e.asXML()));
        xsr.nextTag();
        object.read(xsr);
    }

    private XMLStreamReader elementToReader(Element e) throws PipelineException {
        try {
            return XMLStreamFactory.createXMLStreamReader(new StringReader(e.asXML()));
        }
        catch (XMLStreamException e1) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not write element to xml output stream", e1);
            }
            throw new PipelineException("exception while writing element to xml output stream", e1);
        }
    }

    private Document createInputDocument(StageContext context) throws PipelineException {
        try {
            SAXReader reader = new SAXReader();
            StringWriter stringWriter = new StringWriter();
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter(stringWriter);
            FragmentUtils.createInputDocument(context, xsw);
            Document rootDoc = reader.read((Reader)new StringReader(stringWriter.getBuffer().toString()));
            rootDoc.getRootElement().addElement("output");
            return rootDoc;
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an XML stream exception was encountered when trying to create the input document", e);
            }
            throw new PipelineException("cannot create input document", e);
        }
        catch (DocumentException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an document exception was encountered when trying to create the input document", e);
            }
            throw new PipelineException("cannot create input document", e);
        }
    }

    @Override
    public boolean canShare() {
        return true;
    }
}

