/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process.common;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.fragment.server.pipeline.helper.NavHelper;
import com.cognos.portal.schemas.fragments.Default;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Meta;
import com.cognos.portal.schemas.fragments.Properties;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.AddRuntimeState;
import com.cognos.portal.utils.Cache;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.XMLString;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.XTSException;
import com.cognos.xts.util.TDSStorageHelper;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class BackwardCompatibiltySupport
extends Stage {
    private static final String[] STATE_PATH = new String[]{"/queryResponse/queryResult/item/defaultName/value", "/queryResponse/queryResult/item/state"};
    private ServiceLogger logger;
    private String channelProperty;
    private List sharedProperties;
    private Cache registrationHandles;
    private List navIds;

    public BackwardCompatibiltySupport(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(BackwardCompatibiltySupport.class) : null;
        this.registrationHandles = new Cache(3600L, 86400L, 0);
    }

    @Override
    public void initialize(Map inputs) throws PipelineException {
        try {
            XMLStreamReader xsr = (XMLStreamReader)inputs.get("config");
            if (xsr != null) {
                boolean collectSharedParams = false;
                boolean collectNavIdsParams = false;
                while (xsr.hasNext()) {
                    String localName;
                    xsr.next();
                    if (xsr.isStartElement()) {
                        localName = xsr.getLocalName();
                        if ("channelParameter".equals(localName)) {
                            this.channelProperty = xsr.getElementText();
                            continue;
                        }
                        if ("sharedParameters".equals(localName)) {
                            this.sharedProperties = new ArrayList();
                            collectSharedParams = true;
                            continue;
                        }
                        if (collectSharedParams && "parameter".equals(localName)) {
                            SharedParameter sp = new SharedParameter();
                            String saveToCM = xsr.getAttributeValue("", "saveToCM");
                            sp.name = xsr.getElementText();
                            sp.saveToCM = "true".equalsIgnoreCase(saveToCM);
                            this.sharedProperties.add(sp);
                            continue;
                        }
                        if ("navIdsParameters".equals(localName)) {
                            this.navIds = new ArrayList();
                            collectNavIdsParams = true;
                            continue;
                        }
                        if (!collectNavIdsParams || !"parameter".equals(localName)) continue;
                        NavIdParameter nip = new NavIdParameter();
                        String type = xsr.getAttributeValue("", "type");
                        if (type != null) {
                            if ("interaction".equals(type)) {
                                nip.type = 0;
                            } else if ("transient".equals(type)) {
                                nip.type = 1;
                            } else if ("custom".equals(type)) {
                                nip.type = 2;
                            }
                        } else {
                            nip.type = 0;
                        }
                        nip.name = xsr.getElementText();
                        this.navIds.add(nip);
                        continue;
                    }
                    if (!xsr.isEndElement()) continue;
                    localName = xsr.getLocalName();
                    if ("sharedParameters".equals(localName)) {
                        collectSharedParams = false;
                        continue;
                    }
                    if (!"navIdsParameters".equals(localName)) continue;
                    collectSharedParams = false;
                }
            }
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Could not initialize process '" + this.getName() + "'", e);
            }
            throw new PipelineException("Could not initialize process '" + this.getName() + "'");
        }
    }

    @Override
    protected void executeImpl(StageContext context) throws PipelineException {
        this.HandleTransients(context);
        this.convertNavIdsToStoreIds(context);
    }

    private void HandleTransients(StageContext context) throws PipelineException {
        String registrationHandle;
        String extraInfo;
        XMLParameters customs = context.getCustomsParams();
        XMLParameters interactions = context.getInteractionParams();
        Parameters controllerParams = context.getControllerParams();
        String channel = this.getChannel(customs, interactions, controllerParams);
        String transientUpdate = null;
        String transientUpdateValue = null;
        if (interactions != null && (transientUpdate = interactions.getValue("sessionTransient")) != null && transientUpdate.length() > 0) {
            XMLParameters transients;
            Fragment fragment;
            transientUpdateValue = interactions.getValue("transientValue");
            if (transientUpdateValue == null) {
                transientUpdateValue = "";
            }
            if ((fragment = context.getFragment()) != null) {
                Fragment.TransientUpdate tu = new Fragment.TransientUpdate(fragment);
                tu.setChannel(channel);
                tu.setName(transientUpdate);
                tu.setValue(transientUpdateValue);
                tu.setScope("application");
                fragment.addTransientUpdate(tu);
            }
            if ((transients = context.getTransientParams()) != null) {
                transients.setParameter(transientUpdate, transientUpdateValue);
            }
        }
        if ((extraInfo = context.getExtraInfo()) != null && extraInfo.length() > 0 && this.sharedProperties != null && (registrationHandle = this.getRegistragtionHandle(extraInfo, context)) != null) {
            XMLParameters transients = context.getTransientParams();
            if (transients != null && !channel.equals(controllerParams.getValue("frag-channel"))) {
                for (SharedParameter prop : this.sharedProperties) {
                    if (!prop.saveToCM) continue;
                    transients.remove(prop.name);
                }
            }
            if (channel.length() > 0) {
                if (transientUpdate != null) {
                    this.saveTransientToSession(transientUpdate, transientUpdateValue, registrationHandle, channel, context);
                }
                this.loadTransientPropertiesFromCM(registrationHandle, channel, context);
            }
        }
    }

    private String getChannel(XMLParameters customs, XMLParameters interactions, Parameters controllerParams) {
        String channel = null;
        if (controllerParams != null && interactions != null && "edit".equals(controllerParams.getValue("frag-mode")) && "save".equals(interactions.getValue("formaction"))) {
            channel = interactions.getValue("p_" + this.channelProperty);
        }
        if (channel == null && customs != null) {
            channel = customs.getValue(this.channelProperty);
        }
        if (channel == null) {
            channel = "";
        }
        return channel;
    }

    private void loadTransientPropertiesFromCM(String registrationHandle, String channel, StageContext stageContext) throws PipelineException {
        XMLParameters transients = stageContext.getTransientParams();
        Meta meta = stageContext.getFragment().getMeta();
        int transientCount = meta.getTransientPropertiesCount();
        if (this.sharedProperties.size() > 0 && transients != null) {
            String keyPrefix = registrationHandle + ":" + channel + "#";
            try {
                for (SharedParameter prop : this.sharedProperties) {
                    String kname = keyPrefix + prop.name;
                    List l = TDSStorageHelper.instance.getMappedValueList(stageContext.getEnv().getPassportID(), "portlets", kname, "starts-with");
                    for (int j = 0; j < l.size(); ++j) {
                        TDSStorageHelper.NameValue nv = (TDSStorageHelper.NameValue)l.get(j);
                        String name = nv.name;
                        String value = nv.value;
                        if (name == null) continue;
                        if (name.startsWith(keyPrefix)) {
                            name = name.substring(keyPrefix.length());
                        }
                        transients.setParameter(name, value);
                        for (int i = 0; i < transientCount; ++i) {
                            Properties p = meta.getTransientProperties(i);
                            if (!name.equals(p.getName())) continue;
                            Default _default = p.getDefault();
                            if (_default == null) {
                                _default = new Default();
                                p.setDefault(_default);
                            }
                            _default.setValue(value);
                        }
                    }
                }
            }
            catch (XTSException e) {
                throw new PipelineException("TDS error", e);
            }
        }
    }

    private void saveTransientToSession(String transientUpdate, String value, String registrationHandle, String channel, StageContext context) throws PipelineException {
        AddRuntimeState addRuntimeState = new AddRuntimeState();
        XMLString header = context.getBusHeader();
        addRuntimeState.addState(registrationHandle + ":" + channel + "#" + transientUpdate, value);
        try {
            addRuntimeState.saveToDataStorage(context.getEnv().getPassportID());
        }
        catch (XTSException e) {
            throw new PipelineException("TDS error", e);
        }
    }

    private String getRegistragtionHandle(String extraInfo, StageContext stageContext) throws PipelineException {
        String registration = this.extractParamFromExtraInfo("/reg/", extraInfo);
        if (registration != null) {
            return registration;
        }
        String producerId = this.extractParamFromExtraInfo("/prod/", extraInfo);
        if (producerId != null) {
            if (this.registrationHandles.containsKey(producerId)) {
                return (String)this.registrationHandles.get(producerId);
            }
            String registrationHandle = this.getRegistrationHandleFromCM(producerId, stageContext);
            if (registrationHandle.length() > 0) {
                this.registrationHandles.put(producerId, registrationHandle);
                return registrationHandle;
            }
        }
        return null;
    }

    private String getRegistrationHandleFromCM(final String producerId, StageContext stageContext) throws PipelineException {
        Query query = new Query();
        query.setSearchPath("storeID(\"" + producerId + "\")");
        query.addProperty("registration");
        XMLString header = stageContext.getBusHeader();
        query.setBusHeader(header != null ? ((Object)header).toString() : null);
        final StringBuffer registrationHandle = new StringBuffer();
        query.setResponseBodyHandler(new IXMLHandler(){

            @Override
            public void handle(XMLStreamReader reader) throws XMLStreamException {
                while (reader.hasNext()) {
                    int event = reader.next();
                    if (event != 1 || !"registration".equals(reader.getLocalName()) || reader.nextTag() != 1 || !"value".equals(reader.getLocalName())) continue;
                    String registration = reader.getElementText();
                    if (registration.length() > 0) {
                        XMLStreamReader registrationReader = XMLStreamFactory.createXMLStreamReader(new StringReader(registration));
                        if (StaxUtils.moveToElement("registrationHandle", registrationReader)) {
                            registrationHandle.append(registrationReader.getElementText());
                        }
                    } else if (BackwardCompatibiltySupport.this.logger.isDebugEnabled()) {
                        BackwardCompatibiltySupport.this.logger.debug("could not fing registration for producer with id : " + producerId);
                    }
                    return;
                }
            }
        });
        this.sendCMRequest(query, stageContext);
        return registrationHandle.toString();
    }

    private String extractParamFromExtraInfo(String marker, String extraInfo) {
        int markerIndex = extraInfo.indexOf(marker);
        if (markerIndex != -1) {
            String value = extraInfo.substring(markerIndex + marker.length());
            int slashIndex = value.indexOf(47);
            if (slashIndex != -1) {
                value = value.substring(0, slashIndex);
            }
            return value;
        }
        return null;
    }

    private void sendCMRequest(SOAPMessage message, StageContext stageContext) throws PipelineException {
        SOAPConnection connection = ((SOAPConnectionFactory)stageContext.getEnv().getProperty("SoapConnectionFactory")).createConnection(this.logger);
        try {
            connection.execute(message, (String)stageContext.getEnv().getProperty("contentManager"));
        }
        catch (MalformedURLException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("bad url.", e);
            }
            throw new PipelineException("pf.pipeline.process.error", new String[]{this.getName()}, e);
        }
        catch (SOAPFault e) {
            String detail = e.getDetail();
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1) {
                throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, null);
            }
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Content Manager returned a fault in the response.", e);
            }
            throw new PipelineException("pf.pipeline.process.error", new String[]{this.getName()}, e);
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an IO exception while retrieving the object from cm.", e);
            }
            throw new PipelineException("pf.pipeline.process.io.error", new String[]{this.getName()}, e);
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an xml stream exception while retrieving the object from cm.", e);
            }
            throw new PipelineException("pf.pipeline.process.xml.error", new String[]{this.getName()}, e);
        }
    }

    private void convertNavIdsToStoreIds(StageContext context) {
        if (this.navIds != null) {
            XMLParameters interactions = context.getInteractionParams();
            XMLParameters transients = context.getTransientParams();
            XMLParameters customs = context.getCustomsParams();
            for (NavIdParameter nip : this.navIds) {
                switch (nip.type) {
                    case 0: {
                        this.updateNavId(interactions, nip);
                        break;
                    }
                    case 1: {
                        this.updateNavId(transients, nip);
                        break;
                    }
                    case 2: {
                        this.updateNavId(customs, nip);
                    }
                }
            }
        }
    }

    private void updateNavId(XMLParameters parameters, NavIdParameter nip) {
        String[] values;
        if (parameters != null && (values = parameters.getValues(nip.name)).length > 0) {
            parameters.remove(nip.name);
            for (int i = 0; i < values.length; ++i) {
                parameters.addParameter(nip.name, NavHelper.getStoreId(values[i]));
            }
        }
    }

    @Override
    public boolean canShare() {
        return false;
    }

    class SharedParameter {
        String name;
        boolean saveToCM;

        SharedParameter() {
        }
    }

    class NavIdParameter {
        String name;
        int type;

        NavIdParameter() {
        }
    }
}

