/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process.common;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.XMLString;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.pipeline.PipelineException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.stream.XMLStreamException;

public class ExpiredPassportCheck
extends Stage {
    private ServiceLogger logger;

    public ExpiredPassportCheck(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(ExpiredPassportCheck.class) : null;
    }

    @Override
    protected void executeImpl(StageContext context) throws PipelineException {
        this.sendCMRequest(context);
    }

    private void sendCMRequest(StageContext context) throws PipelineException {
        Query query = new Query();
        XMLString header = context.getBusHeader();
        query.setBusHeader(header != null ? ((Object)header).toString() : null);
        query.setSearchPath("~~");
        SOAPConnection connection = ((SOAPConnectionFactory)context.getEnv().getProperty("SoapConnectionFactory")).createConnection(this.logger);
        try {
            connection.execute(query, (String)context.getEnv().getProperty("contentManager"));
        }
        catch (MalformedURLException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("bad url.", e);
            }
            throw new PipelineException("pf.pipeline.process.error", new String[]{this.getName()}, e);
        }
        catch (SOAPFault e) {
            String detail = e.getDetail();
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1) {
                throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, null);
            }
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Content Manager returned a fault in the response.", e);
            }
            throw new PipelineException("pf.pipeline.process.error", new String[]{this.getName()}, e);
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an IO exception while retrieving the object from cm.", e);
            }
            throw new PipelineException("pf.pipeline.process.io.error", new String[]{this.getName()}, e);
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an xml stream exception while retrieving the object from cm.", e);
            }
            throw new PipelineException("pf.pipeline.process.xml.error", new String[]{this.getName()}, e);
        }
    }

    @Override
    public boolean canShare() {
        return false;
    }
}

