/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.process.upgrade;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.process.ContextUpgradeProcess;
import com.cognos.portal.fragment.server.pipeline.helper.NavHelper;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DefaultContextUpgrade
extends ContextUpgradeProcess {
    public DefaultContextUpgrade(ServiceLogger logger) {
        super(logger);
    }

    @Override
    protected void upgrade(Map old_properties, XMLParameters customParamsWriter) throws PipelineException {
        try {
            StringBuffer dialogCustomizations = new StringBuffer();
            XMLRecorderStreamWriter titleWriter = null;
            for (Map.Entry pair : old_properties.entrySet()) {
                String name = (String)pair.getKey();
                String value = (String)pair.getValue();
                if ((name.startsWith("title_") || name.startsWith("Title_")) && value.length() > 0) {
                    int lang_idx = name.indexOf("_");
                    if (lang_idx == -1) continue;
                    String lang = name.substring(lang_idx + 1);
                    if (titleWriter == null) {
                        titleWriter = XMLStreamFactory.createXMLRecorderStreamWriter();
                        titleWriter.writeStartElement("param");
                        titleWriter.writeAttribute("name", "title");
                    }
                    titleWriter.writeStartElement("value");
                    titleWriter.writeAttribute(XML_LANG_NAMESPACEPRFIX, XML_LANG_NAMESPACEURI, XML_LANG, lang);
                    titleWriter.writeCharacters(value);
                    titleWriter.writeEndElement();
                    continue;
                }
                if ("display_height".equals(name)) {
                    customParamsWriter.setParameter("viewerFragmentHeight", value);
                    continue;
                }
                if ("channel".equals(name)) {
                    customParamsWriter.setParameter("channel", value);
                    continue;
                }
                if ("display_settings_max".equals(name)) {
                    if (dialogCustomizations.length() > 0) {
                        dialogCustomizations.append("&");
                    }
                    dialogCustomizations.append("p_viewerToolbarMaximizeMode");
                    dialogCustomizations.append("=");
                    dialogCustomizations.append("t".equals(value) ? "showMaximize" : "");
                    continue;
                }
                if ("display_settings_norm".equals(name)) {
                    if (dialogCustomizations.length() > 0) {
                        dialogCustomizations.append("&");
                    }
                    dialogCustomizations.append("p_viewerToolbarNormalMode");
                    dialogCustomizations.append("=");
                    dialogCustomizations.append("t".equals(value) ? "showNormal" : "");
                    continue;
                }
                if ("display_action".equals(name)) {
                    if (dialogCustomizations.length() > 0) {
                        dialogCustomizations.append("&");
                    }
                    dialogCustomizations.append("p_reportLaunchOption");
                    dialogCustomizations.append("=");
                    if ("prompt".equals(value)) {
                        value = "runIcon";
                    } else if ("view".equals(value)) {
                        value = "output";
                    }
                    dialogCustomizations.append(value);
                    continue;
                }
                if ("view_action".equals(name)) {
                    if (dialogCustomizations.length() > 0) {
                        dialogCustomizations.append("&");
                    }
                    dialogCustomizations.append("p_reportLaunchSubOption");
                    dialogCustomizations.append("=");
                    dialogCustomizations.append("prompt".equals(value) ? "runIcon" : value);
                    continue;
                }
                if ("use_title".equals(name)) {
                    customParamsWriter.setParameter("viewerTitleOptions", "true".equals(value) ? "customTitle" : "entryName");
                    continue;
                }
                if ("display_id".equals(name)) {
                    customParamsWriter.setParameter("navSelectionId", NavHelper.getStoreId(value));
                    continue;
                }
                if ("TitleSource".equals(name)) {
                    customParamsWriter.setParameter("portletTitleType", "Typed".equals(value) ? "userEntered" : "default");
                    continue;
                }
                if ("PackageName".equals(name)) {
                    char delimiter = value.indexOf(39) == -1 ? (char)'\'' : '\"';
                    customParamsWriter.setParameter("cmmSelectedPackage", "/content/package[@name=" + delimiter + value + delimiter + "]");
                    continue;
                }
                if (!"rwc".equals(name)) continue;
                customParamsWriter.setParameter("rwc", value);
            }
            if (titleWriter != null) {
                titleWriter.writeEndElement();
                XMLStreamReader xsr = titleWriter.toXMLStreamReader();
                StaxUtils.moveToNextElement(xsr);
                customParamsWriter.add(new XMLParameter(xsr));
            }
            if (dialogCustomizations != null && dialogCustomizations.length() > 0) {
                customParamsWriter.setParameter("dialogCustomizations", dialogCustomizations.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new PipelineException("error upgrading cv portlet context", e);
        }
    }
}

