/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.producer.stage;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.IProcess;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import java.util.Enumeration;
import java.util.Map;

public abstract class Stage
implements IProcess {
    private ServiceLogger logger;
    private String name;

    public Stage(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(Stage.class) : null;
    }

    @Override
    public void initialize(Map inputs) throws PipelineException {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void execute(PipelineContext context) throws PipelineException {
        boolean execute;
        StageContext stageContext = new StageContext(context);
        String executionMode = (String)stageContext.getParam("executeWhenInMode");
        boolean bl = execute = executionMode == null || executionMode.equals(stageContext.getControllerParams().getValue("frag-mode"));
        if (execute) {
            this.executeImpl(stageContext);
        }
        Enumeration enumeration = context.getInputNamesEnumeration();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!context.canOutput(name) || context.isOutputAvailable(name)) continue;
            context.forwardInputAsOutput(name, name);
        }
    }

    protected abstract void executeImpl(StageContext var1) throws PipelineException;

    protected Object getRequiredParam(String name, StageContext context) throws PipelineException {
        Object value = context.getParam(name);
        if (value == null) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Process '" + this.getName() + "' missing parameter");
            }
            throw new PipelineException("The parameter '" + name + "' is required by the process '" + this.getName() + "'");
        }
        return value;
    }
}

