/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class RoutingTable {
    private static Pattern URI_PATTERN = Pattern.compile("\\$uri");
    private static Pattern PATH_PATTERN = Pattern.compile("\\$path");
    private static Pattern QUERY_PATTERN = Pattern.compile("\\$query");
    private static Pattern REF_PATTERN = Pattern.compile("\\$ref");
    private static Pattern SEG_PATTERN = Pattern.compile("\\$segment\\[(\\d+)\\]");
    private String segment;
    private String resolvedValue;
    protected List routingEntries;
    private boolean isSetOperation;
    private RoutingTable parent;

    public RoutingTable() {
        this("", "");
    }

    public RoutingTable(String segment, String resolvedValue) {
        this(segment, resolvedValue, false);
    }

    public RoutingTable(String segment, String resolvedValue, boolean isSetOperation) {
        this.segment = segment;
        this.resolvedValue = resolvedValue;
        this.isSetOperation = isSetOperation;
    }

    public String getSegmentName() {
        return this.segment;
    }

    public String resolve(String uri) {
        String path = this.getPath(uri);
        String query = this.getQuery(uri);
        String resolvedUri = this.resolvePrivate(path);
        if (this.isRoot()) {
            boolean canBeResolved = !path.equals(resolvedUri);
            int count = 0;
            while (canBeResolved) {
                if (count > 10) {
                    throw new RuntimeException("programmer's error: nested resolve exceeded limit of 10");
                }
                String tmp = this.resolvePrivate(resolvedUri);
                if (tmp.length() == 0 || resolvedUri.equals(tmp)) {
                    canBeResolved = false;
                } else {
                    resolvedUri = tmp;
                }
                ++count;
            }
        }
        if (query.length() > 0) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(resolvedUri);
            if (resolvedUri.indexOf(63) == -1) {
                tmp.append('?');
            } else {
                tmp.append('&');
            }
            tmp.append(query);
            return tmp.toString();
        }
        return resolvedUri;
    }

    private String resolvePrivate(String path) {
        String extraInfo = path;
        RoutingTable current = this;
        ArrayList<String> firstSegments = new ArrayList<String>();
        if (!this.isRoot()) {
            firstSegments.add(this.segment);
        }
        while (extraInfo.length() > 0) {
            int index = extraInfo.indexOf(47, 1);
            if (index == -1) {
                index = extraInfo.length();
            }
            String firstSegment = extraInfo.length() > 0 && extraInfo.charAt(0) == '/' ? extraInfo.substring(1, index) : extraInfo.substring(0, index);
            String remaingSegments = extraInfo.substring(index);
            RoutingTable entry = current.findRoutingEntry(firstSegment, true);
            if (entry == null) break;
            firstSegments.add(firstSegment);
            current = entry;
            extraInfo = remaingSegments;
        }
        String resolvedValue = "";
        while (firstSegments.size() > 0) {
            extraInfo = resolvedValue = current.merge(path, (String)firstSegments.remove(firstSegments.size() - 1), extraInfo) + resolvedValue;
            if (current.isSetOperation) break;
            current = current.parent;
        }
        return resolvedValue;
    }

    private String merge(String fullUri, String firstSegment, String extraInfo) {
        String resolvedUri = this.getResolvedValue();
        Matcher m = URI_PATTERN.matcher(resolvedUri);
        if (m != null && m.find()) {
            resolvedUri = m.replaceAll(fullUri);
        }
        if ((m = PATH_PATTERN.matcher(resolvedUri)) != null && m.find()) {
            resolvedUri = m.replaceAll(this.getPath(extraInfo));
        }
        if ((m = QUERY_PATTERN.matcher(resolvedUri)) != null && m.find()) {
            resolvedUri = m.replaceAll(this.getQuery(extraInfo));
        }
        if ((m = REF_PATTERN.matcher(resolvedUri)) != null && m.find()) {
            resolvedUri = m.replaceAll(this.getRef(extraInfo));
        }
        if ((m = SEG_PATTERN.matcher(resolvedUri)) != null) {
            StringBuffer sb = null;
            while (m.find()) {
                String value;
                if (sb == null) {
                    sb = new StringBuffer();
                }
                if ((value = m.group(1)) == null) continue;
                int which = Integer.parseInt(value);
                String selectedSegment = which == 0 ? (firstSegment != null ? firstSegment : "") : this.getSegment(extraInfo, which);
                m.appendReplacement(sb, selectedSegment);
            }
            if (sb != null) {
                m.appendTail(sb);
                resolvedUri = sb.toString();
            }
        }
        return resolvedUri;
    }

    public void addRouting(RoutingTable entry) {
        this.createRoutingEntries();
        entry.parent = this;
        RoutingTable rt = this.findRoutingEntry(entry.segment, false);
        if (rt != null) {
            this.routingEntries.remove(rt);
            if (rt.routingEntries != null) {
                Iterator it = rt.routingEntries.iterator();
                while (it.hasNext()) {
                    entry.addRouting((RoutingTable)it.next());
                }
            }
            if (entry.resolvedValue == null) {
                entry.resolvedValue = rt.resolvedValue;
                entry.isSetOperation = rt.isSetOperation;
            }
        }
        this.routingEntries.add(entry);
    }

    protected void createRoutingEntries() {
        if (this.routingEntries == null) {
            this.routingEntries = new ArrayList();
        }
    }

    public RoutingTable getRoutingTable(String path) {
        if (path != null && path.length() > 0) {
            int index = path.indexOf(47, 1);
            if (index == -1) {
                index = path.length();
            }
            String firstSegment = path.charAt(0) == '/' ? path.substring(1, index) : path.substring(0, index);
            return this.findRoutingEntry(firstSegment, false);
        }
        return null;
    }

    private String getSegment() {
        return this.segment;
    }

    private String getRef(String path) {
        int index = path.indexOf(35);
        if (index != -1) {
            return path.substring(index + 1);
        }
        return "";
    }

    private String getQuery(String path) {
        int index = path.indexOf(63);
        if (index != -1) {
            int end = path.indexOf(35, index);
            if (end == -1) {
                end = path.length();
            }
            return path.substring(index + 1, end);
        }
        return "";
    }

    private String getPath(String path) {
        int index = path.indexOf(63);
        if (index != -1) {
            return path.substring(0, index);
        }
        index = path.indexOf(35);
        if (index != -1) {
            return path.substring(0, index);
        }
        return path;
    }

    private String getSegment(String path, int number) {
        StringTokenizer tokens;
        String calculatedPath = this.getPath(path);
        if (calculatedPath != null && (tokens = new StringTokenizer(calculatedPath, "/")).countTokens() >= number) {
            for (int i = 1; i < number; ++i) {
                tokens.nextToken();
            }
            return tokens.nextToken();
        }
        return "";
    }

    private String getResolvedValue() {
        return this.resolvedValue != null ? this.resolvedValue : "";
    }

    protected RoutingTable findRoutingEntry(String segment, boolean useWildCard) {
        RoutingTable defaultEntry = null;
        if (this.routingEntries != null) {
            for (RoutingTable entry : this.routingEntries) {
                if (segment.equals(entry.getSegment())) {
                    return entry;
                }
                if (!useWildCard) continue;
                if ("*".equals(entry.getSegment())) {
                    defaultEntry = entry;
                    continue;
                }
                if (!"+".equals(entry.getSegment())) continue;
                return entry.findRoutingEntry(segment, true);
            }
        }
        return defaultEntry;
    }

    public void addRoutingsFromStream(XMLStreamReader xsr) throws XMLStreamException {
        int level = 0;
        while (xsr.hasNext()) {
            int event = xsr.next();
            switch (event) {
                case 1: {
                    String localName = xsr.getLocalName();
                    if ("routing".equals(localName) || "segment".equals(localName)) {
                        RoutingTable rt = RoutingTable.parse(xsr);
                        this.addRouting(rt);
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level >= 0) break;
                    return;
                }
            }
        }
    }

    public void writeXML(XMLStreamWriter xsw) throws XMLStreamException {
        if (this.isRoot()) {
            xsw.writeStartElement("routingTable");
        } else {
            xsw.writeStartElement("segment");
            xsw.writeAttribute("name", this.segment);
            xsw.writeAttribute(this.isSetOperation ? "set" : "add", this.getResolvedValue());
        }
        if (this.routingEntries != null) {
            for (RoutingTable rt : this.routingEntries) {
                rt.writeXML(xsw);
            }
        }
        xsw.writeEndElement();
        xsw.flush();
    }

    public static RoutingTable parse(XMLStreamReader xsr) throws XMLStreamException {
        String segment = xsr.getAttributeValue("", "name");
        if (segment == null) {
            segment = "";
        }
        String resolvedValue = xsr.getAttributeValue("", "add");
        boolean isSet = false;
        if (resolvedValue == null && (resolvedValue = xsr.getAttributeValue("", "set")) != null) {
            isSet = true;
        }
        if (resolvedValue == null && (resolvedValue = xsr.getAttributeValue("", "value")) != null && resolvedValue.indexOf("://") != -1) {
            isSet = true;
        }
        RoutingTable routingTable = new RoutingTable(segment, resolvedValue, isSet);
        routingTable.addRoutingsFromStream(xsr);
        return routingTable;
    }

    private boolean isRoot() {
        return this.parent == null;
    }
}

