/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.routing;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.routing.DynamicPortletRoutingTable;
import com.cognos.portal.fragment.routing.RoutingTable;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.web.WebUtils;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RoutingUtils {
    static final String WSRP_CPS_EXTENSION_NAMESPACE_URI = "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/";
    static final String XSD_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    static Date portalModificationTimeStamp = null;

    public static void addProducerRoutings(final RoutingTable routingTable, final RoutingTable cmProvider, String seachPath, final IContext context, final ServiceLogger logger) {
        block2: {
            Query query = new Query();
            query.setSearchPath(seachPath);
            query.addProperty("storeID");
            query.addProperty("binding");
            query.addProperty("registration");
            query.setResponseBodyHandler(new IXMLHandler(){

                @Override
                public void handle(XMLStreamReader reader) throws XMLStreamException {
                    String storeID = null;
                    String producerEndpoint = null;
                    block6: while (reader.hasNext()) {
                        int event = reader.next();
                        switch (event) {
                            case 1: {
                                String registration;
                                XMLStreamReader registrationReader;
                                String localName = reader.getLocalName();
                                if ("storeID".equals(localName)) {
                                    if (reader.nextTag() != 1 || !"value".equals(reader.getLocalName())) break;
                                    storeID = reader.getElementText();
                                    break;
                                }
                                if ("binding".equals(localName)) {
                                    if (reader.nextTag() != 1 || !"value".equals(reader.getLocalName())) break;
                                    String binding = reader.getElementText();
                                    XMLStreamReader bindingReader = XMLStreamFactory.createXMLStreamReader(new StringReader(binding));
                                    int index = StaxUtils.moveToAnyElement(new String[]{"segment", "port"}, bindingReader);
                                    if (index == 0) {
                                        RoutingTable producerBindingTable = RoutingTable.parse(bindingReader);
                                        routingTable.addRouting(producerBindingTable);
                                        producerEndpoint = producerBindingTable.getSegmentName();
                                        if (producerEndpoint.length() != 0 && producerEndpoint.charAt(0) == '/') continue block6;
                                        producerEndpoint = "/" + producerEndpoint;
                                        break;
                                    }
                                    if (index != 1 || producerEndpoint != null) continue block6;
                                    producerEndpoint = RoutingUtils.scanWSRPBindingForProducerEndpoint(bindingReader);
                                    break;
                                }
                                if (!"registration".equals(localName)) break;
                                if (producerEndpoint == null && reader.nextTag() == 1 && "value".equals(reader.getLocalName()) && StaxUtils.moveToElement("extensions", registrationReader = XMLStreamFactory.createXMLStreamReader(new StringReader(registration = reader.getElementText())))) {
                                    while (registrationReader.hasNext()) {
                                        int event2 = registrationReader.next();
                                        switch (event2) {
                                            case 1: {
                                                String localName2 = registrationReader.getLocalName();
                                                String namespaceURI2 = registrationReader.getNamespaceURI();
                                                if (!"endpoint".equals(localName2) || !RoutingUtils.WSRP_CPS_EXTENSION_NAMESPACE_URI.equals(namespaceURI2)) break;
                                                producerEndpoint = registrationReader.getElementText();
                                            }
                                        }
                                    }
                                }
                                if (storeID != null) {
                                    RoutingTable producerRouting;
                                    boolean wsrp;
                                    if (producerEndpoint != null) {
                                        wsrp = false;
                                        producerRouting = new RoutingTable(storeID, producerEndpoint, true);
                                    } else {
                                        wsrp = true;
                                        producerRouting = new RoutingTable(storeID, "");
                                    }
                                    RoutingUtils.addPortletRoutings(producerRouting, "storeID(\"" + storeID + "\")/*", context, wsrp, storeID, logger);
                                    producerRouting.addRouting(new DynamicPortletRoutingTable(context, wsrp, storeID, logger));
                                    cmProvider.addRouting(producerRouting);
                                }
                                producerEndpoint = null;
                                storeID = null;
                            }
                        }
                    }
                }
            });
            SOAPConnectionFactory factory = (SOAPConnectionFactory)context.getProperty("trustedSoapConnectionFactory");
            SOAPConnection connection = factory.createConnection(logger);
            try {
                connection.execute(query, (String)context.getProperty("contentManager"));
            }
            catch (Exception e) {
                if (logger == null || !logger.isErrorEnabled()) break block2;
                logger.error("malformed url for connection", e);
            }
        }
    }

    static String scanWSRPBindingForProducerEndpoint(XMLStreamReader bindingReader) throws XMLStreamException {
        String producerEndpoint = null;
        do {
            String location;
            String portName;
            if (!bindingReader.isStartElement() || !"port".equals(bindingReader.getLocalName()) || !"WSRPBaseService".equals(portName = bindingReader.getAttributeValue("", "name")) || !StaxUtils.moveToElement("address", bindingReader) || (location = bindingReader.getAttributeValue("", "location")) == null || location.indexOf("/wsrp/fragments/markup") == -1) continue;
            producerEndpoint = WebUtils.getPathInfoParameter(location, "handle", '/');
            if (producerEndpoint == null) {
                producerEndpoint = "/";
                continue;
            }
            if (producerEndpoint.length() != 0 && producerEndpoint.charAt(0) == '/') continue;
            producerEndpoint = "/" + producerEndpoint;
        } while (producerEndpoint == null && StaxUtils.moveToElement("port", bindingReader));
        return producerEndpoint;
    }

    public static void addPortletRoutings(final RoutingTable producerRoutingTable, String path, IContext context, final boolean wsrp, final String producerStoreID, ServiceLogger logger) {
        block2: {
            Query query = new Query();
            query.setSearchPath(path);
            query.addProperty("parent");
            query.addProperty("storeID");
            query.addProperty("handle");
            query.setResponseBodyHandler(new IXMLHandler(){

                @Override
                public void handle(XMLStreamReader reader) throws XMLStreamException {
                    String storeID = null;
                    while (reader.hasNext()) {
                        int event = reader.next();
                        switch (event) {
                            case 1: {
                                String tmpStoreId;
                                String localName = reader.getLocalName();
                                if ("storeID".equals(localName)) {
                                    if (reader.nextTag() != 1 || !"value".equals(reader.getLocalName())) break;
                                    storeID = reader.getElementText();
                                    break;
                                }
                                if ("handle".equals(localName)) {
                                    if (storeID != null && reader.nextTag() == 1 && "value".equals(reader.getLocalName())) {
                                        if (wsrp) {
                                            RoutingTable rt = new RoutingTable(storeID, "/wsrp/" + storeID, true);
                                            producerRoutingTable.addRouting(rt);
                                        } else {
                                            String handle = reader.getElementText();
                                            int index = handle.indexOf(35);
                                            if (index != -1) {
                                                handle = handle.substring(0, index);
                                            }
                                            if (handle.length() == 0 || handle.charAt(0) != '/') {
                                                handle = "/" + handle;
                                            }
                                            handle = handle + "/" + storeID + "/prod/" + producerStoreID;
                                            producerRoutingTable.addRouting(new RoutingTable(storeID, handle));
                                        }
                                    }
                                    storeID = null;
                                    break;
                                }
                                if (!"parent".equals(localName)) break;
                                StaxUtils.moveToElement("storeID", reader);
                                if (reader.nextTag() != 1 || !"value".equals(reader.getLocalName()) || (tmpStoreId = reader.getElementText()).equals(producerStoreID)) break;
                                return;
                            }
                        }
                    }
                }
            });
            SOAPConnectionFactory factory = (SOAPConnectionFactory)context.getProperty("trustedSoapConnectionFactory");
            SOAPConnection connection = factory.createConnection(logger);
            try {
                connection.execute(query, (String)context.getProperty("contentManager"));
            }
            catch (Exception e) {
                if (logger == null || !logger.isErrorEnabled()) break block2;
                logger.error("encountered a soap fault when trying to execute the connection", e);
            }
        }
    }

    public static Date getPortalModificationTime(IContext context, ServiceLogger logger) {
        Date modificationTimeStamp;
        block2: {
            final HashMap hashMap = new HashMap(1);
            modificationTimeStamp = null;
            Query query = new Query();
            query.setSearchPath("/portal/portalPackage[@name='Connection']/portletFolder[@name='Portlets']");
            query.addProperty("modificationTime");
            query.setResponseBodyHandler(new IXMLHandler(){

                @Override
                public void handle(XMLStreamReader reader) throws XMLStreamException {
                    while (reader.hasNext()) {
                        int event = reader.next();
                        switch (event) {
                            case 1: {
                                String localName = reader.getLocalName();
                                if (!"modificationTime".equals(localName) || reader.nextTag() != 1 || !"value".equals(reader.getLocalName())) break;
                                hashMap.put("modificationTime", reader.getElementText());
                            }
                        }
                    }
                }
            });
            SOAPConnectionFactory factory = (SOAPConnectionFactory)context.getProperty("trustedSoapConnectionFactory");
            SOAPConnection connection = factory.createConnection(logger);
            try {
                connection.execute(query, (String)context.getProperty("contentManager"));
                SimpleDateFormat formatter = new SimpleDateFormat(XSD_DATE_TIME_FORMAT);
                modificationTimeStamp = formatter.parse((String)hashMap.get("modificationTime"));
            }
            catch (Exception e) {
                if (logger == null || !logger.isErrorEnabled()) break block2;
                logger.error("encountered a soap fault when trying to execute the connection", e);
            }
        }
        return modificationTimeStamp;
    }
}

