/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.XSLTFactory;
import com.cognos.portal.fragment.meta.ScriptLibrary;
import com.cognos.portal.fragment.meta.StyleLink;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.document.IDocumentFactory;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.JavascriptOutputStream;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.MultiBufferByteArrayOutputStream;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.TrustedSessionHelper;
import com.cognos.portal.xml.i18n.LocalizationManager;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.PipelineFactory;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriterImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DashboardProcessor {
    private DashboardContext context;
    private ServiceLogger logger;

    public DashboardProcessor(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(DashboardProcessor.class) : null;
    }

    public void init(IContext initContext) throws DashboardException {
        this.context = new DashboardContext();
        this.context.setStylesheetSource(0, initContext.getProperty("xslt.xmlashtml").toString());
        this.context.setStylesheetSource(1, initContext.getProperty("xslt.page").toString());
        this.context.setStylesheetSource(2, initContext.getProperty("xslt.pagelet").toString());
        this.context.setStylesheetSource(3, initContext.getProperty("xslt.script").toString());
        this.context.setStylesheetSource(4, initContext.getProperty("xslt.css").toString());
        this.context.setStylesheetSource(5, initContext.getProperty("xslt.messageasjs").toString());
        this.context.setDefaultSkinCSS(initContext.getProperty("css.skin").toString());
        this.context.setMessageFile(initContext.getProperty("xslt.message").toString());
    }

    public void terminate() throws DashboardException {
        this.context = null;
    }

    public void process(Environment env) {
        block50: {
            String target;
            String fragDebug = env.getParameter("frag-debug");
            String fragResource = env.getParameter("frag-resource");
            if (fragResource != null) {
                fragResource = EncodingUtils.urldecode(fragResource, "UTF-8");
                try {
                    env.proxyResource(fragResource);
                }
                catch (DashboardException ex) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("error proxying resource", ex);
                    }
                    break block50;
                }
            }
            if ("routing".equals(fragDebug)) {
                try {
                    env.writeRoutingTable();
                }
                catch (DashboardException ex) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("an exception has occurred when trying to write the routing table document", ex);
                    }
                    break block50;
                }
            }
            if ("restart".equals(fragDebug)) {
                LocalizationManager.getInstance().initialize();
                XSLTFactory.reinitialize();
                PipelineFactory.reinitialize();
            }
            if ((target = env.getParameter("frag-producer")) == null) {
                target = env.getTarget();
            }
            if ("".equals(target)) {
                target = env.getDefaultTarget(this.context);
            }
            if (target.startsWith("/css/")) {
                env.writeCSS(this.context);
            } else if (target.startsWith("/messages/")) {
                env.writeMessage(this.context);
            } else {
                IDocumentFactory documentFactory = (IDocumentFactory)env.getProperty("FragmentDocumentFactory");
                DashboardDocument doc = null;
                String fragID = env.getParameter("frag-id");
                String customPropertiesParam = env.getParameter("frag-customProperties");
                if (fragID == null && (env.getParameter("frag-custom") != null || customPropertiesParam != null)) {
                    doc = documentFactory.createErrorDocument(this.context, env, "", fragID, null, null, this.logger);
                } else if ("+++PRODUCER_IS_INVALID+++".equals(target)) {
                    env.discardParameters(target);
                    fragID = env.getParameter("frag-id");
                    doc = documentFactory.createErrorDocument(this.context, env, "", fragID, null, null, this.logger);
                } else {
                    Parameters customs;
                    Parameters params;
                    block51: {
                        String wsrpParam;
                        try {
                            env.verify(target, false);
                        }
                        catch (Throwable e) {
                            env.discardParameters(target);
                            fragID = env.getParameter("frag-id");
                            doc = documentFactory.createErrorDocument(this.context, env, target, fragID, null, e, this.logger);
                        }
                        params = env.createParameters();
                        if (fragID != null) {
                            params.add("frag-id", fragID);
                        }
                        customs = null;
                        String fragAction = env.getParameter("frag-action");
                        if (fragAction != null && "reset".equals(fragAction)) {
                            customs = new Parameters();
                            try {
                                Pipeline pipeline = PipelineFactory.getInstance().createPipeline("pipeline://cmProvider", env);
                                pipeline.setParam("params", params);
                                pipeline.setParam("href", target);
                                pipeline.setParam("customUpdate", customs);
                                pipeline.execute();
                            }
                            catch (PipelineException e) {
                                doc = documentFactory.createErrorDocument(this.context, env, target, fragID, null, e, this.logger);
                            }
                        } else {
                            Parameters encodedCustoms;
                            String controllerAgent;
                            if (customPropertiesParam != null && ("fragment/1.1.0".equals(controllerAgent = env.getControllerAgent()) || "attach".equals(env.getParameter("frag-action")))) {
                                customs = Parameters.parse(customPropertiesParam);
                            }
                            if ((encodedCustoms = DashboardDocument.decodeCustoms(env.getParameter("frag-custom"))) != null) {
                                if (customs == null) {
                                    customs = encodedCustoms;
                                } else {
                                    for (Parameters.NameValuePair nvp : encodedCustoms) {
                                        customs.setValues(nvp.getName(), nvp.getValues());
                                    }
                                }
                            }
                        }
                        if (doc == null && this.isFagmentTokenCheckEnabled(env) && this.isTargetInCheckList(env, target)) {
                            String authtoken = env.getParameter("frag-authToken");
                            String userSessionId = env.getUserSessionIdCookie();
                            if (!TrustedSessionHelper.getInstance().verifyAuthenticityToken(authtoken, userSessionId)) {
                                if (this.logger.isErrorEnabled()) {
                                    this.logger.error("Verification of frag-authToken has failed.");
                                }
                                doc = documentFactory.createErrorDocument(this.context, env, target, fragID, null, null, this.logger);
                            }
                        }
                        if ((wsrpParam = env.getParameter("wsrp_portlet_state_extension")) != null) {
                            try {
                                XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader(new StringReader(wsrpParam));
                                while (reader.hasNext()) {
                                    int event = reader.next();
                                    if (event != 11) continue;
                                    if (this.logger != null && this.logger.isErrorEnabled()) {
                                        this.logger.error("DOCTYPE node not supported");
                                    }
                                    return;
                                }
                            }
                            catch (XMLStreamException e) {
                                if (this.logger == null || !this.logger.isErrorEnabled()) break block51;
                                this.logger.error("XML error parsing wsrp_portlet_state_extension");
                            }
                        }
                    }
                    if (doc == null) {
                        doc = documentFactory.createDocument(this.context, env, target, fragID, null, null, customs, params, this.logger);
                    }
                }
                String fragEmbed = env.getParameter("frag-embed");
                boolean srcOnly = "src".equals(fragDebug);
                if (fragEmbed == null && (fragID != null || srcOnly)) {
                    env.setResponseContentType("text/xml;charset=UTF-8");
                    try {
                        this.writeXML(env, doc, srcOnly);
                    }
                    catch (Throwable e) {
                        try {
                            doc = documentFactory.createErrorDocument(this.context, env, target, fragID, null, e, this.logger);
                            this.writeXML(env, doc, false);
                            break block50;
                        }
                        catch (Throwable ex) {
                            if (this.logger != null && this.logger.isErrorEnabled()) {
                                this.logger.error("an exception has occurred when trying to write the XML error document", ex);
                            }
                            break block50;
                        }
                    }
                }
                boolean xmlOnly = "xml".equals(fragDebug);
                try {
                    this.writeHTML(env, doc, xmlOnly, fragEmbed);
                }
                catch (Throwable e) {
                    try {
                        doc = documentFactory.createErrorDocument(this.context, env, target, fragID, null, e, this.logger);
                        this.writeHTML(env, doc, xmlOnly, fragEmbed);
                    }
                    catch (Throwable ex) {
                        if (this.logger == null || !this.logger.isErrorEnabled()) break block50;
                        this.logger.error("an exception occurred when trying to output the error HTML page", ex);
                    }
                }
            }
        }
    }

    private boolean isFagmentTokenCheckEnabled(Environment env) {
        String fragmentTokenCheckDisabledProperty = (String)env.getProperty("fragment.token.check.disabled");
        return fragmentTokenCheckDisabledProperty == null || Boolean.valueOf(fragmentTokenCheckDisabledProperty) != true;
    }

    private boolean isTargetInCheckList(Environment env, String target) {
        String fragmentTokenCheckListProperty = (String)env.getProperty("fragment.token.checklist");
        if (fragmentTokenCheckListProperty != null) {
            List<String> targetCheckList = Arrays.asList(fragmentTokenCheckListProperty.split(","));
            for (String item : targetCheckList) {
                if (!target.toLowerCase().startsWith(item.toLowerCase())) continue;
                String mode = env.getParameter("frag-mode");
                if (item.toLowerCase().equals("/cmprovider") && mode != null && mode.equalsIgnoreCase("help")) continue;
                return true;
            }
        }
        return false;
    }

    private void writeXML(Environment env, DashboardDocument doc, boolean srcOnly) throws XMLStreamException, DashboardException, IOException {
        MultiBufferByteArrayOutputStream mbbaos = new MultiBufferByteArrayOutputStream(4096);
        XMLTransactionalStreamWriterImpl xsw = new XMLTransactionalStreamWriterImpl(mbbaos);
        xsw.writeStartDocument();
        if (srcOnly) {
            doc.writeDocument(xsw);
        } else {
            doc.writeXML(xsw);
        }
        xsw.writeEndDocument();
        xsw.flush();
        mbbaos.writeTo(env.getOutputStream());
    }

    private void writeHTML(Environment env, DashboardDocument doc, boolean xmlOnly, String embedingType) throws DashboardException, XMLStreamException, IOException {
        MultiBufferByteArrayOutputStream mbbaos = new MultiBufferByteArrayOutputStream(4096);
        doc.writeHTML(mbbaos, xmlOnly, "body".equals(embedingType) ? "script" : embedingType);
        if (embedingType != null) {
            env.setResponseContentType("application/x-javascript");
            OutputStream out = env.getOutputStream();
            if ("header".equals(embedingType)) {
                StringBuffer sb = new StringBuffer();
                sb.append("<script type=\"text/javascript\" src=\"").append(env.getApplicationGatewayURI()).append("/messages/messages/pfmessages?section=JS").append("\"></script>");
                Iterator it = doc.getStyleLinks();
                while (it.hasNext()) {
                    StyleLink css = (StyleLink)it.next();
                    sb.append("<link rel=\"stylesheet\" type=\"").append(css.getType()).append("\" media=\"").append(css.getMedia()).append("\" href=\"").append(css.getHref()).append("\">");
                }
                it = doc.getLibraries();
                while (it.hasNext()) {
                    ScriptLibrary lib = (ScriptLibrary)it.next();
                    sb.append("<script type=\"").append(lib.getType()).append("\" src=\"").append(lib.getHref()).append("\"></script>");
                }
                if ("controller".equals(env.getParameter("frag-debug")) || "true".equals(env.getProperty("controller.debug"))) {
                    sb.append("<script type=\"text/javascript\">");
                    sb.append("if (navigator.userAgent.indexOf(\"Firefox\")== -1 && window.console == undefined) { var head = document.getElementsByTagName('HEAD').item(0);");
                    sb.append("var node = document.createElement(\"SCRIPT\"); node.type = 'text/javascript';");
                    sb.append(" node.src = '").append(env.getWebContent()).append(env.getProperty("controller.debug.IELite.file"));
                    sb.append("'; head.appendChild(node);}</script><script type=\"text/javascript\" src=\"");
                    sb.append(env.getWebContent()).append(env.getProperty("controller.debug.file")).append("\"></script>");
                }
                out.write("document.write(\"".getBytes("UTF-8"));
                out.write(EncodingUtils.javascriptencode(sb.toString()).getBytes("UTF-8"));
                out.write("\");".getBytes("UTF-8"));
            } else {
                if ("script".equals(embedingType)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("var __list = new Array();\n");
                    Iterator it = doc.getStyleLinks();
                    while (it.hasNext()) {
                        StyleLink css = (StyleLink)it.next();
                        sb.append("__list.push([\"LINK\", \"").append(css.getHref()).append("\", \"").append(css.getMedia()).append("\"]);\n");
                    }
                    it = doc.getLibraries();
                    while (it.hasNext()) {
                        ScriptLibrary lib = (ScriptLibrary)it.next();
                        sb.append("__list.push([\"SCRIPT\", \"").append(lib.getHref()).append("\"]);\n");
                    }
                    sb.append("_F_loadFragmentResources(__list);\n");
                    out.write(sb.toString().getBytes("UTF-8"));
                }
                out.write("document.write(\"".getBytes("UTF-8"));
                JavascriptOutputStream jsout = new JavascriptOutputStream(out);
                mbbaos.writeTo(jsout);
                out.write("\");".getBytes("UTF-8"));
            }
        } else {
            if (xmlOnly) {
                env.setResponseContentType("text/xml;charset=UTF-8");
            } else {
                env.setResponseContentType("text/html;charset=UTF-8");
            }
            mbbaos.writeTo(env.getOutputStream());
        }
    }

    static {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("pfmsgs");
        MessagesManager.getInstance().initialize(msgFileList);
    }
}

