/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server;

import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.meta.MetaProperty;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.FragmentTransients;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.rewriters.IDashboardURLRewriter;
import com.cognos.portal.fragment.server.rewriters.URLRewriteException;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.JSONObject;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DashboardURLRewriterImpl
implements IDashboardURLRewriter {
    private static final String _THIS_ = "_THIS_";
    private String uniqueID;
    protected String appGateway;
    protected String gateway;
    protected String webContent;
    private StringBuffer scripts;
    private int counter;
    private Map subfragments;
    private Validator validator;

    public DashboardURLRewriterImpl(String uniqueID, String gateway, String appGateway, String webContent) {
        this.uniqueID = uniqueID;
        this.webContent = webContent;
        this.scripts = new StringBuffer();
        this.subfragments = null;
        this.validator = null;
        this.appGateway = appGateway;
        this.gateway = gateway;
    }

    @Override
    public void generateURL(Parameters urlParams, XMLTransactionalStreamWriter result) throws URLRewriteException {
        String urlEncodedResource = urlParams.getValue("frag-resource");
        String urlType = urlParams.getValue("frag-urlType");
        if (urlEncodedResource != null) {
            this.rewriteResourceURLType(EncodingUtils.urldecode(urlEncodedResource, "UTF-8"), result, "resourceproxy".equals(urlType));
        } else {
            String subfragment = urlParams.getValue("frag-subfragment");
            if (subfragment != null) {
                try {
                    String fragID;
                    result.flush();
                    int identifier = result.getInternalBuffers().createBuffer(4096);
                    if (this.subfragments == null) {
                        this.subfragments = new HashMap();
                    }
                    if ((fragID = urlParams.getValue("frag-id")) == null) {
                        fragID = urlParams.getValue("amp;frag-id");
                    }
                    if (fragID != null) {
                        int i = fragID.indexOf(_THIS_);
                        while (i != -1) {
                            fragID = fragID.substring(0, i) + fragID.substring(i + _THIS_.length());
                            i = fragID.indexOf(_THIS_);
                        }
                        this.subfragments.put(subfragment, fragID);
                    }
                    this.subfragments.put(fragID != null ? fragID : subfragment, new Integer(identifier));
                    result.getInternalBuffers().createBuffer(4096);
                }
                catch (XMLStreamException e) {
                    throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
                }
            }
            if (urlParams.getValue("frag-signname") != null) {
                String frag_Signname = urlParams.getValue("frag-signname");
                String frag_Signvalue = urlParams.getValue("frag-signvalue");
                if (this.validator != null) {
                    try {
                        frag_Signvalue = this.validator.sign(frag_Signname, frag_Signvalue);
                    }
                    catch (Throwable e) {
                        throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
                    }
                }
                try {
                    result.writeCharacters(frag_Signvalue);
                }
                catch (XMLStreamException e) {
                    throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
                }
            }
            if (urlType != null && ("gateway".equals(urlType) || "gatewayproxy".equals(urlType))) {
                this.rewriteGatewayURLType(urlType, urlParams, result);
            } else {
                StringBuffer content = new StringBuffer();
                if (this.validator != null) {
                    try {
                        this.validator.sign(urlParams);
                    }
                    catch (Throwable e) {
                        throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
                    }
                }
                for (Parameters.NameValuePair nvp : urlParams) {
                    String[] values = nvp.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        if (content.length() > 0) {
                            content.append('&');
                        }
                        content.append(nvp.getName());
                        content.append('=');
                        content.append(values[i]);
                    }
                }
                this.scripts.append("function ").append(this.uniqueID).append("fetch").append(this.counter).append("() { ").append(this.uniqueID).append(".performAction(\"").append(EncodingUtils.javascriptencode(content.toString())).append("\" + _F_Form.getActionParams(\"").append(this.uniqueID).append("fetch").append(this.counter).append("()\")); }\n");
                try {
                    result.writeCharacters("javascript:");
                    result.writeCharacters(this.uniqueID);
                    result.writeCharacters("fetch");
                    result.writeCharacters(Integer.toString(this.counter));
                    result.writeCharacters("()");
                }
                catch (XMLStreamException e) {
                    throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
                }
                ++this.counter;
            }
        }
    }

    protected void rewriteResourceURLType(String urlResource, XMLTransactionalStreamWriter result, boolean isProxy) throws URLRewriteException {
        try {
            if (urlResource.startsWith("http://")) {
                result.writeCharacters(this.appGateway);
                result.writeCharacters("?");
                result.writeCharacters("frag-resource");
                result.writeCharacters("=");
                result.writeCharacters(EncodingUtils.urlencode(urlResource, "UTF-8", true));
            } else {
                result.writeCharacters(this.webContent);
                if (urlResource.length() > 0 && urlResource.charAt(0) != '/') {
                    result.writeCharacters("/");
                }
                result.writeCharacters(urlResource);
            }
        }
        catch (XMLStreamException e) {
            throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
        }
    }

    protected void rewriteGatewayURLType(String urlType, Parameters urlParams, XMLTransactionalStreamWriter result) throws URLRewriteException {
        try {
            result.writeCharacters(this.gateway);
            urlParams.remove("frag-urlType");
            if (urlParams.size() > 0) {
                Iterator it = urlParams.iterator();
                boolean firstParam = true;
                while (it.hasNext()) {
                    Parameters.NameValuePair nvp = (Parameters.NameValuePair)it.next();
                    String[] values = nvp.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        if (firstParam) {
                            result.writeCharacters("?");
                            firstParam = false;
                        } else {
                            result.writeCharacters("&");
                        }
                        result.writeCharacters(nvp.getName());
                        result.writeCharacters("=");
                        result.writeCharacters(values[i]);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
        }
    }

    @Override
    public void generateUniqueFragmentId(XMLStreamWriter result) throws URLRewriteException {
        try {
            result.writeCharacters(this.uniqueID);
        }
        catch (XMLStreamException e) {
            throw new URLRewriteException("pf.fragment.server.rewritefailed", null, e);
        }
    }

    @Override
    public boolean isAdditionalScripts() {
        return this.scripts.length() > 0;
    }

    @Override
    public String getAdditionalScripts() {
        return this.scripts.toString();
    }

    @Override
    public void resetScripts() {
        this.scripts = new StringBuffer();
    }

    @Override
    public Map getSubfragmentBuffers() {
        return this.subfragments;
    }

    @Override
    public void setValidationDocument(Validator validator) {
        this.validator = validator;
    }

    @Override
    public void writeControllerScripts(XMLStreamWriter xsw, String fragmentPath, String uniqueId, Info info, Meta meta, Parameters parameters, Parameters customs, Parameters transients, String target, Environment env, boolean isPage, String newWindowState, String newMode, String preferredTitle, String state, boolean isAttach, FragmentTransients globalTransients) throws DashboardException, XMLStreamException {
        DashboardException delayedException = null;
        StringBuffer sb = new StringBuffer(1024);
        sb.append("<script type=\"text/javascript\">");
        JSONObject obj = new JSONObject();
        String channel = null;
        if (parameters != null) {
            channel = parameters.getValue("frag-channel");
        }
        if (isAttach) {
            String fragState;
            block41: {
                int idx;
                sb.append("\nvar ").append(this.uniqueID).append("=_F_attach(");
                obj.addMember("title", preferredTitle != null ? preferredTitle : (info != null ? info.getTitle().getString() : null));
                obj.addMember("id", this.uniqueID);
                if (fragmentPath != null && (idx = fragmentPath.indexOf("?")) != -1) {
                    Parameters params;
                    block40: {
                        String urlParams = fragmentPath.substring(idx + 1);
                        fragmentPath = fragmentPath.substring(0, idx + 1);
                        params = Parameters.parse(urlParams);
                        try {
                            env.sign(target, params);
                        }
                        catch (DashboardException e) {
                            if (delayedException != null) break block40;
                            delayedException = e;
                        }
                    }
                    fragmentPath = fragmentPath + params.toString();
                }
                obj.addMember("path", fragmentPath);
                obj.addObjectMember("info");
                obj.addMember("title", info != null ? info.getTitle().getString() : null);
                obj.endObject();
                if (meta != null) {
                    MetaProperty prop;
                    obj.addObjectMember("transientState");
                    Enumeration metaTransients = meta.getTransientProperties();
                    boolean missingTransient = false;
                    while (metaTransients.hasMoreElements()) {
                        prop = (MetaProperty)metaTransients.nextElement();
                        String value = null;
                        if (transients != null) {
                            value = transients.getValue(prop.getName());
                        }
                        if (value == null) {
                            if (parameters != null) {
                                value = parameters.getValue(prop.getName());
                            }
                            if (value == null) {
                                if (prop.getDefault() != null && prop.getDefault().getValue() != null) {
                                    value = prop.getDefault().getValue().getString();
                                }
                                if (value == null) {
                                    value = "";
                                }
                            }
                            if (value.length() > 0) {
                                missingTransient = true;
                            }
                        }
                        try {
                            String name = prop.getName();
                            value = env.sign(target, name, value);
                            obj.addMember(name, value);
                            if (!missingTransient) continue;
                            globalTransients.addTransient(channel, name, value);
                            missingTransient = false;
                        }
                        catch (DashboardException e) {
                            if (delayedException != null) continue;
                            delayedException = e;
                        }
                    }
                    obj.endObject();
                    obj.addArrayMember("transients");
                    metaTransients = meta.getTransientProperties();
                    while (metaTransients.hasMoreElements()) {
                        prop = (MetaProperty)metaTransients.nextElement();
                        obj.addValue(prop.getName());
                    }
                    obj.endArray();
                    obj.addArrayMember("modes");
                    Enumeration modes = meta.getModes();
                    while (modes.hasMoreElements()) {
                        String mode = (String)modes.nextElement();
                        obj.addValue(mode);
                    }
                    obj.endArray();
                    obj.addArrayMember("windowStates");
                    Enumeration windowStates = meta.getWindowStates();
                    while (windowStates.hasMoreElements()) {
                        String windowState = (String)windowStates.nextElement();
                        obj.addValue(windowState);
                    }
                    obj.endArray();
                }
                if (customs != null) {
                    try {
                        obj.addMember("custom", env.sign(target, "frag-custom", DashboardDocument.encodeCustoms(customs)));
                    }
                    catch (DashboardException e) {
                        if (delayedException != null) break block41;
                        delayedException = e;
                    }
                }
            }
            if (newWindowState != null) {
                obj.addMember("windowState", newWindowState);
            } else if (parameters != null && parameters.getValue("frag-windowState") != null) {
                obj.addMember("windowState", parameters.getValue("frag-windowState"));
            } else if (fragmentPath.indexOf("frag-windowState") > -1) {
                String urlParams = fragmentPath.substring(fragmentPath.indexOf("?") + 1);
                Parameters parms = Parameters.parse(urlParams);
                obj.addMember("windowState", parms.getValue("frag-windowState"));
            }
            if (newMode != null) {
                obj.addMember("mode", newMode);
            } else if (parameters != null && parameters.getValue("frag-mode") != null) {
                obj.addMember("mode", parameters.getValue("frag-mode"));
            } else if (fragmentPath.indexOf("frag-mode") > -1) {
                String urlParams = fragmentPath.substring(fragmentPath.indexOf("?") + 1);
                Parameters parms = Parameters.parse(urlParams);
                obj.addMember("mode", parms.getValue("frag-mode"));
            }
            if (isPage) {
                obj.addMember("page", true);
            }
            if (state != null) {
                obj.addMember("state", env.sign(target, "frag-state", state));
            } else if (parameters != null && (fragState = parameters.getValue("frag-state")) != null) {
                obj.addMember("state", env.sign(target, "frag-state", fragState));
            }
            Validator validator = env.getValidationDocument(target, null);
            if (validator != null) {
                String remote = validator.getCompiledString();
                String client = validator.getClientValidationData();
                obj.addObjectMember("validator");
                obj.addMember("remote", remote);
                obj.addScriptMember("client", client);
                obj.endObject();
            }
        } else {
            sb.append("\n").append(this.uniqueID).append(".attach(");
        }
        if (channel != null) {
            obj.addMember("channel", channel);
        }
        obj.write(sb);
        sb.append(");\n</script>\n");
        xsw.writeCharacters(sb.toString());
        if (delayedException != null) {
            throw delayedException;
        }
    }
}

