/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server;

import com.cognos.portal.utils.JSONObject;
import com.cognos.portal.utils.Parameters;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FragmentTransients {
    private Map<String, Parameters> transients = new HashMap<String, Parameters>();
    private Parameters globalTransients = null;

    public synchronized Parameters getTransientsCopy(String channel) {
        Parameters copy = null;
        Parameters transientsParams = this.transients.get(channel);
        if (transientsParams != null) {
            copy = new Parameters();
            copy.addAll((Collection)transientsParams);
        }
        return copy;
    }

    public synchronized Parameters getTransientsCopy() {
        Parameters copy = null;
        Parameters params = this.getGlobalTransients();
        if (params != null) {
            copy = new Parameters();
            copy.addAll((Collection)params);
        }
        return copy;
    }

    private Parameters getGlobalTransients() {
        if (this.globalTransients == null) {
            this.buildGlobalTransients();
        }
        return this.globalTransients;
    }

    private void buildGlobalTransients() {
        this.globalTransients = new Parameters();
        for (Map.Entry<String, Parameters> entry : this.transients.entrySet()) {
            String channel = entry.getKey();
            Parameters params = entry.getValue();
            if (params == null) continue;
            for (Parameters.NameValuePair nvp : params) {
                this.globalTransients.add(nvp.getName() + "[" + channel + "]", nvp.getValue());
            }
        }
    }

    public synchronized boolean addTransient(String name, String value) {
        int index;
        if (name.endsWith("]") && (index = name.lastIndexOf(91)) != -1) {
            String transientName = name.substring(0, index);
            String channel = name.substring(index + 1, name.length() - 1);
            this.addTransient(channel, transientName, value);
        }
        return false;
    }

    public synchronized void addTransient(String channel, String name, String value) {
        Parameters parameters;
        if (channel == null) {
            channel = "";
        }
        if ((parameters = this.transients.get(channel)) == null) {
            parameters = new Parameters();
            this.transients.put(channel, parameters);
        }
        parameters.setValue(name, value);
        if (this.globalTransients != null) {
            this.globalTransients.add(name + "[" + channel + "]", value);
        }
    }

    public synchronized void writeTransientsToJSON(JSONObject json) {
        Parameters globalTransients = this.getGlobalTransients();
        for (Parameters.NameValuePair nvp : globalTransients) {
            json.addMember(nvp.getName(), nvp.getValue());
        }
    }
}

