/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server;

import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.util.Locale;
import javax.xml.stream.XMLStreamReader;

public class SOAPFaultException
extends DashboardException {
    private static final long serialVersionUID = 1L;
    private String message = null;
    private StringBuffer details = null;
    private boolean parsed = false;

    public SOAPFaultException(String message, SOAPFault rootCause) {
        super(message, rootCause);
    }

    public SOAPFaultException(String key, Object[] args, SOAPFault rootCause) {
        super(key, args, rootCause);
    }

    @Override
    public String getLocalizedMsgString(Locale locale) {
        this.parseError(locale);
        return this.message != null ? this.message : "";
    }

    public String getDetails() {
        return this.details != null ? this.details.toString() : "";
    }

    private void parseError(Locale locale) {
        block11: {
            try {
                if (this.parsed) {
                    return;
                }
                this.parsed = true;
                SOAPFault soapFault = (SOAPFault)this.getRootCause();
                String soapDetails = soapFault.getDetail();
                int level = 0;
                XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader(new StringReader(soapDetails));
                if (!StaxUtils.moveToElement("message", reader)) break block11;
                String message = null;
                int event = reader.getEventType();
                while (reader.hasNext()) {
                    if (event == 1) {
                        if ("messageString".equals(reader.getLocalName())) {
                            message = reader.getElementText();
                            if (this.message == null) {
                                this.message = message;
                            } else {
                                if (this.details == null) {
                                    this.details = new StringBuffer();
                                }
                                this.details.append(message);
                            }
                        }
                        ++level;
                    } else if (event == 2 && --level < 0) break;
                    event = reader.next();
                }
            }
            catch (Throwable e) {
                this.message = MessagesManager.getInstance().getMessage(locale, "pf.common.soapfault.parse.error");
            }
        }
    }
}

