/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.meta.ScriptLibrary;
import com.cognos.portal.fragment.meta.StyleLink;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.FragmentTransients;
import com.cognos.portal.fragment.server.document.IRestrictedDocument;
import com.cognos.portal.fragment.server.document.NonThreadSafeRestrictedDocument;
import com.cognos.portal.fragment.server.rewriters.IDashboardURLRewriter;
import com.cognos.portal.fragment.server.rewriters.URLRewriteException;
import com.cognos.portal.fragment.server.rewriters.URLRewriter;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.MultiBufferOutputStream;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class DashboardDocument {
    private static final int MAX_FRAGMENT_DEPTH = 20;
    protected DashboardContext context;
    protected XMLStreamReader reader;
    protected Environment env;
    protected Parameters parameters;
    protected Info info;
    protected Parameters customs;
    protected Parameters transients;
    protected ServiceLogger logger;
    protected String id;
    protected String target;
    protected String newWindowState;
    protected String newMode;
    protected String state;
    protected String preferredTitle;
    protected IRestrictedDocument parent;
    private Map buffers;
    private List libraries;
    private List styles;
    protected boolean includeControllerCode;
    private FragmentTransients requestGlobalTransients;
    protected IRestrictedDocument restrictedDocument;
    protected boolean isThrowInvalidCredentionFault = false;
    private int controllerScriptBuffer = -1;
    private int markupBuffer = -1;

    protected DashboardDocument(XMLStreamReader reader, DashboardContext context, Environment env, String target, String id, IRestrictedDocument parent, Info info, Parameters customs, Parameters parameters, ServiceLogger logger) {
        this.context = context;
        this.reader = reader;
        this.env = env;
        this.target = target;
        this.parent = parent;
        this.info = info;
        this.customs = customs;
        this.parameters = parameters;
        this.state = null;
        ServiceLogger serviceLogger = this.logger = logger != null ? logger.cloneForClass(DashboardDocument.class) : null;
        if (id == null) {
            if (target != null) {
                String temp = target;
                int i = temp.indexOf(63);
                if (i >= 0) {
                    temp = temp.substring(0, i);
                }
                if ((i = temp.lastIndexOf(47)) >= 0) {
                    temp = temp.substring(i + 1);
                }
                this.id = this.generateIdFromValue(temp);
            }
        } else {
            this.id = this.generateIdFromValue(id);
        }
    }

    private String generateIdFromValue(String value) {
        return value.replaceAll("[^0-9a-zA-Z]", "_");
    }

    public abstract void writeXML(XMLTransactionalStreamWriter var1) throws DashboardException, XMLStreamException;

    public abstract void writeHTML(MultiBufferOutputStream var1, boolean var2, String var3) throws DashboardException, XMLStreamException;

    public void writeDocument(XMLTransactionalStreamWriter xsw) throws DashboardException, XMLStreamException {
        StaxUtils.copyCurrentElement(this.reader, xsw);
    }

    public static Parameters decodeCustoms(String value) {
        String decodedValue;
        if (value != null && !(decodedValue = new String(EncodingUtils.base64decode(value, true))).startsWith("<param")) {
            return Parameters.parse(decodedValue);
        }
        return null;
    }

    protected String getTarget() throws DashboardException {
        if (this.target.indexOf("://") != -1) {
            String signed = EncodingUtils.urlencode(this.env.getValidationManager().staticSign(this.target), "UTF-8", false);
            return "?frag-producer=" + signed;
        }
        if ("/pagelet".equals(this.target) && this.env.getParameter("path") != null) {
            this.target = this.target + "?path=" + EncodingUtils.urlencode(this.env.getParameter("path"), "UTF-8", true);
        }
        return this.target;
    }

    protected IRestrictedDocument getParent() {
        return this.parent;
    }

    protected String getID() {
        return this.id;
    }

    protected String getUniqueID() {
        String parentID;
        if (this.parent != null && (parentID = this.parent.getUniqueID()) != null) {
            return parentID + this.id;
        }
        return this.id;
    }

    protected int getBufferForFragID(String fragID) {
        if (this.buffers == null && this.parent != null) {
            return this.parent.getBufferForFragID(fragID);
        }
        if (this.buffers != null) {
            Object obj = this.buffers.get(fragID);
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            if (obj instanceof String && (obj = this.buffers.get(obj)) instanceof Integer) {
                return (Integer)obj;
            }
        }
        return -1;
    }

    protected String getFragIDForSubfragmentID(String subfragmentID) {
        Object obj;
        if (this.buffers == null && this.parent != null) {
            return this.parent.getFragIDForSubfragmentID(subfragmentID);
        }
        if (this.buffers != null && (obj = this.buffers.get(subfragmentID)) instanceof String) {
            return (String)obj;
        }
        return subfragmentID;
    }

    protected void addSubfragmentBuffers(Map map) {
        if (map == null) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = new HashMap();
        }
        this.buffers.putAll(map);
    }

    protected final void addLibrary(ScriptLibrary library) {
        if (this.parent != null) {
            this.parent.addLibrary(library);
        } else {
            if (this.libraries == null) {
                this.libraries = new ArrayList();
            }
            if (!this.libraries.contains(library)) {
                this.addLibrarySplit(library);
            }
        }
    }

    protected final void insertLibrary(ScriptLibrary library, int index) {
        if (this.parent != null) {
            this.parent.insertLibrary(library, index);
        } else {
            int pos;
            Object obj;
            if (this.libraries == null) {
                this.libraries = new ArrayList();
            }
            if ((obj = (pos = this.libraries.indexOf(library)) > index ? this.libraries.remove(pos) : (pos == -1 ? library : null)) != null) {
                this.insertLibrarySplit(index, (ScriptLibrary)obj);
            }
        }
    }

    private Boolean isDebug(ScriptLibrary library) {
        String libHref = library.getHref();
        String debugParam = this.env.getParameter("frag-debug");
        return debugParam != null && libHref.endsWith("cps.core.js");
    }

    private void addLibrarySplit(ScriptLibrary library) {
        if (this.isDebug(library).booleanValue()) {
            String libHref = library.getHref();
            String libType = library.getType();
            this.libraries.add(new ScriptLibrary(libType, libHref.replace("cps.core.js", "fragments.js")));
            this.libraries.add(new ScriptLibrary(libType, libHref.replace("cps.core.js", "uicommon.js")));
            this.libraries.add(new ScriptLibrary(libType, libHref.replace("cps.core.js", "layout.js")));
        } else {
            this.libraries.add(library);
        }
    }

    private void insertLibrarySplit(int index, ScriptLibrary library) {
        if (index > this.libraries.size()) {
            this.addLibrarySplit(library);
        } else if (this.isDebug(library).booleanValue()) {
            String libHref = library.getHref();
            String libType = library.getType();
            this.libraries.add(index, new ScriptLibrary(libType, libHref.replace("cps.core.js", "fragments.js")));
            this.libraries.add(index, new ScriptLibrary(libType, libHref.replace("cps.core.js", "uicommon.js")));
            this.libraries.add(index, new ScriptLibrary(libType, libHref.replace("cps.core.js", "layout.js")));
        } else {
            this.libraries.add(index, library);
        }
    }

    public Iterator getLibraries() {
        if (this.parent != null) {
            return this.parent.getLibraries();
        }
        if (this.libraries != null) {
            return this.libraries.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected void addStyleLink(StyleLink css) {
        if (this.parent != null) {
            this.parent.addStyleLink(css);
        } else {
            if (this.styles == null) {
                this.styles = new ArrayList();
            }
            if (!this.styles.contains(css)) {
                this.styles.add(css);
            }
        }
    }

    public Iterator getStyleLinks() {
        if (this.parent != null) {
            return this.parent.getStyleLinks();
        }
        if (this.styles != null) {
            return this.styles.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public FragmentTransients getRequestGlobalTransients() {
        return this.requestGlobalTransients;
    }

    public void setRequestGlobalTransients(FragmentTransients globalTransients) {
        this.requestGlobalTransients = globalTransients;
    }

    public void setTransients(Parameters transients) {
        this.transients = transients;
    }

    protected Parameters readCustomXML() throws XMLStreamException {
        Parameters customs = new Parameters();
        Parameters.NameValuePair param = null;
        ByteArrayOutputStream memoryXML = null;
        XMLStreamWriter xsw = null;
        StringBuffer buffer = null;
        int level = 0;
        int event = this.reader.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if ("param".equals(this.reader.getLocalName())) {
                        param = customs.add(this.reader.getAttributeValue("", "name"), (String)null);
                        memoryXML = null;
                        xsw = null;
                        buffer = null;
                    } else if (param != null) {
                        if (xsw == null) {
                            memoryXML = new ByteArrayOutputStream(1024);
                            xsw = XMLStreamFactory.createXMLStreamWriter(memoryXML);
                        } else {
                            xsw = XMLStreamFactory.createXMLStreamWriter(memoryXML);
                        }
                        StaxUtils.copyCurrentElement(this.reader, xsw);
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level < 0) {
                        return customs;
                    }
                    if (!"param".equals(this.reader.getLocalName())) break;
                    if (memoryXML != null) {
                        param.setName(param.getName() + ".xml");
                        param.setValue(EncodingUtils.base64encode(memoryXML.toByteArray(), true));
                    } else if (buffer != null) {
                        param.setValue(buffer.toString());
                    } else {
                        param.setValue("");
                    }
                    param = null;
                    break;
                }
                case 4: 
                case 12: {
                    if (param == null) break;
                    if (buffer == null) {
                        buffer = new StringBuffer();
                    }
                    buffer.append(this.reader.getText());
                }
            }
            event = this.reader.next();
        }
        return null;
    }

    protected void writeTransientXML(XMLTransactionalStreamWriter xsw) throws XMLStreamException, DashboardException {
        xsw.writeStartElement("transientUpdate");
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            xsw.writeAttribute(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
        }
        String name = this.reader.getAttributeValue("", "name");
        String value = this.reader.getElementText();
        xsw.writeCharacters(this.env.sign(this.target, name, value));
        xsw.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rewriteFragmentMarkup(XMLTransactionalStreamWriter xsw, char[] markup, URLRewriter rewriter, IDashboardURLRewriter handler, Meta meta) throws XMLStreamException, URLRewriteException, DashboardException {
        int previous = -1;
        this.markupBuffer = this.getBufferForFragID(this.getID());
        xsw.writeCharacters("");
        xsw.flush();
        if (this.markupBuffer != -1) {
            previous = xsw.getInternalBuffers().getActiveBuffer();
            xsw.getInternalBuffers().setActiveBuffer(this.markupBuffer);
        } else {
            this.markupBuffer = xsw.getInternalBuffers().createBuffer(4096);
        }
        this.controllerScriptBuffer = this.markupBuffer;
        this.markupBuffer = xsw.getInternalBuffers().createBuffer(4096);
        try {
            handler.resetScripts();
            rewriter.rewrite(markup, 0, markup.length, xsw);
            if (handler.isAdditionalScripts()) {
                xsw.writeCharacters("<script type=\"text/javascript\">\n");
                xsw.writeCharacters(handler.getAdditionalScripts());
                xsw.writeCharacters("</script>\n");
            }
        }
        finally {
            if (previous != -1) {
                xsw.flush();
                xsw.getInternalBuffers().setActiveBuffer(previous);
            }
            this.addSubfragmentBuffers(handler.getSubfragmentBuffers());
        }
    }

    protected void flushControllerScripts(XMLTransactionalStreamWriter xsw, IDashboardURLRewriter handler, Meta meta) throws XMLStreamException, DashboardException {
        if (this.controllerScriptBuffer != -1) {
            int previous = xsw.getInternalBuffers().getActiveBuffer();
            try {
                xsw.writeCharacters("");
                xsw.flush();
                xsw.getInternalBuffers().setActiveBuffer(this.controllerScriptBuffer);
                handler.writeControllerScripts(xsw, this.getTarget(), this.getUniqueID(), this.info, meta, this.parameters, this.customs, this.transients, this.target, this.env, false, this.newWindowState, this.newMode, this.preferredTitle, this.state, this.includeControllerCode(), this.getRequestGlobalTransients());
            }
            catch (DashboardException e) {
                xsw.getInternalBuffers().discardBuffer(this.markupBuffer);
                if (previous == this.markupBuffer) {
                    previous = -1;
                }
                throw e;
            }
            finally {
                this.controllerScriptBuffer = -1;
                if (previous != -1) {
                    xsw.flush();
                    xsw.getInternalBuffers().setActiveBuffer(previous);
                }
            }
        }
    }

    protected void writeSingleLayout(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("layout");
        xsw.writeStartElement("row");
        xsw.writeStartElement("column");
        xsw.writeAttribute("width", "100%");
        xsw.writeStartElement("fragment");
        xsw.writeAttribute("refid", this.getUniqueID());
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    public static String encodeCustoms(Parameters parameters) {
        if (parameters != null) {
            try {
                return EncodingUtils.base64encode(parameters.toString().getBytes("UTF-8"), true);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected boolean includeControllerCode() {
        if (this.includeControllerCode) {
            return this.includeControllerCode;
        }
        if (this.parent != null) {
            return this.parent.includeControllerCode();
        }
        return false;
    }

    public void EnableIncludeControllerCode() {
        this.includeControllerCode = true;
    }

    protected void checkRecursion() throws DashboardException {
        int stateIdentifier = this.getFragmentStateIdentifier();
        IRestrictedDocument parentDoc = this.getParent();
        int counter = 0;
        while (parentDoc != null) {
            int parentStateIdentifer = parentDoc.getFragmentStateIdentifier();
            if (parentStateIdentifer == stateIdentifier) {
                throw new DashboardException("pf.fragment.server.circularreference");
            }
            if (counter > 20) {
                throw new DashboardException("pf.fragment.server.maxdepthreached", new String[]{String.valueOf(20)});
            }
            parentDoc = parentDoc.getParent();
            ++counter;
        }
    }

    protected int getFragmentStateIdentifier() {
        StringBuffer fragmentState = new StringBuffer();
        fragmentState.append(this.target);
        if (this.parameters != null) {
            fragmentState.append("\n");
            boolean more = false;
            for (Parameters.NameValuePair nvp : this.parameters) {
                if ("frag-id".equals(nvp.getName())) continue;
                String[] values = nvp.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (more) {
                        fragmentState.append('&');
                    }
                    fragmentState.append(nvp.getName());
                    fragmentState.append('=');
                    if (values[i] != null) {
                        fragmentState.append(EncodingUtils.urlencode(values[i], "UTF-8", true));
                    }
                    more = true;
                }
            }
        }
        if (this.customs != null) {
            fragmentState.append("\n").append(this.customs.toString());
        }
        return fragmentState.toString().hashCode();
    }

    protected Parameters getParameters() {
        return this.parameters;
    }

    protected Info getInfo() {
        return this.info;
    }

    public static String getChannelFromCustoms(Parameters customs, Validator validator) throws DashboardException {
        String channel = null;
        if (validator != null) {
            boolean isChannelSupported;
            boolean bl = isChannelSupported = validator.isParameter("channel") || validator.isParameter("commChannel");
            if (isChannelSupported) {
                if (customs != null && (channel = customs.getValue("channel")) == null) {
                    channel = customs.getValue("viewerChannel");
                    if (channel == null && !"global".equals(customs.getValue("commType"))) {
                        channel = customs.getValue("commChannel");
                    }
                    if (channel != null) {
                        customs.add("channel", channel);
                    }
                }
                if (channel == null) {
                    channel = "";
                }
            }
        }
        return channel;
    }

    protected void updateChannel(Validator validator) throws DashboardException {
        String newChannel = DashboardDocument.getChannelFromCustoms(this.customs, validator);
        if (newChannel != null) {
            this.parameters.setValue("frag-channel", newChannel);
        }
    }

    protected boolean hasAncestor(List ancestors) {
        boolean hasAncestor = false;
        for (IRestrictedDocument parentDoc = this.getParent(); parentDoc != null && !hasAncestor; parentDoc = parentDoc.getParent()) {
            hasAncestor = ancestors.contains(parentDoc.getDocumentClass());
        }
        return hasAncestor;
    }

    protected IRestrictedDocument getRestrictedDocument() {
        if (this.restrictedDocument == null) {
            this.restrictedDocument = new NonThreadSafeRestrictedDocument(this);
        }
        return this.restrictedDocument;
    }

    public void setThrowInvalidCredentionFault(boolean isThrowException) {
        this.isThrowInvalidCredentionFault = isThrowException;
    }
}

