/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.DashboardURLRewriterImpl;
import com.cognos.portal.fragment.server.FragmentTransients;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.document.ErrorDocument;
import com.cognos.portal.fragment.server.document.FragmentDocument;
import com.cognos.portal.fragment.server.document.FragmentReferenceDocument;
import com.cognos.portal.fragment.server.document.IDocumentFactory;
import com.cognos.portal.fragment.server.document.IRestrictedDocument;
import com.cognos.portal.fragment.server.document.PageDocument;
import com.cognos.portal.fragment.server.rewriters.IDashboardURLRewriter;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DocumentFactoryImpl
implements IDocumentFactory {
    @Override
    public DashboardDocument createDocument(DashboardContext context, Environment env, String target, String id, IRestrictedDocument parent, Info info, Parameters customs, Parameters parameters, ServiceLogger logger) {
        try {
            if (target != null) {
                String name;
                String resolvedTarget;
                FragmentTransients globalTransients = parent == null ? this.extractTransients(parameters) : parent.getRequestGlobalTransients();
                Validator validator = this.getValidator(env, target, parameters);
                String channel = this.getChannel(validator, parameters, parent, customs);
                Parameters transients = this.getTransients(validator, globalTransients.getTransientsCopy(channel));
                if (parameters == null) {
                    parameters = new Parameters();
                }
                parameters.setValue("frag-channel", channel);
                if (transients != null) {
                    parameters.add(transients);
                }
                Parameters requestParams = new Parameters();
                requestParams.add(parameters);
                requestParams.add(customs);
                String mode = env.getParameter("frag-mode");
                if (mode != null && mode.equals(env.getParameter("frag-delegate"))) {
                    String curTarget = env.getRoutingInfo(target);
                    requestParams.add("frag-originaltarget", target);
                    requestParams.add("frag-target", curTarget);
                    requestParams.add("frag-application", (String)env.getProperty("application"));
                    resolvedTarget = "/delegate/" + mode;
                } else {
                    resolvedTarget = target;
                }
                env.verify(target, parameters, true);
                String routingResovled = env.getRoutingInfo(resolvedTarget);
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug("DocumentFactory::createDocument - Getting document for target '" + resolvedTarget + "'");
                    logger.debug("DocumentFactory::createDocument - Resolved target is '" + routingResovled + "'");
                    logger.debug("DocumentFactory::createDocument - Request Parameters are '" + requestParams.toString() + "'");
                }
                InputStream input = env.getTargetStream(routingResovled, requestParams);
                XMLStreamReader reader = null;
                DashboardDocument document = null;
                if (input != null) {
                    reader = XMLStreamFactory.createXMLStreamReader(input);
                    int event = reader.getEventType();
                    while (reader.hasNext()) {
                        if (event == 1) {
                            String localName = reader.getLocalName();
                            if ("fragment".equals(localName)) {
                                document = new FragmentDocument(context, reader, env, target, id, parent, info, customs, parameters, logger);
                                break;
                            }
                            if ("fragmentReference".equals(localName)) {
                                document = new FragmentReferenceDocument(context, reader, env, target, id, parent, info, customs, parameters, logger);
                                break;
                            }
                            if (!"page".equals(localName)) break;
                            document = new PageDocument(context, reader, env, target, id, parent, info, customs, parameters, logger);
                            break;
                        }
                        event = reader.next();
                    }
                }
                if (document != null) {
                    document.setTransients(transients);
                    document.setRequestGlobalTransients(globalTransients);
                    return document;
                }
                String string = name = reader != null ? reader.getLocalName() : target;
                if (logger != null && logger.isErrorEnabled()) {
                    Object[] args = new String[]{"<" + name + ">"};
                    logger.error("unrecognized xml document: " + name, new DashboardException("pf.fragment.server.invaliddocument", args));
                }
                throw new DashboardException("pf.fragment.server.notargetdocument");
            }
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("target is null");
            }
            throw new DashboardException("pf.fragment.server.notargetdocument");
        }
        catch (RuntimeException e) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("dashboard runtime exception", e);
            }
            return new ErrorDocument(context, env, target, id, parent, e, logger);
        }
        catch (DashboardException e) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("dashboard exception", e);
            }
            return new ErrorDocument(context, env, target, id, parent, e, logger);
        }
        catch (XMLStreamException e) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("xml stream exception", e);
            }
            return new ErrorDocument(context, env, target, id, parent, e, logger);
        }
    }

    @Override
    public DashboardDocument createErrorDocument(DashboardContext context, Environment env, String target, String id, IRestrictedDocument parent, Throwable ex, ServiceLogger logger) {
        return new ErrorDocument(context, env, target, id, parent, ex, logger);
    }

    @Override
    public IDashboardURLRewriter createDashboardRewriter(String uniqueId, Environment env) {
        return new DashboardURLRewriterImpl(uniqueId, env.getGatewayURI(), env.getApplicationGatewayURI(), env.getWebContent());
    }

    private FragmentTransients extractTransients(Parameters params) {
        FragmentTransients transientsMap = new FragmentTransients();
        for (Parameters.NameValuePair nvp : params) {
            transientsMap.addTransient(nvp.getName(), nvp.getValue());
        }
        return transientsMap;
    }

    private Validator getValidator(Environment env, String target, Parameters parameters) throws DashboardException {
        Validator validator = env.getValidationManager().isValidationEnabled() ? env.getValidationDocument(target, parameters) : null;
        return validator;
    }

    private Parameters getTransients(Validator validator, Parameters globalTransients) throws DashboardException {
        Parameters transients = null;
        if (globalTransients != null) {
            for (Parameters.NameValuePair param : globalTransients) {
                String name = param.getName();
                if (validator == null || !validator.isParameter(name)) continue;
                if (transients == null) {
                    transients = new Parameters();
                }
                transients.setValues(name, param.getValues());
            }
        }
        return transients;
    }

    private String getChannel(Validator validator, Parameters parameters, IRestrictedDocument parent, Parameters customs) throws DashboardException {
        String channel = null;
        if (parameters != null) {
            channel = parameters.getValue("frag-channel");
        }
        if (channel == null) {
            channel = DashboardDocument.getChannelFromCustoms(customs, validator);
        }
        if (channel == null && parent != null) {
            channel = parent.getParameter("frag-channel");
        }
        if (channel == null) {
            channel = "";
        }
        return channel;
    }
}

