/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.document.IDocumentFactory;
import com.cognos.portal.fragment.server.document.IRestrictedDocument;
import com.cognos.portal.fragment.server.document.RequestExecutor;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;

class DocumentRequest
extends RequestExecutor.Request {
    private Environment env;
    private Info info;
    private String id;
    private Parameters customs;
    private DashboardContext context;
    private String target;
    private Parameters parameters;
    private ServiceLogger logger;
    private IRestrictedDocument parent;
    private XMLTransactionalStreamWriter xsw;

    public DocumentRequest(RequestExecutor requestExecutor, DashboardContext context, Environment env, String target, String id, IRestrictedDocument parent, Info info, Parameters customs, Parameters parameters, ServiceLogger logger, XMLTransactionalStreamWriter xsw) {
        super(id, requestExecutor);
        this.context = context;
        this.env = env;
        this.target = target;
        this.id = id;
        this.parent = parent;
        this.info = info;
        this.customs = customs;
        this.parameters = parameters;
        this.logger = logger;
        this.xsw = xsw;
    }

    @Override
    public void runImpl() {
        IDocumentFactory documentFactory = (IDocumentFactory)this.env.getProperty("FragmentDocumentFactory");
        DashboardDocument doc = documentFactory.createDocument(this.context, this.env, this.target, this.id, this.parent, this.info, this.customs, this.parameters, this.logger);
        try {
            this.xsw.begin();
            doc.writeXML(this.xsw);
            this.xsw.commit();
        }
        catch (Throwable e) {
            try {
                this.xsw.rollback();
                doc = documentFactory.createErrorDocument(this.context, this.env, this.target, this.id, this.parent, e, this.logger);
                doc.writeXML(this.xsw);
                this.xsw.flush();
            }
            catch (Exception ee) {
                this.logger.error("An error occured while rendering an error: " + e.getMessage(), ee);
            }
        }
    }
}

