/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.FragmentError;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.meta.MetaLocalizedString;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.document.IDocumentFactory;
import com.cognos.portal.fragment.server.document.IRestrictedDocument;
import com.cognos.portal.fragment.server.document.PageHelpers;
import com.cognos.portal.fragment.server.rewriters.IDashboardURLRewriter;
import com.cognos.portal.fragment.server.rewriters.URLRewriter;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.LocalizableRuntimeException;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.MultiBufferByteArrayOutputStream;
import com.cognos.portal.utils.MultiBufferOutputStream;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriterImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import org.xml.sax.SAXException;

public class ErrorDocument
extends DashboardDocument {
    private Throwable ex;

    protected ErrorDocument(DashboardContext context, Environment env, String target, String id, IRestrictedDocument parent, Throwable ex, ServiceLogger logger) {
        super(null, context, env, target, id, parent, null, null, null, logger);
        this.ex = ex;
    }

    @Override
    public void writeXML(XMLTransactionalStreamWriter xsw) throws DashboardException, XMLStreamException {
        this.writeErrorDetails(xsw);
    }

    @Override
    public void writeHTML(MultiBufferOutputStream out, boolean xmlOnly, String embedingType) throws DashboardException, XMLStreamException {
        block9: {
            XMLTransactionalStreamWriterImpl xswdoc;
            MultiBufferByteArrayOutputStream xmlOut;
            this.includeControllerCode = true;
            if (xmlOnly) {
                xmlOut = null;
                xswdoc = new XMLTransactionalStreamWriterImpl(out);
            } else {
                xmlOut = new MultiBufferByteArrayOutputStream(4096);
                xswdoc = new XMLTransactionalStreamWriterImpl(xmlOut);
            }
            this.id = "Page0000Frag0000";
            xswdoc.writeStartDocument();
            xswdoc.writeStartElement("root");
            PageHelpers.writeGlobalSettings(xswdoc, this.env, true);
            PageHelpers.writeUserInfo(xswdoc, this.env);
            StaxUtils.writeTextElement(xswdoc, "id", "Page0000");
            StaxUtils.writeTextElement(xswdoc, "path", this.getTarget());
            this.writeSingleLayout(xswdoc);
            this.writeErrorDetails(xswdoc);
            PageHelpers.writeApplication(xswdoc, this.context, this.env, this);
            xswdoc.writeEndElement();
            xswdoc.writeEndDocument();
            xswdoc.flush();
            if (xmlOut != null) {
                InputStream input = xmlOut.toStream();
                XmlSource source = new XmlSource("", input, true);
                XsltResult result = new XsltResult("", (OutputStream)out, false);
                try {
                    Stylesheet stylesheet = this.context.setupStylesheet("script".equals(embedingType) ? 3 : 1, this.env);
                    stylesheet.transform(source, result);
                }
                catch (LocalizableException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("could not parse the stylesheet", e);
                    }
                }
                catch (SAXException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("encountered a SAX exception", e);
                    }
                }
                catch (IOException e) {
                    if (this.logger == null || !this.logger.isErrorEnabled()) break block9;
                    this.logger.error("encountered an IO exception", e);
                }
            }
        }
    }

    @Override
    public void writeDocument(XMLTransactionalStreamWriter xsw) throws DashboardException, XMLStreamException {
        this.writeErrorDetails(xsw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrorDetails(XMLTransactionalStreamWriter xsw) throws XMLStreamException, DashboardException {
        FragmentError error;
        xsw.writeStartElement("fragment");
        StaxUtils.writeTextElement(xsw, "id", this.getUniqueID());
        if (this.info == null) {
            this.info = new Info();
            MetaLocalizedString value = new MetaLocalizedString();
            value.setString("Error!");
            this.info.setTitle(value);
        }
        this.info.write(xsw);
        if (this.ex != null) {
            String msg;
            String code;
            int index;
            Throwable checkException = this.ex;
            while (checkException != null && !(checkException instanceof InvalidCredentialsFault)) {
                if (checkException instanceof LocalizableException) {
                    checkException = ((LocalizableException)checkException).getRootCause();
                    continue;
                }
                if (checkException instanceof LocalizableRuntimeException) {
                    checkException = ((LocalizableRuntimeException)checkException).getRootCause();
                    continue;
                }
                checkException = null;
            }
            if (checkException == null) {
                checkException = this.ex;
            }
            if ((index = (code = checkException.getClass().getName()).lastIndexOf(46)) != -1) {
                code = code.substring(index + 1);
            }
            if ("InvalidCredentialsFault".equals(code)) {
                code = "invalidCredentials";
            }
            if ((msg = checkException.getMessage()) == null || "".equals(msg)) {
                msg = code;
            }
            StringWriter sw = new StringWriter();
            if (this.env.hasCapabilities("canReceiveDetailedErrors")) {
                Throwable rootCause;
                PrintWriterEx writer = new PrintWriterEx(sw);
                checkException.printStackTrace(writer);
                if (checkException instanceof DashboardException && (rootCause = ((DashboardException)checkException).getRootCause()) != null) {
                    writer.println("\nRoot Cause:");
                    rootCause.printStackTrace(writer);
                }
            }
            error = new FragmentError(code, msg, sw.toString());
        } else {
            error = new FragmentError(null, MessagesManager.getInstance().getMessage(this.env.getProductLocale(), "pf.fragment.server.executionfailed"), null);
        }
        StringBuffer script = new StringBuffer();
        ErrorDocument.buildControllerErrorScript(script, error, this.env);
        IDashboardURLRewriter handler = ((IDocumentFactory)this.env.getProperty("FragmentDocumentFactory")).createDashboardRewriter(this.getUniqueID(), this.env);
        URLRewriter rewriter = new URLRewriter(handler);
        try {
            xsw.writeStartElement("markup");
            xsw.writeStartElement("markupString");
            this.rewriteFragmentMarkup(xsw, script.toString().toCharArray(), rewriter, handler, null);
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
        catch (Throwable t) {
            this.logger.error("exception when writing error script!", t);
        }
        finally {
            this.flushControllerScripts(xsw, handler, null);
        }
        error.write(xsw);
        xsw.writeEndElement();
    }

    static void buildControllerErrorScript(StringBuffer script, FragmentError error, Environment env) {
        error.secureLogDetails(env);
        script.append("<script type=\"text/javascript\">\n_THIS_.setOnloadHandler(function(){_THIS_.processError(\"").append(EncodingUtils.javascriptencode(error.getCode())).append("\", \"").append(EncodingUtils.javascriptencode(error.getMessage())).append("\", \"").append(EncodingUtils.javascriptencode(error.getDetails())).append("\");});\n</script>\n");
    }

    public class PrintWriterEx
    extends PrintWriter {
        public PrintWriterEx(Writer out) {
            super(out);
        }

        @Override
        public void println() {
            super.print('\n');
        }
    }
}

