/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Delay;
import com.cognos.portal.fragment.meta.FragmentError;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.meta.MetaLocalizedString;
import com.cognos.portal.fragment.meta.MetaProperty;
import com.cognos.portal.fragment.meta.ScriptLibrary;
import com.cognos.portal.fragment.meta.StyleLink;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.document.ErrorDocument;
import com.cognos.portal.fragment.server.document.IDocumentFactory;
import com.cognos.portal.fragment.server.document.IRestrictedDocument;
import com.cognos.portal.fragment.server.document.PageDocument;
import com.cognos.portal.fragment.server.document.PageHelpers;
import com.cognos.portal.fragment.server.rewriters.IDashboardURLRewriter;
import com.cognos.portal.fragment.server.rewriters.URLRewriteException;
import com.cognos.portal.fragment.server.rewriters.URLRewriter;
import com.cognos.portal.fragment.validation.Validator;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.MultiBufferByteArrayOutputStream;
import com.cognos.portal.utils.MultiBufferOutputStream;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.PipelineFactory;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriterImpl;
import com.ibm.cognos.i18n.util.Bidi;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import org.xml.sax.SAXException;

public class FragmentDocument
extends DashboardDocument {
    private static final List<Class> PAGE_ANCESTOR_LIST = new ArrayList<Class>(1);
    private static final List<Class> PAGE_FRAGMENT_ANCESTOR_LIST = new ArrayList<Class>(1);
    private Meta meta = null;

    protected FragmentDocument(DashboardContext context, XMLStreamReader reader, Environment env, String target, String id, IRestrictedDocument parent, Info info, Parameters customs, Parameters parameters, ServiceLogger logger) throws DashboardException {
        super(reader, context, env, target, id, parent, info, customs, parameters, logger);
    }

    @Override
    public void writeXML(XMLTransactionalStreamWriter xsw) throws DashboardException, XMLStreamException {
        if ("attach".equals(this.parameters.getValue("frag-action"))) {
            this.includeControllerCode = true;
        }
        this.writeFragment(xsw);
    }

    @Override
    public void writeHTML(MultiBufferOutputStream out, boolean xmlOnly, String embedingType) throws DashboardException, XMLStreamException {
        block9: {
            XMLTransactionalStreamWriterImpl xswdoc;
            MultiBufferByteArrayOutputStream xmlOut;
            if (xmlOnly) {
                xmlOut = null;
                xswdoc = new XMLTransactionalStreamWriterImpl(out);
            } else {
                xmlOut = new MultiBufferByteArrayOutputStream(4096);
                xswdoc = new XMLTransactionalStreamWriterImpl(xmlOut);
            }
            this.id = "Page0000Frag0000";
            this.includeControllerCode = true;
            xswdoc.writeStartDocument();
            xswdoc.writeStartElement("root");
            PageHelpers.writeGlobalSettings(xswdoc, this.env, true);
            PageHelpers.writeUserInfo(xswdoc, this.env);
            StaxUtils.writeTextElement(xswdoc, "id", "Page0000");
            StaxUtils.writeTextElement(xswdoc, "path", this.getTarget());
            this.writeSingleLayout(xswdoc);
            this.writeFragment(xswdoc);
            PageHelpers.writeApplication(xswdoc, this.context, this.env, this);
            xswdoc.writeEndElement();
            xswdoc.writeEndDocument();
            xswdoc.flush();
            if (xmlOut != null) {
                InputStream input = xmlOut.toStream();
                XmlSource source = new XmlSource("", input, true);
                XsltResult result = new XsltResult("", (OutputStream)out, false);
                try {
                    Stylesheet stylesheet = this.context.setupStylesheet("script".equals(embedingType) ? 3 : 1, this.env);
                    stylesheet.transform(source, result);
                }
                catch (LocalizableException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("could not parse the stylesheet", e);
                    }
                }
                catch (SAXException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("encountered a SAX exception", e);
                    }
                }
                catch (IOException e) {
                    if (this.logger == null || !this.logger.isErrorEnabled()) break block9;
                    this.logger.error("encountered an IO exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFragment(XMLTransactionalStreamWriter xsw) throws XMLStreamException, DashboardException {
        boolean wroteCustomUpdate = false;
        String action = null;
        if (this.parameters != null) {
            action = this.parameters.getValue("frag-action");
        }
        this.checkRecursion();
        IDocumentFactory documentFactory = (IDocumentFactory)this.env.getProperty("FragmentDocumentFactory");
        String uniqueID = this.getUniqueID();
        IDashboardURLRewriter handler = documentFactory.createDashboardRewriter(this.getUniqueID(), this.env);
        URLRewriter rewriter = new URLRewriter(handler);
        Delay delay = null;
        FragmentError error = null;
        boolean foundMarkup = false;
        String fragMarkupID = this.env.getParameter("frag-markupid");
        Validator validator = null;
        boolean validatorSet = false;
        try {
            int event = this.reader.getEventType();
            while (event != 8) {
                switch (event) {
                    case 1: {
                        String localName = this.reader.getLocalName();
                        if ("customUpdate".equals(localName)) {
                            validatorSet = this.setValidator(validatorSet, validator, handler);
                            String controllerAgent = this.env.getControllerAgent();
                            if ("fragment/1.1.0".equals(controllerAgent)) {
                                StaxUtils.copyCurrentElement(this.reader, xsw);
                                break;
                            }
                            this.customs = this.readCustomXML();
                            this.updateChannel(validator);
                            xsw.writeStartElement(localName);
                            xsw.writeCharacters(this.env.sign(this.target, "frag-custom", FragmentDocument.encodeCustoms(this.customs)));
                            xsw.writeEndElement();
                            wroteCustomUpdate = true;
                            try {
                                Pipeline pipeline = PipelineFactory.getInstance().createPipeline("pipeline://cmProvider", this.env);
                                pipeline.setParam("params", this.parameters);
                                pipeline.setParam("href", this.getTarget());
                                pipeline.setParam("customUpdate", this.customs);
                                pipeline.setParam("meta", this.meta);
                                pipeline.execute();
                                break;
                            }
                            catch (PipelineException e) {
                                throw new DashboardException("pf.fragment.server.executionfailed", e);
                            }
                        }
                        if ("transientUpdate".equals(localName)) {
                            validatorSet = this.setValidator(validatorSet, validator, handler);
                            this.writeTransientXML(xsw);
                            break;
                        }
                        if ("info".equals(localName)) {
                            if (this.info == null) {
                                this.info = new Info();
                                this.info.read(this.reader);
                                break;
                            }
                            StaxUtils.moveToNextSibling(this.reader);
                            break;
                        }
                        if ("meta".equals(localName)) {
                            if (this.env.getValidationManager().isValidationEnabled()) {
                                String bypassAttr = this.reader.getAttributeValue("", "bypassValidation");
                                String validationNS = "true".equals(bypassAttr) ? "urn:cognos:fragments:validator:bypass" : null;
                                validator = this.env.getValidationManager().createValidatorFromNamespace(this.env, validationNS, this.target);
                            }
                            this.meta = new Meta(validator);
                            this.meta.read(this.reader);
                            String requiredCapabilities = this.meta.getRequiredCapabilities();
                            if (!this.env.hasCapabilities(requiredCapabilities)) {
                                throw new DashboardException("pf.fragment.server.notsufficientcapabilities_portlet");
                            }
                            Enumeration customerPropEnum = this.meta.getCustomProperties();
                            while (customerPropEnum.hasMoreElements()) {
                                MetaProperty prop = (MetaProperty)customerPropEnum.nextElement();
                                String name = prop.getName();
                                String xmlname = name + ".xml";
                                if (this.parameters.getValue(name) == null && this.parameters.getValue(xmlname) == null || this.parameters.getValue("frag-id") != null && !this.hasAncestor(PAGE_FRAGMENT_ANCESTOR_LIST)) continue;
                                if (this.logger != null && this.logger.isErrorEnabled()) {
                                    this.logger.error("A custom parameter was found on the url. Custom properties must be passed using frag-custom parameter: " + name + ". Parameters =" + this.parameters.toString());
                                }
                                throw new DashboardException("pf.fragment.validation.verifyfailed");
                            }
                            break;
                        }
                        if ("library".equals(localName)) {
                            PageHelpers.readLibrary(this.reader, this, this.env);
                            StaxUtils.moveToNextSibling(this.reader);
                            break;
                        }
                        if ("css".equals(localName)) {
                            PageHelpers.readCSS(this.reader, this, this.env);
                            StaxUtils.moveToNextSibling(this.reader);
                            break;
                        }
                        if ("state".equals(localName)) {
                            this.state = this.reader.getElementText();
                            break;
                        }
                        if ("delay".equals(localName)) {
                            delay = new Delay();
                            delay.read(this.reader);
                            break;
                        }
                        if ("error".equals(localName)) {
                            error = new FragmentError();
                            error.read(this.reader);
                            break;
                        }
                        if ("markup".equals(localName)) {
                            String id;
                            if (foundMarkup) {
                                StaxUtils.moveToNextSibling(this.reader);
                                break;
                            }
                            if (fragMarkupID != null && !fragMarkupID.equals(id = this.reader.getAttributeValue("", "id"))) {
                                StaxUtils.moveToNextSibling(this.reader);
                                break;
                            }
                            this.writeInfoAndMeta(xsw);
                            foundMarkup = true;
                        } else {
                            if (foundMarkup && "markupXml".equals(localName)) {
                                validatorSet = this.setValidator(validatorSet, validator, handler);
                                SharedByteArrayOutputStream memoryXML = new SharedByteArrayOutputStream(4096);
                                XMLStreamWriter memxsw = XMLStreamFactory.createXMLStreamWriter(memoryXML);
                                StaxUtils.copyCurrentElement(this.reader, memxsw);
                                try {
                                    InputStream input = memoryXML.toStream();
                                    CharArrayWriter out = new CharArrayWriter();
                                    XmlSource source = new XmlSource("", input, true);
                                    XsltResult result = new XsltResult("", (Writer)out, false);
                                    Stylesheet stylesheet = this.context.setupStylesheet(0, this.env);
                                    stylesheet.transform(source, result);
                                    handler.resetScripts();
                                    xsw.writeStartElement("markupString");
                                    this.rewriteFragmentMarkup(xsw, out.toCharArray(), rewriter, handler, this.meta);
                                    xsw.writeEndElement();
                                    break;
                                }
                                catch (Exception e) {
                                    throw new DashboardException("pf.fragment.server.executionfailed", e);
                                }
                            }
                            if ("validator".equals(localName)) {
                                if (this.env.getValidationManager().isValidationEnabled() && validator != null) {
                                    validator.readMarkupValidatorParam(this.reader);
                                    break;
                                }
                                StaxUtils.moveToNextSibling(this.reader);
                                break;
                            }
                        }
                        xsw.writeStartElement(localName);
                        int count = this.reader.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            xsw.writeAttribute(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
                        }
                        if ("fragment".equals(localName)) {
                            StaxUtils.writeTextElement(xsw, "id", uniqueID);
                            break;
                        }
                        if ("menu".equals(localName)) {
                            xsw.writeAttribute("id", uniqueID);
                            break;
                        }
                        if (foundMarkup && "markupString".equals(localName)) {
                            validatorSet = this.setValidator(validatorSet, validator, handler);
                            try {
                                this.rewriteFragmentMarkup(xsw, this.reader.getElementText().toCharArray(), rewriter, handler, this.meta);
                                xsw.writeEndElement();
                                break;
                            }
                            catch (URLRewriteException e) {
                                throw new DashboardException("pf.fragment.server.executionfailed", e);
                            }
                        }
                        if ("action".equals(localName)) {
                            try {
                                char[] markup = this.reader.getElementText().toCharArray();
                                handler.resetScripts();
                                rewriter.rewrite(markup, 0, markup.length, xsw);
                                xsw.writeEndElement();
                                break;
                            }
                            catch (URLRewriteException e) {
                                throw new DashboardException("pf.fragment.server.executionfailed", e);
                            }
                        }
                        if (foundMarkup && "subfragment".equals(localName)) {
                            validatorSet = this.setValidator(validatorSet, validator, handler);
                            String subfragmentID = this.reader.getAttributeValue("", "id");
                            String id = this.getFragIDForSubfragmentID(subfragmentID);
                            String href = this.reader.getAttributeValue("", "href");
                            String subFragmentUniqueId = this.getUniqueID() + id;
                            Parameters subFragmentParams = this.env.getParametersForSubFragment(subFragmentUniqueId);
                            if (subFragmentParams == null) {
                                subFragmentParams = new Parameters();
                            }
                            Parameters subFragmentCustoms = null;
                            int level = 0;
                            while (this.reader.hasNext()) {
                                event = this.reader.next();
                                if (event == 1) {
                                    String subfragLocalName = this.reader.getLocalName();
                                    if ("params".equals(subfragLocalName)) {
                                        this.readSubFragmentParams(this.reader, subFragmentParams);
                                        continue;
                                    }
                                    if ("custom".equals(subfragLocalName)) {
                                        subFragmentCustoms = this.readCustomXML();
                                        continue;
                                    }
                                    ++level;
                                    continue;
                                }
                                if (event != 2 || --level >= 0) continue;
                            }
                            this.env.copyParametersForTarget(href, subFragmentParams);
                            DashboardDocument subfragment = documentFactory.createDocument(this.context, this.env, href, id, this.getRestrictedDocument(), null, subFragmentCustoms, subFragmentParams, this.logger);
                            subfragment.includeControllerCode = true;
                            try {
                                xsw.begin();
                                subfragment.writeXML(xsw);
                                xsw.commit();
                            }
                            catch (Throwable e) {
                                xsw.rollback();
                                DashboardDocument doc = documentFactory.createErrorDocument(this.context, this.env, href, subfragment.getID(), this.getRestrictedDocument(), e, this.logger);
                                doc.writeXML(xsw);
                            }
                            xsw.writeEndElement();
                            break;
                        }
                        if ("newWindowState".equals(localName)) {
                            this.newWindowState = this.reader.getElementText();
                            xsw.writeCharacters(this.newWindowState);
                            xsw.writeEndElement();
                            break;
                        }
                        if ("newMode".equals(localName)) {
                            this.newMode = this.reader.getElementText();
                            xsw.writeCharacters(this.newMode);
                            xsw.writeEndElement();
                            break;
                        }
                        if (!"preferredTitle".equals(localName)) break;
                        this.preferredTitle = this.reader.getElementText();
                        String isBidiEnabled = "false";
                        String textDirection = "auto";
                        String productLocale = "en";
                        if (this.env != null) {
                            if (this.env.getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled") != null) {
                                isBidiEnabled = this.env.getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled");
                            }
                            if (this.env.getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection") != null) {
                                textDirection = this.env.getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection");
                                textDirection = textDirection.substring(textDirection.lastIndexOf("#") + 1).toLowerCase();
                            }
                            if (this.env.getProductLocale() != null) {
                                productLocale = this.env.getProductLocale();
                            }
                        }
                        if ("true".equals(isBidiEnabled)) {
                            this.preferredTitle = Bidi.enforceBTD((String)this.preferredTitle, (String)textDirection, (String)productLocale);
                        }
                        xsw.writeCharacters(this.preferredTitle);
                        xsw.writeEndElement();
                        break;
                    }
                    case 2: {
                        String eeLocalName = this.reader.getLocalName();
                        if ("markup".equals(eeLocalName)) {
                            validatorSet = this.setValidator(validatorSet, validator, handler);
                        } else if ("fragment".equals(eeLocalName)) {
                            validatorSet = this.setValidator(validatorSet, validator, handler);
                            if (!foundMarkup) {
                                StringBuffer sb = new StringBuffer(1024);
                                if (delay != null) {
                                    sb.append("<script type=\"text/javascript\">\n_THIS_.setRefreshDelay(").append(delay.getPeriod()).append(");</script><div><p>");
                                    String msg = delay.getMessage();
                                    if (msg != null && !"".equals(msg)) {
                                        sb.append(msg);
                                    } else {
                                        sb.append("Running...");
                                    }
                                    sb.append("<p></div>");
                                }
                                if (error != null) {
                                    if (this.isThrowInvalidCredentionFault && "invalidCredentials".equals(error.getCode())) {
                                        throw new InvalidCredentialsFault(error.getMessage());
                                    }
                                    ErrorDocument.buildControllerErrorScript(sb, error, this.env);
                                }
                                try {
                                    this.writeInfoAndMeta(xsw);
                                    xsw.writeStartElement("markup");
                                    xsw.writeStartElement("markupString");
                                    this.rewriteFragmentMarkup(xsw, sb.toString().toCharArray(), rewriter, handler, this.meta);
                                    xsw.writeEndElement();
                                    xsw.writeEndElement();
                                }
                                catch (URLRewriteException e) {
                                    throw new DashboardException("pf.fragment.server.executionfailed", e);
                                }
                            }
                            this.flushControllerScripts(xsw, handler, this.meta);
                            if (this.state != null) {
                                StaxUtils.writeTextElement(xsw, "state", this.env.sign(this.target, "frag-state", this.state));
                            }
                            if (delay != null) {
                                delay.write(xsw);
                            }
                            if (validator != null) {
                                xsw.writeStartElement("validator");
                                xsw.writeStartElement("remote");
                                xsw.writeCharacters(validator.getCompiledString());
                                xsw.writeEndElement();
                                xsw.writeStartElement("client");
                                xsw.writeCharacters(validator.getClientValidationData());
                                xsw.writeEndElement();
                                xsw.writeEndElement();
                            }
                            if (!this.hasAncestor(PAGE_ANCESTOR_LIST)) {
                                Iterator it = this.getLibraries();
                                while (it.hasNext()) {
                                    ScriptLibrary lib = (ScriptLibrary)it.next();
                                    lib.write(xsw);
                                }
                                it = this.getStyleLinks();
                                while (it.hasNext()) {
                                    StyleLink css = (StyleLink)it.next();
                                    css.write(xsw);
                                }
                            }
                            if (!wroteCustomUpdate && "reset".equals(action)) {
                                this.updateChannel(validator);
                                xsw.writeStartElement("customUpdate");
                                if (this.customs != null) {
                                    xsw.writeCharacters(this.env.sign(this.target, "frag-custom", FragmentDocument.encodeCustoms(this.customs)));
                                }
                                xsw.writeEndElement();
                                wroteCustomUpdate = true;
                            }
                        }
                        xsw.writeEndElement();
                        break;
                    }
                    case 4: {
                        xsw.writeCharacters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                        break;
                    }
                    case 12: {
                        xsw.writeCData(this.reader.getText());
                    }
                }
                event = this.reader.next();
            }
        }
        finally {
            this.flushControllerScripts(xsw, handler, this.meta);
        }
    }

    private boolean setValidator(boolean validatorSet, Validator validator, IDashboardURLRewriter handler) throws DashboardException {
        if (!validatorSet) {
            if (validator != null) {
                validator.compile();
            }
            this.env.setValidationDocument(this.target, validator);
            handler.setValidationDocument(validator);
            validatorSet = true;
        }
        return validatorSet;
    }

    private void readSubFragmentParams(XMLStreamReader xsr, Parameters subFragmentParams) throws XMLStreamException {
        int level = 0;
        ArrayList<String> parametersFound = new ArrayList<String>();
        while (xsr.hasNext()) {
            int event = xsr.next();
            String localName = null;
            switch (event) {
                case 1: {
                    localName = xsr.getLocalName();
                    if ("param".equals(localName)) {
                        String attributeName = xsr.getAttributeValue("", "name");
                        String elementText = xsr.getElementText();
                        if (parametersFound.contains(attributeName)) {
                            subFragmentParams.add(attributeName, elementText);
                        } else {
                            subFragmentParams.setValue(attributeName, elementText);
                            parametersFound.add(attributeName);
                        }
                        if (level != 0) break;
                        level = 1;
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level <= 0) {
                        return;
                    }
                    localName = xsr.getLocalName();
                }
            }
        }
    }

    private void writeInfoAndMeta(XMLTransactionalStreamWriter xsw) throws XMLStreamException {
        if (this.info == null) {
            this.info = new Info();
            MetaLocalizedString value = new MetaLocalizedString();
            value.setString("Untitled");
            this.info.setTitle(value);
        }
        this.info.write(xsw);
        if (this.meta != null) {
            this.meta.write(xsw);
        }
    }

    static {
        PAGE_ANCESTOR_LIST.add(PageDocument.class);
        PAGE_FRAGMENT_ANCESTOR_LIST.add(FragmentDocument.class);
        PAGE_FRAGMENT_ANCESTOR_LIST.add(PageDocument.class);
    }
}

