/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.SynchronizedEnvironment;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.meta.ScriptLibrary;
import com.cognos.portal.fragment.meta.StyleLink;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.FragmentTransients;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.document.DocumentRequest;
import com.cognos.portal.fragment.server.document.IDocumentFactory;
import com.cognos.portal.fragment.server.document.IRestrictedDocument;
import com.cognos.portal.fragment.server.document.NonThreadSafeRestrictedDocument;
import com.cognos.portal.fragment.server.document.PageHelpers;
import com.cognos.portal.fragment.server.document.RequestExecutor;
import com.cognos.portal.fragment.server.document.ThreadSafeRestrictedDocument;
import com.cognos.portal.fragment.server.rewriters.IDashboardURLRewriter;
import com.cognos.portal.thread.ThreadPool;
import com.cognos.portal.utils.JSONObject;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.MultiBufferByteArrayOutputStream;
import com.cognos.portal.utils.MultiBufferOutputStream;
import com.cognos.portal.utils.NumberUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriterImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;
import org.xml.sax.SAXException;

public class PageDocument
extends DashboardDocument {
    private List fragments;
    private RequestExecutor requestExecutor;
    private int maximumWaitTime;

    protected PageDocument(DashboardContext context, XMLStreamReader reader, Environment env, String target, String id, IRestrictedDocument parent, Info info, Parameters customs, Parameters parameters, ServiceLogger logger) {
        super(reader, context, env, target, id, parent, info, customs, parameters, logger);
        ThreadPool threadPool;
        String version = reader.getAttributeValue("", "version");
        if (!"1.0".equals(version)) {
            // empty if block
        }
        if ((threadPool = (ThreadPool)env.getProperty("portal.threadpool")) != null && !"false".equals((String)env.getProperty("portal.page.concurrentrequests"))) {
            int maxThreads = NumberUtils.parse((String)env.getProperty("portal.page.maxthreadsperpage"), 5);
            int maxQueueWaitTime = NumberUtils.parse((String)env.getProperty("portal.page.maxqueuewaittime"), 120) * 1000;
            this.maximumWaitTime = NumberUtils.parse((String)env.getProperty("portal.page.maxwaittime"), 240) * 1000;
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("Using asynchronous request to render the page:");
                logger.debug("maximum threads per page: " + maxThreads);
                logger.debug("maximum queue wait time: " + maxQueueWaitTime);
                logger.debug("maximum wait time: " + this.maximumWaitTime);
            }
            this.requestExecutor = new RequestExecutor(threadPool, maxThreads, maxQueueWaitTime, logger);
        } else {
            this.requestExecutor = null;
        }
        if (this.requestExecutor != null) {
            this.env = new SynchronizedEnvironment(env);
        }
    }

    @Override
    public void writeXML(XMLTransactionalStreamWriter xsw) throws DashboardException, XMLStreamException {
        MultiBufferByteArrayOutputStream xmlOut = new MultiBufferByteArrayOutputStream(4096);
        MultiBufferByteArrayOutputStream out = new MultiBufferByteArrayOutputStream(4096);
        if (this.processDocument(xmlOut, out, 2, false, false)) {
            xsw.writeStartElement("fragment");
            StaxUtils.writeTextElement(xsw, "id", this.getUniqueID());
            if (this.info != null) {
                this.info.write(xsw);
            }
            xsw.writeStartElement("markup");
            xsw.writeStartElement("markupString");
            int previous = -1;
            int index = this.getBufferForFragID(this.getID());
            if (index != -1) {
                xsw.writeCharacters("");
                xsw.flush();
                previous = xsw.getInternalBuffers().setActiveBuffer(index);
            }
            try {
                IDashboardURLRewriter rewriter = ((IDocumentFactory)this.env.getProperty("FragmentDocumentFactory")).createDashboardRewriter(this.getUniqueID(), this.env);
                rewriter.writeControllerScripts(xsw, this.getTarget(), this.getUniqueID(), this.info, null, this.parameters, this.customs, null, this.target, this.env, true, this.newWindowState, this.newMode, null, null, true, this.getRequestGlobalTransients());
                xsw.writeCData(out.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                xsw.writeCData(out.toString());
            }
            if (previous != -1) {
                xsw.flush();
                xsw.getInternalBuffers().setActiveBuffer(previous);
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            Iterator it = this.getLibraries();
            while (it.hasNext()) {
                ScriptLibrary lib = (ScriptLibrary)it.next();
                lib.write(xsw);
            }
            it = this.getStyleLinks();
            while (it.hasNext()) {
                StyleLink css = (StyleLink)it.next();
                css.write(xsw);
            }
            xsw.writeEndElement();
        }
    }

    @Override
    public void writeHTML(MultiBufferOutputStream out, boolean xmlOnly, String embedingType) throws DashboardException, XMLStreamException {
        MultiBufferByteArrayOutputStream xmlOut = xmlOnly ? null : new MultiBufferByteArrayOutputStream(4096);
        this.processDocument(xmlOut, out, "script".equals(embedingType) ? 3 : 1, true, true);
    }

    private boolean processDocument(MultiBufferByteArrayOutputStream xmlOut, MultiBufferOutputStream out, int whichStylesheet, boolean includeApplication, boolean useFixedLayout) throws DashboardException, XMLStreamException {
        block15: {
            this.includeControllerCode = true;
            XMLTransactionalStreamWriterImpl xswdoc = xmlOut == null ? new XMLTransactionalStreamWriterImpl(out) : new XMLTransactionalStreamWriterImpl(xmlOut);
            xswdoc.writeStartDocument();
            xswdoc.writeStartElement("root");
            this.checkRecursion();
            PageHelpers.writeGlobalSettings(xswdoc, this.env, useFixedLayout);
            PageHelpers.writeUserInfo(xswdoc, this.env);
            StaxUtils.writeTextElement(xswdoc, "id", this.getUniqueID());
            StaxUtils.writeTextElement(xswdoc, "path", this.getTarget());
            this.writePage(xswdoc);
            if (this.requestExecutor != null) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Rendering the page. Waiting for all fragments requests to finish");
                }
                this.requestExecutor.waitForAllRequests(this.maximumWaitTime);
                if (!this.requestExecutor.isFinished()) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("The page waiting time has exceeded the maximum wait setting. This could be due to a fragment that did not return a response in a reasonable time. The maximum wait time is set to '" + this.maximumWaitTime + "'. This can be changed by setting the property '" + "portal.page.maxwaittime" + "'.");
                    }
                } else if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Finished waiting. All fragments requests are complete");
                }
            }
            if (includeApplication) {
                JSONObject globalTransientsJSON = new JSONObject();
                FragmentTransients requestGlobalTransients = this.getRequestGlobalTransients();
                if (requestGlobalTransients != null) {
                    requestGlobalTransients.writeTransientsToJSON(globalTransientsJSON);
                }
                xswdoc.writeStartElement("transientGlobal");
                globalTransientsJSON.write(xswdoc);
                xswdoc.writeEndElement();
                PageHelpers.writeApplication(xswdoc, this.context, this.env, this);
            }
            xswdoc.writeEndElement();
            xswdoc.writeEndDocument();
            xswdoc.flush();
            if (xmlOut != null) {
                InputStream input = xmlOut.toStream();
                XmlSource source = new XmlSource("", input, true);
                XsltResult result = new XsltResult("", (OutputStream)out, false);
                try {
                    Stylesheet stylesheet = this.context.setupStylesheet(whichStylesheet, this.env);
                    stylesheet.transform(source, result);
                }
                catch (LocalizableException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("could not parse the stylesheet", e);
                    }
                }
                catch (SAXException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("encountered a SAX exception", e);
                    }
                }
                catch (IOException e) {
                    if (this.logger == null || !this.logger.isErrorEnabled()) break block15;
                    this.logger.error("encountered an IO exception", e);
                }
            }
        }
        return true;
    }

    private void writePage(XMLTransactionalStreamWriter xsw) throws XMLStreamException, DashboardException {
        int event = this.reader.getEventType();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = this.reader.getLocalName();
                    if ("page".equals(localName)) break;
                    if ("layout".equals(localName)) {
                        this.writeLayout(xsw);
                        break;
                    }
                    if ("info".equals(localName)) {
                        if (this.info == null) {
                            this.info = new Info();
                            this.info.read(this.reader);
                            break;
                        }
                        StaxUtils.moveToNextSibling(this.reader);
                        break;
                    }
                    if ("fragmentInstance".equals(localName)) {
                        this.writeFragmentInstance(xsw);
                        break;
                    }
                    if ("meta".equals(localName)) {
                        Meta meta = new Meta();
                        meta.read(this.reader);
                        String requiredCapabilities = meta.getRequiredCapabilities();
                        if (this.env.hasCapabilities(requiredCapabilities)) break;
                        throw new DashboardException("pf.fragment.server.notsufficientcapabilities_page");
                    }
                    xsw.writeStartElement(localName);
                    int count = this.reader.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        xsw.writeAttribute(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
                    }
                    break;
                }
                case 2: {
                    if ("page".equals(this.reader.getLocalName())) break;
                    xsw.writeEndElement();
                    break;
                }
                case 4: {
                    xsw.writeCharacters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                }
            }
            event = this.reader.next();
        }
    }

    private void writeLayout(XMLStreamWriter xsw) throws XMLStreamException {
        int level = 0;
        String uniqueID = this.getUniqueID();
        int event = this.reader.getEventType();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = this.reader.getLocalName();
                    if ("fragment".equals(localName)) {
                        String guid = this.reader.getAttributeValue("", "refid");
                        this.addFragmentID(guid);
                    }
                    ++level;
                    xsw.writeStartElement(localName);
                    int count = this.reader.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        String name = this.reader.getAttributeLocalName(i);
                        String value = this.reader.getAttributeValue(i);
                        if ("refid".equals(name)) {
                            value = uniqueID + value;
                        }
                        xsw.writeAttribute(name, value);
                    }
                    break;
                }
                case 2: {
                    xsw.writeEndElement();
                    if (--level != 0) break;
                    return;
                }
                case 4: {
                    xsw.writeCharacters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                    break;
                }
                case 12: {
                    xsw.writeCData(this.reader.getText());
                }
            }
            event = this.reader.next();
        }
    }

    private void writeFragmentInstance(XMLTransactionalStreamWriter xsw) throws XMLStreamException, DashboardException {
        String id = null;
        String target = null;
        Parameters customs = null;
        Info info = null;
        IDocumentFactory documentFactory = (IDocumentFactory)this.env.getProperty("FragmentDocumentFactory");
        int event = this.reader.getEventType();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = this.reader.getLocalName();
                    if ("fragmentInstance".equals(localName)) {
                        id = this.reader.getAttributeValue("", "id");
                        target = this.reader.getAttributeValue("", "href");
                        if (this.containsFragmentID(id)) {
                            this.removeFragmentID(id);
                            break;
                        }
                        StaxUtils.moveToEndElement("fragmentInstance", this.reader);
                        return;
                    }
                    if ("custom".equals(localName)) {
                        customs = this.readCustomXML();
                        break;
                    }
                    if (!"info".equals(localName)) break;
                    info = new Info();
                    info.read(this.reader);
                    break;
                }
                case 2: {
                    if (!"fragmentInstance".equals(this.reader.getLocalName())) break;
                    if (id != null && target != null) {
                        String instanceUniqueId = this.getUniqueID() + id;
                        Parameters instanceParameters = this.env.getParametersForSubFragment(instanceUniqueId);
                        if (instanceParameters == null) {
                            instanceParameters = new Parameters();
                        }
                        this.env.copyParametersForTarget(target, instanceParameters);
                        if (this.requestExecutor != null) {
                            xsw.writeCharacters("");
                            xsw.flush();
                            XMLTransactionalStreamWriter newXSW = xsw.spawnNewWriter();
                            DocumentRequest request = new DocumentRequest(this.requestExecutor, this.context, this.env, target, id, this.getRestrictedDocument(), info, customs, instanceParameters, this.logger, newXSW);
                            this.requestExecutor.execute(request);
                        } else {
                            DashboardDocument doc = documentFactory.createDocument(this.context, this.env, target, id, this.getRestrictedDocument(), info, customs, instanceParameters, this.logger);
                            try {
                                xsw.begin();
                                doc.writeXML(xsw);
                                xsw.commit();
                            }
                            catch (Throwable e) {
                                xsw.rollback();
                                doc = documentFactory.createErrorDocument(this.context, this.env, target, doc.getID(), this.getRestrictedDocument(), e, this.logger);
                                doc.writeXML(xsw);
                            }
                        }
                    }
                    return;
                }
            }
            event = this.reader.next();
        }
    }

    private void addFragmentID(String fragID) {
        if (this.fragments == null) {
            this.fragments = new ArrayList();
        }
        this.fragments.add(fragID);
    }

    private boolean containsFragmentID(String fragID) {
        if (this.fragments != null) {
            return this.fragments.contains(fragID);
        }
        return false;
    }

    private void removeFragmentID(String fragID) {
        if (this.fragments != null) {
            this.fragments.remove(fragID);
        }
    }

    @Override
    protected IRestrictedDocument getRestrictedDocument() {
        if (this.restrictedDocument == null) {
            this.restrictedDocument = this.requestExecutor == null ? new NonThreadSafeRestrictedDocument(this) : new ThreadSafeRestrictedDocument(this);
        }
        return this.restrictedDocument;
    }
}

