/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Info;
import com.cognos.portal.fragment.meta.ScriptLibrary;
import com.cognos.portal.fragment.meta.StyleLink;
import com.cognos.portal.fragment.server.DashboardContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.utils.BidiUtils;
import com.cognos.portal.utils.StringUtils;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PageHelpers {
    private static final String MACRO_SKIN = "$SKIN$";
    private static final String MACRO_CGI = "$CGI$";
    private static final String MACRO_WEB = "$WEB$";
    private static final String MACRO_PRODUCT_LOCALE = "$PRODUCT_LOCALE$";

    static void writeGlobalSettings(XMLStreamWriter xsw, Environment env, boolean fixedPage) throws XMLStreamException {
        xsw.writeStartElement("settings");
        StaxUtils.writeTextElement(xsw, "contextPath", env.getWebContent());
        StaxUtils.writeTextElement(xsw, "applicationGateway", env.getApplicationGatewayURI());
        StaxUtils.writeTextElement(xsw, "gateway", env.getGatewayURI());
        StaxUtils.writeTextElement(xsw, "helpPath", (String)env.getProperty("portal.help.path"));
        StaxUtils.writeTextElement(xsw, "helpSupportedLangs", (String)env.getProperty("portal.help.supportedLangs"));
        StaxUtils.writeTextElement(xsw, "helpDefaultBook", (String)env.getProperty("portal.help.defaultBook"));
        String doctype = env.getParameter("frag-doctype");
        StaxUtils.writeTextElement(xsw, "doctype", "standards".equals(doctype) ? "standards" : "quirks");
        StaxUtils.writeTextElement(xsw, "productLocale", env.getProductLocale());
        StaxUtils.writeTextElement(xsw, "responsePattern", (String)env.getProperty("portal.fragment.response.pattern"));
        StaxUtils.writeTextElement(xsw, "cookieSecure", (String)env.getProperty("cookieSecure"));
        boolean isRTL = !"false".equals(env.getUserPreference("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled")) && BidiUtils.isRTLLocale(env.getProductLocale());
        StaxUtils.writeTextElement(xsw, "isRTL", String.valueOf(isRTL));
        StaxUtils.writeTextElement(xsw, "skin", env.getSkin());
        StaxUtils.writeTextElement(xsw, "browserAgent", env.getParameter("frag-agent"));
        StaxUtils.writeTextElement(xsw, "pageFixed", String.valueOf(fixedPage));
        if ("controller".equals(env.getParameter("frag-debug")) || "true".equals(env.getProperty("controller.debug"))) {
            StaxUtils.writeTextElement(xsw, "debug", "true");
            StaxUtils.writeTextElement(xsw, "debugFile", (String)env.getProperty("controller.debug.file"));
            StaxUtils.writeTextElement(xsw, "debugIELiteFile", (String)env.getProperty("controller.debug.IELite.file"));
            StaxUtils.writeTextElement(xsw, "debugIELiteLevel", (String)env.getProperty("controller.debug.IELite.level"));
            xsw.writeStartElement("debugObjects");
            Map map = (Map)env.getProperty("controller.debug.objects");
            for (Map.Entry entry : map.entrySet()) {
                xsw.writeStartElement("debugObject");
                xsw.writeAttribute("name", entry.getKey().toString());
                xsw.writeAttribute("setting", entry.getValue().toString());
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    static void writeUserInfo(XMLStreamWriter xsw, Environment env) throws XMLStreamException {
        String userName;
        xsw.writeStartElement("userInfo");
        String userID = env.getUserID();
        if (userID != null) {
            xsw.writeAttribute("userid", userID);
        }
        if ((userName = env.getUserName()) != null) {
            xsw.writeAttribute("username", userName);
        }
        xsw.writeEndElement();
    }

    static void writeApplication(XMLStreamWriter xsw, DashboardContext context, Environment env, DashboardDocument doc) throws XMLStreamException {
        try {
            XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader(env.getTargetStream("/application.xml", null));
            Info appInfo = null;
            Info docInfo = doc.getInfo();
            if (StaxUtils.moveToElement("application", reader)) {
                int event = reader.next();
                while (event != 8) {
                    switch (event) {
                        case 1: {
                            String localName = reader.getLocalName();
                            if ("info".equals(localName)) {
                                appInfo = new Info();
                                appInfo.read(reader);
                                if (docInfo != null && docInfo.getTitle() != null) {
                                    appInfo.setTitle(docInfo.getTitle());
                                }
                                appInfo.write(xsw);
                                break;
                            }
                            xsw.writeStartElement(localName);
                            int count = reader.getAttributeCount();
                            for (int i = 0; i < count; ++i) {
                                String name = reader.getAttributeLocalName(i);
                                String value = reader.getAttributeValue(i);
                                xsw.writeAttribute(name, value);
                            }
                            if ("libraries".equals(localName)) {
                                PageHelpers.readLibraries(reader, doc, env);
                                Iterator it = doc.getLibraries();
                                while (it.hasNext()) {
                                    ScriptLibrary lib = (ScriptLibrary)it.next();
                                    lib.write(xsw);
                                }
                                xsw.writeEndElement();
                                break;
                            }
                            if (!"styles".equals(localName)) break;
                            PageHelpers.readStyles(reader, doc, env);
                            Iterator it = doc.getStyleLinks();
                            while (it.hasNext()) {
                                StyleLink css = (StyleLink)it.next();
                                css.write(xsw);
                            }
                            xsw.writeEndElement();
                            break;
                        }
                        case 2: {
                            if ("application".equals(reader.getLocalName())) {
                                if (appInfo == null && docInfo != null && docInfo.getTitle() != null) {
                                    appInfo = new Info();
                                    appInfo.setTitle(docInfo.getTitle());
                                    appInfo.write(xsw);
                                }
                                return;
                            }
                            xsw.writeEndElement();
                            break;
                        }
                        case 4: {
                            xsw.writeCharacters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                            break;
                        }
                        case 12: {
                            xsw.writeCData(reader.getText());
                        }
                    }
                    event = reader.next();
                }
            }
        }
        catch (DashboardException dashboardException) {
            // empty catch block
        }
    }

    private static void readLibraries(XMLStreamReader reader, DashboardDocument doc, Environment env) throws XMLStreamException {
        int index = 0;
        int event = reader.getEventType();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!"library".equals(reader.getLocalName())) break;
                    PageHelpers.insertLibrary(reader, doc, env, index++);
                    break;
                }
                case 2: {
                    if ("library".equals(reader.getLocalName())) break;
                    return;
                }
            }
            event = reader.next();
        }
    }

    private static void insertLibrary(XMLStreamReader reader, DashboardDocument doc, Environment env, int index) {
        String src = reader.getAttributeValue("", "href");
        doc.insertLibrary(new ScriptLibrary(reader.getAttributeValue("", "type"), PageHelpers.expandMacros(env, src)), index);
    }

    static void readLibrary(XMLStreamReader reader, DashboardDocument doc, Environment env) throws XMLStreamException {
        String src = reader.getAttributeValue("", "href");
        doc.addLibrary(new ScriptLibrary(reader.getAttributeValue("", "type"), PageHelpers.expandMacros(env, src)));
    }

    private static void readStyles(XMLStreamReader reader, DashboardDocument doc, Environment env) throws XMLStreamException {
        int event = reader.getEventType();
        while (event != 8) {
            switch (event) {
                case 1: {
                    if (!"css".equals(reader.getLocalName())) break;
                    PageHelpers.readCSS(reader, doc, env);
                    break;
                }
                case 2: {
                    if ("css".equals(reader.getLocalName())) break;
                    return;
                }
            }
            event = reader.next();
        }
    }

    static void readCSS(XMLStreamReader reader, DashboardDocument doc, Environment env) throws XMLStreamException {
        String href = reader.getAttributeValue("", "href");
        doc.addStyleLink(new StyleLink(reader.getAttributeValue("", "type"), reader.getAttributeValue("", "media"), PageHelpers.expandMacros(env, href)));
    }

    static String expandMacros(Environment env, String str) {
        str = StringUtils.replaceMacro(str, MACRO_WEB, env.getWebContent());
        str = StringUtils.replaceMacro(str, MACRO_CGI, env.getApplicationGatewayURI());
        str = StringUtils.replaceMacro(str, MACRO_SKIN, env.getSkin());
        str = StringUtils.replaceMacro(str, MACRO_PRODUCT_LOCALE, env.getProductLocale());
        return str;
    }
}

