/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.document;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.thread.DefaultRerunnable;
import com.cognos.portal.thread.RerunnableThread;
import com.cognos.portal.thread.ThreadPool;
import com.cognos.portal.utils.LocalizableException;

class RequestExecutor {
    private static final int MAXIMUM_CONCURRENT_WORKERS = 5;
    private static final int DEFAULT_MAXIMUM_QUEUE_WAITTIME = 120000;
    private int maxConcurentWorkers;
    private int currentlyRunningRequests;
    private int overallRequestsCount;
    private int maxQueueWaitTime;
    private ThreadPool threadpool;
    private ServiceLogger logger;

    public RequestExecutor(ThreadPool threadPool, int max, int maxQueueWaitTime, ServiceLogger logger) {
        this.logger = logger;
        this.currentlyRunningRequests = 0;
        this.overallRequestsCount = 0;
        this.threadpool = threadPool;
        this.maxConcurentWorkers = max <= 0 ? 5 : max;
        this.maxQueueWaitTime = maxQueueWaitTime <= 0 ? 120000 : maxQueueWaitTime;
    }

    public synchronized void waitForAllRequests(int maximumWait) {
        long startTime = System.currentTimeMillis();
        while (this.overallRequestsCount > 0) {
            try {
                this.wait(maximumWait);
                long finishTime = System.currentTimeMillis();
                if (finishTime - startTime < (long)maximumWait) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.overallRequestsCount == 0;
    }

    public synchronized int getQueuedRequestsCount() {
        return this.overallRequestsCount - this.currentlyRunningRequests;
    }

    public void execute(Request request) throws DashboardException {
        try {
            RerunnableThread thread = this.threadpool.acquireThread();
            thread.getRerunnable().initialize(request, null);
            this.increaseRequestsCount();
            thread.execute();
        }
        catch (LocalizableException e) {
            throw new DashboardException("pf.fragment.server.executionfailed", e);
        }
    }

    private synchronized void notifyFinished(String id) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The request with id '" + id + "' is finished.");
        }
        --this.overallRequestsCount;
        --this.currentlyRunningRequests;
        this.notifyAll();
    }

    private synchronized void startRequest(String id) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Starting the request with id '" + id + "' ");
        }
        this.waitUntilAvailable(id);
        ++this.currentlyRunningRequests;
    }

    private synchronized void increaseRequestsCount() {
        ++this.overallRequestsCount;
    }

    private synchronized void waitUntilAvailable(String id) {
        while (this.currentlyRunningRequests >= this.maxConcurentWorkers) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Blocking the request with id '" + id + "' until a request is available");
                this.logger.debug("currently running: " + this.currentlyRunningRequests);
                this.logger.debug("maximum concurrent workers: " + this.maxConcurentWorkers);
            }
            try {
                this.wait(this.maxQueueWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Done blocking the request with id '" + id + "'");
        }
    }

    static abstract class Request
    implements DefaultRerunnable.Request {
        private RequestExecutor requestExecutor;
        private String id;

        public Request(String id, RequestExecutor requestExecutor) {
            this.requestExecutor = requestExecutor;
            this.id = id;
        }

        @Override
        public void run() {
            this.requestExecutor.startRequest(this.id);
            try {
                this.runImpl();
            }
            finally {
                this.requestExecutor.notifyFinished(this.id);
            }
        }

        protected abstract void runImpl();
    }
}

