/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.Cookie;
import com.cognos.portal.fragment.meta.Meta;
import com.cognos.portal.fragment.meta.MetaProperty;
import com.cognos.portal.fragment.server.Constants;
import com.cognos.portal.fragment.server.document.DashboardDocument;
import com.cognos.portal.fragment.server.pipeline.CMFragmentProvider;
import com.cognos.portal.fragment.server.pipeline.helper.Fragment;
import com.cognos.portal.fragment.server.pipeline.helper.NavHelper;
import com.cognos.portal.soap.IXMLHandler;
import com.cognos.portal.soap.SOAPConnection;
import com.cognos.portal.soap.SOAPConnectionFactory;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.soap.SOAPMessage;
import com.cognos.portal.soap.impl.bus.cm.Query;
import com.cognos.portal.soap.impl.bus.cm.UpdatePortletContext;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.TrustedSessionHelper;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.pipeline.IProcess;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class CMBaseProvider
implements IProcess {
    private ServiceLogger logger;
    private String name;
    private boolean trustedConnection;

    public CMBaseProvider(ServiceLogger logger, boolean trusted) {
        this.logger = logger != null ? logger.cloneForClass(CMFragmentProvider.class) : null;
        this.trustedConnection = trusted;
    }

    @Override
    public void initialize(Map inputs) throws PipelineException {
    }

    public abstract void callCM(String var1, PipelineContext var2, XMLStreamWriter var3) throws PipelineException;

    @Override
    public void execute(PipelineContext context) throws PipelineException {
        String href = (String)context.getParam("href");
        Parameters customs = (Parameters)context.getParam("customUpdate");
        Parameters parameters = (Parameters)context.getParam("params");
        String action = null;
        IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
        if (parameters != null) {
            action = parameters.getValue("frag-action");
        }
        if (href != null && (customs != null || "reset".equals(action))) {
            if (href.startsWith("/cmprovider/")) {
                this.updateCustom(href, customs, context, action);
                context.addOutput("result", output);
            }
        } else {
            String searchPath = null;
            String extraInfo = (String)context.getParam("extraInfo");
            if (extraInfo != null && extraInfo.length() > 1) {
                StringTokenizer tokens = new StringTokenizer(extraInfo, "/");
                if (tokens.hasMoreTokens()) {
                    String id = tokens.nextToken();
                    searchPath = "storeID('" + id + "')";
                }
            } else if (parameters != null) {
                searchPath = parameters.getValue("path");
            }
            if (searchPath != null) {
                try {
                    this.callCM(searchPath, context, output.getXMLStreamWriter());
                }
                catch (InvalidCredentialsFault e) {
                    output = PipelineOutputFactory.getInstance().createOutput();
                    this.writeInvalidPassportError(output.getXMLStreamWriter(), e);
                }
                context.addOutput("result", output);
            }
        }
    }

    private void writeInvalidPassportError(XMLStreamWriter xsw, InvalidCredentialsFault invalidPassport) throws PipelineException {
        try {
            xsw.writeStartDocument();
            xsw.writeStartElement("fragment");
            xsw.writeStartElement("error");
            xsw.writeStartElement("code");
            xsw.writeCharacters("invalidCredentials");
            xsw.writeEndElement();
            xsw.writeStartElement("message");
            xsw.writeCharacters(invalidPassport.getMessage());
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new PipelineException("pf.fragment.server.executionfailed", e);
        }
    }

    private void updateCustom(String href, Parameters customs, PipelineContext pipelineContext, String action) throws PipelineException {
        Environment env = pipelineContext.getEnv();
        ArrayList cookies = new ArrayList();
        env.createCookieList(cookies);
        String userSessionId = null;
        for (Cookie cookie : cookies) {
            if (!"usersessionid".equals(cookie.getName())) continue;
            userSessionId = cookie.getValue();
            break;
        }
        String authtoken = pipelineContext.getEnv().getParameter("frag-authToken");
        if (!TrustedSessionHelper.getInstance().verifyAuthenticityToken(authtoken, userSessionId)) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Verification of frag-authToken has failed.");
            }
            throw new PipelineException("pf.fragment.validation.verifyfailed");
        }
        int index = href.indexOf(63);
        if (index != -1) {
            href = href.substring(0, index);
        }
        index = href.lastIndexOf(47);
        String portletInstanceId = null;
        String portletId = null;
        if (index != -1) {
            portletInstanceId = href.substring(index + 1);
            portletId = href.substring(0, index);
            if ((index = portletId.lastIndexOf(47)) != -1) {
                portletId = portletId.substring(index + 1);
            }
        }
        if (portletInstanceId != null) {
            UpdatePortletContext update = new UpdatePortletContext();
            StringBuffer context = new StringBuffer();
            if ("reset".equals(action)) {
                Fragment portlet = this.getPortletFragment(portletId, pipelineContext);
                try {
                    customs.add(portlet.getCustomParameters());
                }
                catch (XMLStreamException e) {
                    throw new PipelineException("error getting custom parameters", e);
                }
            }
            String wsrp_context = customs.getValue("wsrp_portlet_context");
            String wsrp_handle = customs.getValue("wsrp_portlet_handle");
            String wsrp_state_extensions = customs.getValue("wsrp_portlet_state_extension");
            context.append("<wsrp:portletContext xmlns:wsrp=\"urn:oasis:names:tc:wsrp:v1:types\"><wsrp:portletHandle>");
            if (wsrp_handle != null) {
                EncodingUtils.xmlEncode(wsrp_handle, context);
            } else {
                Fragment portlet = this.getPortletFragment(portletId, pipelineContext);
                String ph = portlet.getHandle();
                EncodingUtils.xmlEncode(ph + "#" + portletInstanceId, context);
            }
            context.append("</wsrp:portletHandle><wsrp:portletState>");
            EncodingUtils.xmlEncode(wsrp_context != null ? wsrp_context : DashboardDocument.encodeCustoms(customs), context);
            context.append("</wsrp:portletState>");
            if (wsrp_context == null) {
                Meta meta = (Meta)pipelineContext.getParam("meta");
                if (meta != null) {
                    Enumeration enumeration = meta.getCustomProperties();
                    boolean foundExternalRef = false;
                    while (enumeration.hasMoreElements()) {
                        String propName;
                        String value;
                        MetaProperty prop = (MetaProperty)enumeration.nextElement();
                        if (!Constants.FRAGMENT_CM_PROVIDER.CM_OBJECT_DATATYPE.equals(prop.getDataType()) || (value = customs.getValue(propName = prop.getName())) == null || value.length() <= 0) continue;
                        if (!foundExternalRef) {
                            context.append("<wsrp:extensions><cpsext:state xmlns:cpsext=\"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/\">");
                            foundExternalRef = true;
                        }
                        context.append("<cpsext:externalRef type=\"cm\" name=\"");
                        EncodingUtils.xmlEncode(propName, context);
                        context.append("\">");
                        EncodingUtils.xmlEncode(value, context);
                        context.append("</cpsext:externalRef>");
                        if (!value.startsWith("storeID(") && value.charAt(0) != '/') {
                            value = "storeID('" + value + "')";
                        }
                        update.addExternalReference(propName, value);
                    }
                    if (foundExternalRef) {
                        context.append("</cpsext:state></wsrp:extensions>");
                    }
                }
            } else if (wsrp_state_extensions != null) {
                context.append("<wsrp:extensions>");
                context.append(wsrp_state_extensions);
                context.append("</wsrp:extensions>");
                try {
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(wsrp_state_extensions));
                    while (xsr.hasNext()) {
                        int event = xsr.next();
                        if (event != 1 || !"externalRef".equals(xsr.getLocalName())) continue;
                        String name = xsr.getAttributeValue("", "name");
                        String type = xsr.getAttributeValue("", "type");
                        String searchPath = null;
                        String value = xsr.getElementText();
                        if (value != null && value.length() > 0) {
                            searchPath = type != null && type.equals("cm") ? (value.startsWith("storeID(") || value.startsWith("/") ? value : "storeID('" + value + "')") : NavHelper.getSearchPathFromNavId(value);
                        }
                        if (searchPath == null || searchPath.equals("root") || "userDefault".equals(value)) continue;
                        update.addExternalReference(name, searchPath);
                    }
                }
                catch (XMLStreamException e) {
                    throw new PipelineException("pf.fragment.bridge.xml.error", e);
                }
            }
            context.append("</wsrp:portletContext>");
            if (portletInstanceId.equals(portletId)) {
                update.setObjectClass("portlet");
            }
            update.setSearchPath("storeID(\"" + portletInstanceId + "\")");
            update.setContext(context.toString());
            Object header = pipelineContext.getParam("busHeader");
            update.setBusHeader(header != null ? header.toString() : null);
            this.sendCMRequest(update, pipelineContext);
        }
    }

    private Fragment getPortletFragment(String portletId, PipelineContext pipelineContext) throws PipelineException {
        Query query = new Query();
        query.setSearchPath("storeID(\"" + portletId + "\")");
        query.addProperty("handle");
        query.addProperty("context");
        query.addProperty("deploymentReferences");
        Object header = pipelineContext.getParam("busHeader");
        query.setBusHeader(header != null ? header.toString() : null);
        final Fragment portletFrag = new Fragment(pipelineContext);
        query.setResponseBodyHandler(new IXMLHandler(){

            @Override
            public void handle(XMLStreamReader reader) throws XMLStreamException {
                while (reader.hasNext()) {
                    int event = reader.next();
                    if (event != 1 || !"item".equals(reader.getLocalName())) continue;
                    portletFrag.read(reader);
                }
            }
        });
        this.sendCMRequest(query, pipelineContext);
        return portletFrag;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected void sendCMRequest(SOAPMessage message, PipelineContext pipelineContext) throws PipelineException {
        SOAPConnection connection = this.trustedConnection ? ((SOAPConnectionFactory)pipelineContext.getEnv().getProperty("consumerTrustedSoapConnectionFactory")).createConnection(this.logger) : ((SOAPConnectionFactory)pipelineContext.getEnv().getProperty("SoapConnectionFactory")).createConnection(this.logger);
        try {
            connection.execute(message, (String)pipelineContext.getEnv().getProperty("contentManager"));
        }
        catch (MalformedURLException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("bad url.", e);
            }
            throw new PipelineException("error while retrieving object from CM", e);
        }
        catch (SOAPFault e) {
            String detail = e.getDetail();
            if (detail != null && detail.indexOf("CM-REQ-4159") != -1) {
                throw new InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, e);
            }
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Content Manager returned a fault in the response.", e);
            }
            throw new PipelineException("error while retrieving object from CM", e);
        }
        catch (IOException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an IO exception while retrieving the object from cm.", e);
            }
            throw new PipelineException("error while retrieving object from CM", e);
        }
        catch (XMLStreamException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Encountered an xml stream exception while retrieving the object from cm.", e);
            }
            throw new PipelineException("error while retrieving object from CM", e);
        }
    }

    @Override
    public boolean canShare() {
        return true;
    }
}

