/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.fragment.server.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.CCLLocaleUtils;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.StaxUtils;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class RequestConfigurationProcess
extends Stage {
    private ServiceLogger logger;
    private static final String CONST_ID = "id";
    private static final String CONST_INCLUDE_CONFIG = "included-config";
    private static final String CONST_CONFIG = "config";
    private static final String CONST_PARAM = "param";
    private static final String CONST_NAME = "name";
    private static final String CONST_CONTENTLOCALES = "contentLocales";
    private static final String CONST_PRODUCTLOCALES = "productLocales";
    private static final String CONST_LOCALE = "locale";
    private static final String CONST_TIMEZONES = "timezones";
    private static final String CONST_TIMEZONE = "timezone";
    private static final String CONST_CURRENCIES = "currencies";
    private static final String CONST_CURRENCY = "currency";
    private static final String CONST_WEB_CONTENT = "webContent";
    private static final String CONST_GATEWAY = "gateway";
    private static final String CONST_CONFIGURATIONRESPONSE = "configurationResponse";

    public RequestConfigurationProcess(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(RequestConfigurationProcess.class) : null;
    }

    @Override
    public void executeImpl(StageContext context) throws PipelineException {
        try {
            XMLStreamReader reader = context.getInputAsXMLStreamReader(CONST_INCLUDE_CONFIG);
            IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
            XMLStreamWriter xsw = output.getXMLStreamWriter();
            xsw.writeStartDocument();
            xsw.writeStartElement(CONST_CONFIG);
            StaxUtils.moveToElement(CONST_CONFIG, reader);
            boolean isCCLConfig = false;
            while (reader.hasNext()) {
                String sParamName;
                int event = reader.next();
                if (event != 1 || !reader.getLocalName().equals(CONST_PARAM) || (sParamName = reader.getAttributeValue("", CONST_NAME)) == null) continue;
                if (sParamName.equals(CONST_CONTENTLOCALES)) {
                    xsw.writeStartElement(CONST_PARAM);
                    xsw.writeAttribute(CONST_NAME, CONST_CONTENTLOCALES);
                    this.writeLocales(xsw, CCLLocaleUtils.getLocalizedContentLocales(context.getEnv().getProductLocale()));
                    xsw.writeEndElement();
                    continue;
                }
                if (sParamName.equals(CONST_PRODUCTLOCALES)) {
                    xsw.writeStartElement(CONST_PARAM);
                    xsw.writeAttribute(CONST_NAME, CONST_PRODUCTLOCALES);
                    this.writeLocales(xsw, CCLLocaleUtils.getLocalizedProductLocales(context.getEnv().getProductLocale()));
                    xsw.writeEndElement();
                    continue;
                }
                if (sParamName.equals(CONST_TIMEZONES)) {
                    xsw.writeStartElement(CONST_PARAM);
                    xsw.writeAttribute(CONST_NAME, CONST_TIMEZONES);
                    this.writeTimezones(xsw, CCLLocaleUtils.getLocalizedTimeZones(context.getEnv().getProductLocale()));
                    xsw.writeEndElement();
                    continue;
                }
                if (sParamName.equals(CONST_CURRENCIES)) {
                    xsw.writeStartElement(CONST_PARAM);
                    xsw.writeAttribute(CONST_NAME, CONST_CURRENCIES);
                    this.writeCurrencies(xsw, CCLLocaleUtils.getLocalizedCurrencies(context.getEnv().getProductLocale()));
                    xsw.writeEndElement();
                    continue;
                }
                if (sParamName.equals(CONST_WEB_CONTENT)) {
                    xsw.writeStartElement(CONST_PARAM);
                    xsw.writeAttribute(CONST_NAME, CONST_WEB_CONTENT);
                    xsw.writeCharacters(context.getEnv().getWebContent());
                    xsw.writeEndElement();
                    continue;
                }
                if (sParamName.equals(CONST_GATEWAY)) {
                    xsw.writeStartElement(CONST_PARAM);
                    xsw.writeAttribute(CONST_NAME, CONST_GATEWAY);
                    xsw.writeCharacters(context.getEnv().getGatewayURI());
                    xsw.writeEndElement();
                    continue;
                }
                xsw.writeStartElement(CONST_PARAM);
                xsw.writeAttribute(CONST_NAME, sParamName);
                String value = (String)context.getEnv().getProperty(sParamName);
                if (value != null) {
                    xsw.writeCharacters(value);
                }
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
            context.addOutput(CONST_CONFIGURATIONRESPONSE, output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeCurrencies(XMLStreamWriter xsw, Map currencies) throws XMLStreamException {
        for (Map.Entry pair : currencies.values()) {
            xsw.writeStartElement(CONST_CURRENCY);
            xsw.writeAttribute(CONST_ID, (String)pair.getKey());
            xsw.writeCharacters((String)pair.getValue());
            xsw.writeEndElement();
        }
    }

    private void writeTimezones(XMLStreamWriter xsw, Map timezones) throws XMLStreamException {
        for (Map.Entry pair : timezones.values()) {
            xsw.writeStartElement(CONST_TIMEZONE);
            xsw.writeAttribute(CONST_ID, (String)pair.getKey());
            xsw.writeCharacters((String)pair.getValue());
            xsw.writeEndElement();
        }
    }

    private void writeLocales(XMLStreamWriter xsw, Map locales) throws XMLStreamException {
        for (Map.Entry pair : locales.values()) {
            xsw.writeStartElement(CONST_LOCALE);
            xsw.writeAttribute(CONST_ID, (String)pair.getKey());
            xsw.writeCharacters((String)pair.getValue());
            xsw.writeEndElement();
        }
    }

    @Override
    public boolean canShare() {
        return true;
    }
}

